/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import uk.ac.reload.dweezil.gui.DweezilComboBox;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.datamodel.ElementBinding;
import uk.ac.reload.jdom.XMLDocument;
import uk.ac.reload.jdom.XMLDocumentListener;
import uk.ac.reload.jdom.XMLDocumentListenerEvent;
import uk.ac.reload.jdom.XMLPath;
import uk.ac.reload.moonunit.SchemaDocument;
import uk.ac.reload.moonunit.schema.SchemaAttribute;
import uk.ac.reload.moonunit.schema.SchemaNode;
import uk.ac.reload.moonunit.vocab.VocabularyList;

public class AttributeEditor
extends JPanel
implements XMLDocumentListener {
    private JTable table;
    private AbstractTableModel tableModel;
    private ElementBinding _elementBinding;
    static /* synthetic */ Class class$java$lang$Object;

    public AttributeEditor() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
        this.setBorder(null);
        this.tableModel = this.createTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setSelectionMode(0);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(60);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(140);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setDefaultEditor(class$java$lang$Object == null ? (class$java$lang$Object = AttributeEditor.class$("java.lang.Object")) : class$java$lang$Object, this.createTableCellEditor());
        AttributeCellRenderer cellRenderer = new AttributeCellRenderer();
        this.table.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = AttributeEditor.class$("java.lang.Object")) : class$java$lang$Object, cellRenderer);
        JScrollPane sp = new JScrollPane(this.table);
        this.add((Component)sp, "Center");
    }

    public void setElementBinding(ElementBinding elementBinding) {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        if (this._elementBinding != null) {
            this._elementBinding.getSchemaDocument().removeXMLDocumentListener((XMLDocumentListener)this);
        }
        this._elementBinding = elementBinding;
        this._elementBinding.getSchemaDocument().addXMLDocumentListener((XMLDocumentListener)this);
        this.tableModel.fireTableDataChanged();
    }

    public ElementBinding getElementBinding() {
        return this._elementBinding;
    }

    public void cleanup() {
        if (this._elementBinding != null) {
            this._elementBinding.getSchemaDocument().removeXMLDocumentListener((XMLDocumentListener)this);
        }
    }

    protected TableCellEditor createTableCellEditor() {
        return new AttributeCellEditor();
    }

    protected AbstractTableModel createTableModel() {
        return new AttributeTableModel();
    }

    public void elementChanged(XMLDocumentListenerEvent event) {
        Element changed_element;
        if (event.getSource() == this) {
            return;
        }
        Element element = this._elementBinding.getElement();
        if (element != null && element == (changed_element = event.getElement())) {
            this.repaint();
        }
    }

    public void elementRemoved(XMLDocumentListenerEvent event) {
    }

    public void elementAdded(XMLDocumentListenerEvent event) {
    }

    public void documentSaved(XMLDocument doc) {
    }

    public Attribute getAttribute(int attIndex) {
        List list;
        Attribute att = null;
        SchemaAttribute schemaAttribute = this.getSchemaAttribute(attIndex);
        if (schemaAttribute != null && this._elementBinding.getElement() != null) {
            String attName = schemaAttribute.getName();
            if (schemaAttribute.isExternalNamespace()) {
                Namespace ns = schemaAttribute.getNamespace();
                att = this._elementBinding.getElement().getAttribute(attName, ns);
            } else {
                att = this._elementBinding.getElement().getAttribute(attName);
            }
        } else if (this._elementBinding.getElement() != null && attIndex < (list = this._elementBinding.getElement().getAttributes()).size()) {
            att = (Attribute)list.get(attIndex);
        }
        return att;
    }

    public String getAttributeFriendlyName(int attIndex) {
        String fname = "";
        SchemaAttribute schemaAttribute = this.getSchemaAttribute(attIndex);
        if (schemaAttribute != null) {
            fname = this._elementBinding.getSchemaController().getElementFriendlyName(schemaAttribute.getXMLPath());
            if (fname == null) {
                fname = schemaAttribute.getName();
            }
        } else {
            Attribute att = this.getAttribute(attIndex);
            if (att != null && (fname = this._elementBinding.getSchemaController().getElementFriendlyName(XMLPath.getXMLPathForAttribute((Attribute)att))) == null) {
                fname = att.getName();
            }
        }
        return fname;
    }

    public String getAttributeToolTip(int attIndex) {
        String tip = null;
        SchemaAttribute schemaAttribute = this.getSchemaAttribute(attIndex);
        if (schemaAttribute != null) {
            tip = this._elementBinding.getSchemaController().getElementTip(schemaAttribute.getXMLPath());
        } else {
            Attribute att = this.getAttribute(attIndex);
            if (att != null) {
                tip = this._elementBinding.getSchemaController().getElementTip(XMLPath.getXMLPathForAttribute((Attribute)att));
            }
        }
        return tip;
    }

    public VocabularyList getAttributeVocabulary(int attIndex) {
        VocabularyList vocab = null;
        SchemaAttribute schemaAttribute = this.getSchemaAttribute(attIndex);
        if (schemaAttribute != null) {
            vocab = this._elementBinding.getSchemaController().getVocabularyList((SchemaNode)schemaAttribute);
        }
        return vocab;
    }

    public SchemaAttribute getSchemaAttribute(int attIndex) {
        return this._elementBinding.getSchemaElement() == null ? null : this._elementBinding.getSchemaElement().getSchemaAttributeAtIndex(attIndex);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class ComboBoxTipRenderer
    extends BasicComboBoxRenderer {
        protected ComboBoxTipRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected && index > -1 && value != null) {
                list.setToolTipText(value.toString());
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    protected class AttributeCellRenderer
    extends DefaultTableCellRenderer {
        protected AttributeCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String tip = AttributeEditor.this.getAttributeToolTip(row);
            this.setToolTipText(tip);
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    protected class AttributeCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        protected DweezilComboBox comboBox;
        protected JTextField textField = new JTextField();
        protected DefaultCellEditor editor;
        protected DefaultCellEditor textEditor;
        protected DefaultCellEditor comboEditor;

        public AttributeCellEditor() {
            this.textField.setBorder(null);
            this.textEditor = new DefaultCellEditor(this.textField);
            this.comboBox = new DweezilComboBox(true);
            this.comboBox.setBorder(null);
            this.comboBox.setFont(this.textField.getFont());
            this.comboBox.setRenderer((ListCellRenderer)new ComboBoxTipRenderer());
            this.comboEditor = new DefaultCellEditor((JComboBox<?>)this.comboBox);
        }

        public Object getCellEditorValue() {
            return this.editor.getCellEditorValue();
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            VocabularyList vocab = AttributeEditor.this.getAttributeVocabulary(row);
            if (vocab != null) {
                this.editor = this.comboEditor;
                this.comboBox.setItems((Object[])vocab.getList());
                this.comboBox.setEditable(true);
            } else {
                this.editor = this.textEditor;
            }
            return this.editor.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    protected class AttributeTableModel
    extends AbstractTableModel {
        String[] cNames = new String[]{Messages.getString("uk.ac.reload.editor.gui.AttributeEditor.0"), Messages.getString("uk.ac.reload.editor.gui.AttributeEditor.1")};

        protected AttributeTableModel() {
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (aValue == null || !(aValue instanceof String)) {
                return;
            }
            if (columnIndex == 1) {
                String oldValue;
                SchemaDocument doc = AttributeEditor.this._elementBinding.getSchemaDocument();
                Element element = AttributeEditor.this._elementBinding.getElement();
                if (element == null) {
                    element = AttributeEditor.this._elementBinding.createElement(this);
                }
                if (element == null) {
                    return;
                }
                Attribute att = AttributeEditor.this.getAttribute(rowIndex);
                String string = oldValue = att == null ? null : att.getValue();
                if (!aValue.equals(oldValue)) {
                    SchemaAttribute schemaAttribute;
                    if (aValue.equals("")) {
                        if (att != null) {
                            element.removeAttribute(att);
                            doc.changedElement((Object)AttributeEditor.this, element);
                        }
                        return;
                    }
                    if (att == null && (schemaAttribute = AttributeEditor.this.getSchemaAttribute(rowIndex)) != null) {
                        att = doc.addAttribute((Object)AttributeEditor.this, element, schemaAttribute);
                    }
                    if (att != null) {
                        att.setValue((String)aValue);
                        doc.changedElement((Object)AttributeEditor.this, element);
                    }
                }
            }
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return AttributeEditor.this.getAttributeFriendlyName(rowIndex);
                }
                case 1: {
                    Attribute att = AttributeEditor.this.getAttribute(rowIndex);
                    return att == null ? null : att.getValue();
                }
            }
            return "";
        }

        public int getColumnCount() {
            return this.cNames.length;
        }

        public String getColumnName(int columnIndex) {
            return this.cNames[columnIndex];
        }

        public int getRowCount() {
            if (AttributeEditor.this._elementBinding != null) {
                if (AttributeEditor.this._elementBinding.getSchemaElement() != null) {
                    SchemaAttribute[] atts = AttributeEditor.this._elementBinding.getSchemaElement().getSchemaAttributes();
                    return atts.length;
                }
                if (AttributeEditor.this._elementBinding.getElement() != null) {
                    List list = AttributeEditor.this._elementBinding.getElement().getAttributes();
                    return list.size();
                }
            }
            return 0;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }
    }
}

