/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.gui.widgets;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import org.jdom.Attribute;
import org.jdom.Element;
import uk.ac.reload.dweezil.gui.FlatComboBox;
import uk.ac.reload.editor.datamodel.DataElement;

public class DataElementComboBox
extends FlatComboBox
implements ItemListener {
    private DataElement _dataElement;
    private String _attName;

    public DataElementComboBox() {
    }

    public DataElementComboBox(Object[] objects) {
        super(objects);
        this.setUI();
    }

    public void setAttribute(DataElement dataElement, String attName, String defValue) {
        this._dataElement = dataElement;
        this._attName = attName;
        Element element = this._dataElement.getElement();
        if (element != null) {
            Attribute att = element.getAttribute(attName);
            if (att != null && !"".equals(att.getValue())) {
                defValue = att.getValue();
            } else if (defValue != null) {
                element.setAttribute(this._attName, defValue);
            }
            this.removeItemListener(this);
            this.setSelectedItem(defValue);
        }
        this.addItemListener(this);
    }

    public void setElement(DataElement dataElement, String defValue) {
        this._dataElement = dataElement;
        this._attName = null;
        Element element = this._dataElement.getElement();
        if (element != null) {
            if (!"".equals(element.getText())) {
                defValue = element.getText();
            } else if (defValue != null) {
                element.setText(defValue);
            }
            this.removeItemListener(this);
            this.setSelectedItem(defValue);
        }
        this.addItemListener(this);
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 2) {
            return;
        }
        Element element = this._dataElement.getElement();
        if (element == null) {
            element = this._dataElement.createElement();
        }
        if (element != null) {
            String selection = this.getSelectedItem().toString();
            if (this._attName != null) {
                if ("".equals(selection)) {
                    element.removeAttribute(this._attName);
                } else {
                    element.setAttribute(this._attName, selection);
                }
            } else {
                element.setText(selection);
            }
            this._dataElement.getDataModel().getSchemaDocument().changedElement((Object)this, element);
        }
    }
}

