/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.gui.widgets;

import java.awt.Color;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdom.Element;
import uk.ac.reload.dweezil.gui.layout.SGLayout;
import uk.ac.reload.editor.datamodel.DataElement;
import uk.ac.reload.editor.datamodel.types.DurationType;
import uk.ac.reload.editor.gui.widgets.NumberFieldWidget;

public class DataElementDurationField
extends JPanel {
    private DurationNumberField _years;
    private DurationNumberField _months;
    private DurationNumberField _days;
    private DurationNumberField _hours;
    private DurationNumberField _mins;
    private DurationNumberField _secs;
    private boolean doNotify = true;
    private DataElement _dataElement;
    private DurationType _durationType;

    public DataElementDurationField() {
        this.setup();
    }

    protected void setup() {
        this.setOpaque(false);
        SGLayout layout = new SGLayout(2, 6, 10, 0);
        this.setLayout((LayoutManager)layout);
        this._years = new DurationNumberField("y");
        this._months = new DurationNumberField("m");
        this._days = new DurationNumberField("d");
        this._hours = new DurationNumberField("h");
        this._mins = new DurationNumberField("mm");
        this._secs = new DurationNumberField("s");
        this.add(this.createLabel("Yrs"));
        this.add(this.createLabel("Mons"));
        this.add(this.createLabel("Days"));
        this.add(this.createLabel("Hrs"));
        this.add(this.createLabel("Mins"));
        this.add(this.createLabel("Secs"));
        this.add(this._years);
        this.add(this._months);
        this.add(this._days);
        this.add(this._hours);
        this.add(this._mins);
        this.add(this._secs);
    }

    protected JLabel createLabel(String text) {
        JLabel l = new JLabel();
        l.setText(text);
        l.setHorizontalAlignment(0);
        return l;
    }

    public void clear() {
        this._dataElement = null;
        this._durationType = null;
        this.doNotify = false;
        this._years.setText("");
        this._months.setText("");
        this._days.setText("");
        this._hours.setText("");
        this._mins.setText("");
        this._secs.setText("");
        this.doNotify = true;
        this.setEditable(false);
    }

    public void setEditable(boolean editable) {
        this._years.setEditable(editable);
        this._months.setEditable(editable);
        this._days.setEditable(editable);
        this._hours.setEditable(editable);
        this._mins.setEditable(editable);
        this._secs.setEditable(editable);
    }

    public void setElement(DataElement dataElement) {
        this._dataElement = dataElement;
        this._durationType = new DurationType();
        Element element = this._dataElement.getElement();
        if (element != null) {
            this._durationType.setDurationString(element.getText());
        }
        this.doNotify = false;
        this._years.setText(Integer.toString(this._durationType.getYears()));
        this._months.setText(Integer.toString(this._durationType.getMonths()));
        this._days.setText(Integer.toString(this._durationType.getDays()));
        this._hours.setText(Integer.toString(this._durationType.getHours()));
        this._mins.setText(Integer.toString(this._durationType.getMinutes()));
        this._secs.setText(Integer.toString(this._durationType.getSeconds()));
        this.doNotify = true;
        this.setEditable(true);
    }

    class DurationNumberField
    extends NumberFieldWidget
    implements DocumentListener {
        private String _field;

        public DurationNumberField(String field) {
            super(4);
            this._field = field;
            this.getDocument().addDocumentListener(this);
        }

        protected void setUI() {
            this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        }

        public void changedUpdate(DocumentEvent e) {
            this.notifyTextChange();
        }

        public void insertUpdate(DocumentEvent e) {
            this.notifyTextChange();
        }

        public void removeUpdate(DocumentEvent e) {
            this.notifyTextChange();
        }

        protected void notifyTextChange() {
            if (DataElementDurationField.this.doNotify && DataElementDurationField.this._dataElement != null) {
                Element element = DataElementDurationField.this._dataElement.getElement();
                if (element == null) {
                    element = DataElementDurationField.this._dataElement.createElement();
                }
                if (element != null) {
                    int val;
                    try {
                        val = Integer.parseInt(this.getText());
                    }
                    catch (NumberFormatException ex) {
                        val = 0;
                    }
                    if ("y".equals(this._field)) {
                        DataElementDurationField.this._durationType.setYears(val);
                    } else if ("m".equals(this._field)) {
                        DataElementDurationField.this._durationType.setMonths(val);
                    } else if ("d".equals(this._field)) {
                        DataElementDurationField.this._durationType.setDays(val);
                    } else if ("h".equals(this._field)) {
                        DataElementDurationField.this._durationType.setHours(val);
                    } else if ("mm".equals(this._field)) {
                        DataElementDurationField.this._durationType.setMinutes(val);
                    } else if ("s".equals(this._field)) {
                        DataElementDurationField.this._durationType.setSeconds(val);
                    }
                    String duration = DataElementDurationField.this._durationType.getDurationString();
                    if (duration == null) {
                        element.setText("P0Y");
                    } else {
                        element.setText(duration);
                    }
                    DataElementDurationField.this._dataElement.getDataModel().getSchemaDocument().changedElement((Object)this, element);
                }
            }
        }
    }
}

