/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.datamodel.components.environments;

import java.util.Iterator;
import java.util.Vector;
import javax.swing.Icon;
import org.jdom.Element;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.datamodel.MetadataType;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Service;
import uk.ac.reload.editor.learningdesign.datamodel.components.roles.Learner;
import uk.ac.reload.editor.learningdesign.datamodel.components.roles.Learner_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.roles.Role;
import uk.ac.reload.jdom.XMLPath;
import uk.ac.reload.moonunit.SchemaDocument;

public class SendMail
extends Service {
    public static XMLPath XMLPATH = new XMLPath(XMLPATH_ROOT_LD).appendElementName("components/environments/environment/service/send-mail");
    public static XMLPath XMLPATH_EMAILDATA = new XMLPath(XMLPATH).appendElementName("email-data");
    static final String DESCRIPTION = "Send Mail Service.";
    private MetadataType _mdType;

    public SendMail(LD_DataModel ldDataModel, Element element) {
        super(ldDataModel, element);
        this.setDescription(DESCRIPTION);
        ldDataModel.addIDataModelListener(this);
    }

    public void setElement(Element element) {
        super.setElement(element);
        this.ensureDefaults();
    }

    protected void ensureDefaults() {
        this.ensureRoleRefs();
        this.ensureAttribute(this.getElement(), "select", "all-persons-in-role");
    }

    protected boolean ensureRoleRefs() {
        boolean modified = false;
        Learner_Grouping learnerGrouping = this.getLD_DataModel().getRoles_Grouping().getLearner_Grouping();
        Learner learner = (Learner)learnerGrouping.getChildAt(0);
        String learnerId = learner == null ? "" : learner.getIdentifier();
        Element[] roleRefs = this.getRoleRefElements();
        for (int i = 0; i < roleRefs.length; ++i) {
            String ref = roleRefs[i].getAttributeValue("ref");
            Role role = (Role)this.getLD_DataModel().getRoles_Grouping().getChildByIdentifer(ref);
            if (role != null) continue;
            if (roleRefs.length == 1) {
                roleRefs[i].setAttribute("ref", learnerId);
            } else {
                SchemaDocument schemaDocument = this.getDataModel().getSchemaDocument();
                schemaDocument.removeElement((Object)this, roleRefs[i].getParent());
            }
            modified = true;
        }
        return modified;
    }

    protected boolean ensureDefaultRoleRef() {
        Learner_Grouping learnerGrouping;
        Learner learner;
        boolean modified = false;
        Element[] roleRefs = this.getRoleRefElements();
        if (roleRefs.length == 0 && (learner = (Learner)(learnerGrouping = this.getLD_DataModel().getRoles_Grouping().getLearner_Grouping()).getChildAt(0)) != null) {
            this.addRoleRef(learner);
            modified = true;
        }
        return modified;
    }

    public void addRoleRef(Role role) {
        Element elRoleRef = this.getRoleRefElement(role);
        if (elRoleRef != null) {
            return;
        }
        Element elEmailData = this.addChildElement(this.getElement(), "email-data");
        if (elEmailData != null && (elRoleRef = elEmailData.getChild("role-ref", elEmailData.getNamespace())) != null) {
            elRoleRef.setAttribute("ref", role.getIdentifier());
            this.getDataModel().fireDataComponentChanged(this);
        }
    }

    public void removeRoleRef(Role role) {
        Element elRoleRef = this.getRoleRefElement(role);
        if (elRoleRef != null) {
            SchemaDocument schemaDocument = this.getDataModel().getSchemaDocument();
            schemaDocument.removeElement((Object)this, elRoleRef.getParent());
            this.getDataModel().fireDataComponentChanged(this);
            this.ensureDefaultRoleRef();
        }
    }

    public Role[] getRoles() {
        Vector<Role> v = new Vector<Role>();
        Element[] roleRefs = this.getRoleRefElements();
        for (int i = 0; i < roleRefs.length; ++i) {
            String ref = roleRefs[i].getAttributeValue("ref");
            Role role = (Role)this.getLD_DataModel().getRoles_Grouping().getChildByIdentifer(ref);
            if (role == null) continue;
            v.add(role);
        }
        Object[] roles = new Role[v.size()];
        v.copyInto(roles);
        return roles;
    }

    public Element[] getRoleRefElements() {
        Vector<Element> v = new Vector<Element>();
        Iterator it = this.getElement().getChildren("email-data", this.getElement().getNamespace()).iterator();
        while (it.hasNext()) {
            Element elEmailData = (Element)it.next();
            Element elRoleRef = elEmailData.getChild("role-ref", elEmailData.getNamespace());
            if (elRoleRef == null) continue;
            v.add(elRoleRef);
        }
        Object[] elements = new Element[v.size()];
        v.copyInto(elements);
        return elements;
    }

    public Element[] getEmailDataElements() {
        Vector<Element> v = new Vector<Element>();
        Iterator it = this.getElement().getChildren("email-data", this.getElement().getNamespace()).iterator();
        while (it.hasNext()) {
            Element elEmailData = (Element)it.next();
            v.add(elEmailData);
        }
        Object[] elements = new Element[v.size()];
        v.copyInto(elements);
        return elements;
    }

    public boolean isLastRoleRef() {
        return this.getElement().getChildren("email-data", this.getElement().getNamespace()).size() == 1;
    }

    public Element getRoleRefElement(Role role) {
        if (role == null) {
            return null;
        }
        String id = role.getIdentifier();
        Element[] roleRefs = this.getRoleRefElements();
        for (int i = 0; i < roleRefs.length; ++i) {
            String ref = roleRefs[i].getAttributeValue("ref");
            if (!id.equals(ref)) continue;
            return roleRefs[i];
        }
        return null;
    }

    public String getDefaultTitle() {
        return "Send Mail";
    }

    public Icon getIcon() {
        return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/sendmail.gif");
    }

    public XMLPath getXMLPath() {
        return XMLPATH;
    }

    public MetadataType getMetadataType() {
        if (this._mdType == null) {
            this._mdType = new MetadataType(this.getDataElement(), "Metadata", "Metadata for the SendMail.");
        }
        return this._mdType;
    }

    public void componentRemoved(DataComponent component) {
        boolean modified;
        if (component instanceof Role && (modified = this.ensureRoleRefs())) {
            this.getDataModel().fireDataComponentChanged(this);
        }
    }
}

