/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.datamodel.method;

import javax.swing.Icon;
import org.jdom.Element;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.IDataComponentIcon;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Component;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.datamodel.components.activities.ActivityStructure;
import uk.ac.reload.editor.learningdesign.datamodel.components.activities.LearningActivity;
import uk.ac.reload.editor.learningdesign.datamodel.components.activities.SupportActivity;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Environment;
import uk.ac.reload.editor.learningdesign.datamodel.components.roles.Learner;
import uk.ac.reload.editor.learningdesign.datamodel.components.roles.Learner_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.roles.Role;
import uk.ac.reload.editor.learningdesign.datamodel.method.Act;
import uk.ac.reload.jdom.XMLPath;

public class RolePart
extends LD_Component
implements IDataComponentIcon {
    public static XMLPath XMLPATH = new XMLPath(XMLPATH_ROOT_LD).appendElementName("method/play/act/role-part");
    static final String DEFAULT_TITLE = "Role Part";
    static final String DESCRIPTION = "This section provides information about the Role Part. A Role Part consists of one Role and one Activity, Environment or Unit of Learning.";
    private Role _role;
    private LD_Component _component;

    public RolePart(LD_DataModel ldDataModel, Element element) {
        this.setDataModel(ldDataModel);
        this.setElement(element);
        this.setDescription(DESCRIPTION);
        ldDataModel.addIDataModelListener(this);
    }

    public void setElement(Element element) {
        super.setElement(element);
        this.ensureTitleElement();
        if (this.getIdentifier() == null) {
            this.addIdentifier();
        }
        this.ensureRoleRef();
    }

    protected boolean ensureRoleRef() {
        boolean modified = false;
        Learner_Grouping learnerGrouping = this.getLD_DataModel().getRoles_Grouping().getLearner_Grouping();
        Learner learner = (Learner)learnerGrouping.getChildAt(0);
        String learnerId = learner == null ? "" : learner.getIdentifier();
        this._role = null;
        this._role = this.getReferencedRole();
        if (this._role == null) {
            this.getRoleRefElement().setAttribute("ref", learnerId);
            this._role = learner;
            modified = true;
        }
        return modified;
    }

    public Element getRoleRefElement() {
        return this.ensureChildElement(this.getElement(), "role-ref");
    }

    public Role getReferencedRole() {
        if (this._role == null) {
            Element roleRef = this.getRoleRefElement();
            String ref = roleRef.getAttributeValue("ref");
            this._role = (Role)this.getLD_DataModel().getRoles_Grouping().getChildByIdentifer(ref);
        }
        return this._role;
    }

    public void setReferencedRole(Role role) {
        Element roleRef = this.getRoleRefElement();
        String roleRefID = roleRef.getAttributeValue("ref");
        String roleId = role.getIdentifier();
        if (roleRefID != null && !roleRefID.equals(roleId)) {
            roleRef.setAttribute("ref", roleId);
            this._role = role;
            this.getDataModel().fireDataComponentChanged(this);
            this.getDataModel().getSchemaDocument().changedElement((Object)this, roleRef);
        }
    }

    public LD_Component getReferencedComponent() {
        if (this._component == null) {
            this._component = this.__getReferencedComponent("environment-ref", this.getLD_DataModel().getEnvironment_Grouping());
            if (this._component == null) {
                this._component = this.__getReferencedComponent("learning-activity-ref", this.getLD_DataModel().getActivities_Grouping().getLearningActivity_Grouping());
            }
            if (this._component == null) {
                this._component = this.__getReferencedComponent("support-activity-ref", this.getLD_DataModel().getActivities_Grouping().getSupportActivity_Grouping());
            }
            if (this._component == null) {
                this._component = this.__getReferencedComponent("activity-structure-ref", this.getLD_DataModel().getActivities_Grouping().getActivityStructure_Grouping());
            }
        }
        return this._component;
    }

    private LD_Component __getReferencedComponent(String type, LD_Component parentComponent) {
        Element element = this.getElement().getChild(type, this.getElement().getNamespace());
        if (element != null) {
            String ref = element.getAttributeValue("ref");
            return parentComponent.getChildByIdentifer(ref);
        }
        return null;
    }

    public void setReferencedComponent(LD_Component component) {
        Element element = this.getElement().getChild("environment-ref", this.getElement().getNamespace());
        if (element == null) {
            element = this.getElement().getChild("learning-activity-ref", this.getElement().getNamespace());
        }
        if (element == null) {
            element = this.getElement().getChild("support-activity-ref", this.getElement().getNamespace());
        }
        if (element == null) {
            element = this.getElement().getChild("activity-structure-ref", this.getElement().getNamespace());
        }
        if (element == null) {
            element = this.getElement().getChild("unit-of-learning-href", this.getElement().getNamespace());
        }
        if (element != null) {
            this.getDataModel().getSchemaDocument().removeElement((Object)this, element);
        }
        if (component instanceof Environment) {
            element = this.addChildElement(this.getElement(), "environment-ref");
        } else if (component instanceof LearningActivity) {
            element = this.addChildElement(this.getElement(), "learning-activity-ref");
        } else if (component instanceof SupportActivity) {
            element = this.addChildElement(this.getElement(), "support-activity-ref");
        } else if (component instanceof ActivityStructure) {
            element = this.addChildElement(this.getElement(), "activity-structure-ref");
        }
        if (element != null && component != null) {
            String id = component.getIdentifier();
            element.setAttribute("ref", id);
        }
        this._component = null;
        this.getDataModel().fireDataComponentChanged(this);
    }

    public void setTitle(String title) {
        this.setTitleElement(title);
    }

    public boolean canDelete() {
        return this.getParent() == null ? true : ((Act)this.getParent()).getChildren().length > 1;
    }

    public Icon getIcon() {
        return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/role_part.gif");
    }

    public XMLPath getXMLPath() {
        return XMLPATH;
    }

    public String getDefaultTitle() {
        return DEFAULT_TITLE;
    }

    public void componentChanged(DataComponent component) {
        if (component == this.getReferencedRole() || component == this.getReferencedComponent()) {
            this.getDataModel().fireDataComponentChanged(this);
        }
    }

    public void componentRemoved(DataComponent component) {
        if (component instanceof Role) {
            boolean modified = this.ensureRoleRef();
            if (modified) {
                this.getDataModel().fireDataComponentChanged(this);
            }
        } else if (component == this.getReferencedComponent()) {
            this.setReferencedComponent(null);
        }
    }
}

