/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.environment;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import uk.ac.reload.dweezil.gui.CoolBarPanel;
import uk.ac.reload.dweezil.gui.IComponentSelectionListener;
import uk.ac.reload.dweezil.menu.DweezilMenuEvent;
import uk.ac.reload.dweezil.menu.MenuAction;
import uk.ac.reload.dweezil.menu.ProxyAction;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.IIcons;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.DataModel;
import uk.ac.reload.editor.datamodel.IDataComponentIcon;
import uk.ac.reload.editor.datamodel.IDataModelListener;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.IndexSearch;
import uk.ac.reload.editor.menu.MainMenu;

public abstract class IndexSearchListPanel
extends CoolBarPanel
implements IDataModelListener,
IIcons {
    private DataModel _dataModel;
    private IndexSearch _is;
    private JList _list;
    private MenuAction_Add _menuAdd;
    private MenuAction_Delete _menuDelete;
    private ProxyDeleteHandler _deleteHandler;

    protected IndexSearchListPanel(String title, Icon icon, int listHeight) {
        this.setText(title);
        this.setIcon(icon);
        this._menuAdd = new MenuAction_Add();
        this.addMenuActionToCoolBar(this._menuAdd);
        this._menuDelete = new MenuAction_Delete();
        this.addMenuActionToCoolBar(this._menuDelete);
        JScrollPane sp = new JScrollPane(this.getList());
        sp.setPreferredSize(new Dimension(0, listHeight));
        sp.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.setMainComponent(sp);
        this.getList().setCellRenderer(new ComponentListRenderer());
        this.getList().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    IndexSearchListPanel.this.updateMenus();
                }
            }
        });
        this.addComponentSelectionListener(new IComponentSelectionListener(){

            public void componentSelected(Component component) {
                IndexSearchListPanel.this.getList().requestFocus();
            }
        });
        this.setSelected(true);
        this._deleteHandler = new ProxyDeleteHandler();
        this.getList().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (!e.isTemporary()) {
                    IndexSearchListPanel.this._deleteHandler.update();
                }
            }

            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    IndexSearchListPanel.this._deleteHandler.clear();
                }
            }
        });
    }

    public void setIndexSearch(IndexSearch is) {
        this._is = is;
        if (this.getDataModel() == null) {
            this.setDataModel(is.getDataModel());
        }
        this.updateListModel();
        this.updateMenus();
    }

    public IndexSearch getIndexSearch() {
        return this._is;
    }

    public void setDataModel(DataModel dataModel) {
        this._dataModel = dataModel;
        this._dataModel.addIDataModelListener(this);
    }

    public DataModel getDataModel() {
        return this._dataModel;
    }

    public JList getList() {
        if (this._list == null) {
            this._list = new JList();
        }
        return this._list;
    }

    protected void updateMenus() {
        Object[] components = this.getList().getSelectedValues();
        this._menuDelete.setEnabled(components.length > 0);
        this._deleteHandler.update();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this._menuAdd.setEnabled(false);
            this._menuDelete.setEnabled(false);
        } else {
            this._menuAdd.setEnabled(true);
            this.updateMenus();
        }
        this.getList().setEnabled(enabled);
    }

    protected abstract void updateListModel();

    protected abstract void showSelectorDialog();

    protected abstract void deleteListItems();

    public void cleanup() {
        this._deleteHandler.clear();
        if (this._dataModel != null) {
            this._dataModel.removeIDataModelListener(this);
        }
        this._dataModel = null;
    }

    public void componentAdded(DataComponent component) {
    }

    public void componentRemoved(DataComponent component) {
    }

    public void componentMoved(DataComponent component) {
    }

    public void componentChanged(DataComponent component) {
        if (component == this.getIndexSearch()) {
            this.updateListModel();
        }
    }

    protected class ProxyDeleteHandler
    extends ProxyAction {
        public ProxyDeleteHandler() {
            super((MenuAction)MainMenu.getSharedInstance().editMenu.actionDelete);
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            IndexSearchListPanel.this.deleteListItems();
        }

        public void update() {
            Object[] components = IndexSearchListPanel.this.getList().getSelectedValues();
            if (components.length > 0) {
                this.setEnabled(true);
                this.addListener();
            } else {
                this.clear();
            }
        }
    }

    protected class MenuAction_Delete
    extends MenuAction {
        public MenuAction_Delete() {
            super("Delete", "uk/ac/reload/editor/resources/images/delete.gif");
        }

        public void actionPerformed(ActionEvent e) {
            IndexSearchListPanel.this.deleteListItems();
        }
    }

    protected class MenuAction_Add
    extends MenuAction {
        public MenuAction_Add() {
            super("Add...", "uk/ac/reload/editor/resources/images/add.gif");
        }

        public void actionPerformed(ActionEvent e) {
            IndexSearchListPanel.this.showSelectorDialog();
        }
    }

    protected class ComponentListRenderer
    extends DefaultListCellRenderer {
        Icon indexClassIcon = DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/node.gif");

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof IDataComponentIcon) {
                this.setIcon(((IDataComponentIcon)value).getIcon());
            } else {
                this.setIcon(this.indexClassIcon);
            }
            return this;
        }
    }

    protected class StringListModel
    extends AbstractListModel {
        private String[] _strings;

        public StringListModel(String[] strings) {
            this._strings = strings;
        }

        public int getSize() {
            return this._strings.length;
        }

        public Object getElementAt(int index) {
            return this._strings[index];
        }
    }
}

