/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.general;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import uk.ac.reload.dweezil.gui.ComponentHiderLabelPanel;
import uk.ac.reload.dweezil.gui.LabelComponentPanel;
import uk.ac.reload.dweezil.gui.layout.SGLayout;
import uk.ac.reload.editor.datamodel.DataElement;
import uk.ac.reload.editor.gui.IdentifierLabelTextField;
import uk.ac.reload.editor.gui.NotesPanel;
import uk.ac.reload.editor.gui.widgets.DataElementTextField;
import uk.ac.reload.editor.learningdesign.datamodel.ILD_DataModelHandler;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.editor.shared.MetadataPanel;
import uk.ac.reload.editor.learningdesign.xml.LearningDesign;
import uk.ac.reload.jdom.XMLPath;

public class OverViewPanel
extends JPanel
implements ILD_DataModelHandler {
    static String TITLE = "Overview";
    static String DESCRIPTION = "This section describes the general features of the Learning Design.";
    static final int FIELDY_OFFSET = 5;
    static final int FIELDX_OFFSET = 100;
    static final boolean SHOW_IDENTIFIER = false;
    private LD_DataModel _ldDataModel;
    private ComponentHiderLabelPanel _hiderPanel;
    private IdentifierLabelTextField _tfIdentifier;
    private DataElementTextField _tfTitle;
    private DataElementTextField _tfURI;
    private DataElementTextField _tfVersion;
    private NotesPanel _notesPanel;
    private MetadataPanel _metadataPanel;

    public OverViewPanel() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout(10, 10));
        JPanel subPanel = new JPanel(new BorderLayout());
        subPanel.setBackground(new Color(240, 240, 254));
        subPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.gray), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.add((Component)subPanel, "Center");
        this._hiderPanel = new ComponentHiderLabelPanel("<html>" + TITLE, "<html>" + DESCRIPTION);
        this._hiderPanel.getComponentHiderButton().setComponent((JComponent)subPanel);
        this._hiderPanel.getComponentHiderButton().showComponent(false);
        this.add((Component)this._hiderPanel, "North");
        JPanel centrePanel = new JPanel(new BorderLayout());
        centrePanel.setOpaque(false);
        subPanel.add((Component)centrePanel, "Center");
        SGLayout fieldPanelLayout = new SGLayout(3, 1, 0, 5);
        JPanel fieldPanel = new JPanel((LayoutManager)fieldPanelLayout);
        fieldPanel.setOpaque(false);
        centrePanel.add((Component)fieldPanel, "Center");
        this._tfTitle = new DataElementTextField();
        LabelComponentPanel panelTitle = new LabelComponentPanel("Title:", (JComponent)this._tfTitle, 0.3, 0.0);
        fieldPanel.add((Component)panelTitle);
        this._tfURI = new DataElementTextField();
        LabelComponentPanel panelURI = new LabelComponentPanel("URI:", (JComponent)this._tfURI, 0.3, 0.0);
        fieldPanel.add((Component)panelURI);
        this._tfVersion = new DataElementTextField();
        LabelComponentPanel panelVersion = new LabelComponentPanel("Version:", (JComponent)this._tfVersion, 0.3, 0.0);
        fieldPanel.add((Component)panelVersion);
        this._metadataPanel = new MetadataPanel();
        this._metadataPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        centrePanel.add((Component)this._metadataPanel, "South");
        this._notesPanel = new NotesPanel("Author's Notes", "Author's local notes.");
        this._notesPanel.setPreferredSize(new Dimension(0, 200));
        this._notesPanel.showTextPane(false);
        this._notesPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        subPanel.add((Component)this._notesPanel, "South");
    }

    public void setDataModel(LD_DataModel ldDataModel) {
        this._ldDataModel = ldDataModel;
        LearningDesign ld = ldDataModel.getLearningDesign();
        Element rootLDElement = ld.getLDElement();
        DataElement ldRootElement = new DataElement(ldDataModel, rootLDElement);
        DataElement titleElement = new DataElement(ldDataModel, rootLDElement, new XMLPath("title"));
        this._tfTitle.setElement(titleElement);
        this._tfURI.setAttribute(ldRootElement, "uri", null);
        this._tfVersion.setAttribute(ldRootElement, "version", null);
        this._metadataPanel.setMetadataType(ldDataModel.getMetadataType());
        try {
            this._notesPanel.loadFile(new File(ldDataModel.getLearningDesign().getProjectFolder(), "reload-magicfolder/ld-authornotes.txt"));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void cleanup() {
        if (this._notesPanel != null) {
            this._notesPanel.cleanup();
        }
        if (this._metadataPanel != null) {
            this._metadataPanel.cleanup();
        }
        this._ldDataModel = null;
    }

    public boolean doSave() {
        return this._notesPanel.saveDocument();
    }
}

