/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.resources;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.jdom.Element;
import uk.ac.reload.dweezil.gui.tree.DweezilTreeNode;
import uk.ac.reload.dweezil.menu.DweezilMenuEvent;
import uk.ac.reload.dweezil.menu.MenuAction;
import uk.ac.reload.dweezil.menu.PopupMenuAction;
import uk.ac.reload.dweezil.menu.ProxyAction;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.dweezil.util.NativeLauncher;
import uk.ac.reload.editor.EditorFrame;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.gui.Editor_Tree;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.datamodel.resources.LD_Resource;
import uk.ac.reload.editor.learningdesign.datamodel.resources.LD_Resources;
import uk.ac.reload.editor.learningdesign.editor.resources.LD_ResourcesTree;
import uk.ac.reload.editor.learningdesign.editor.shared.LD_TreePanel;
import uk.ac.reload.editor.menu.MainMenu;

public class LD_ResourcesTreePanel
extends LD_TreePanel {
    private LD_ResourcesTree _tree;
    private MenuAction_Add _menuAdd;
    private LD_TreePanel.MenuAction_Delete _menuDelete;
    private ProxyLaunchFileHandler _launchFileHandler;

    public LD_ResourcesTreePanel() {
        this.setText("Resources");
        this.setIcon(DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/resources.gif"));
        this._menuAdd = new MenuAction_Add();
        this.addMenuActionToCoolBar((MenuAction)this._menuAdd);
        this._menuDelete = new LD_TreePanel.MenuAction_Delete(this);
        this.addMenuActionToCoolBar(this._menuDelete);
        this._launchFileHandler = new ProxyLaunchFileHandler();
        this.getTree().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (!e.isTemporary()) {
                    LD_ResourcesTreePanel.this._launchFileHandler.update();
                }
            }

            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    LD_ResourcesTreePanel.this._launchFileHandler.clear();
                }
            }
        });
    }

    public Editor_Tree getTree() {
        if (this._tree == null) {
            this._tree = new LD_ResourcesTree();
        }
        return this._tree;
    }

    public synchronized void updateMenus() {
        super.updateMenus();
        DataComponent component = null;
        DweezilTreeNode selNode = this.getTree().getSelectedNode();
        if (selNode != null) {
            component = (DataComponent)selNode.getUserObject();
        }
        this._menuAdd.newResource.setEnabled(component instanceof LD_Resources);
        this._menuAdd.newFile.setEnabled(component instanceof LD_Resource);
        this._menuAdd.newDependency.setEnabled(component instanceof LD_Resource);
        this._menuDelete.setEnabled(component != null && component.canDelete());
        this.getTree().getPopupMenu().removeAll();
        this.getTree().getPopupMenu().add((Action)this._menuAdd.newResource);
        this.getTree().getPopupMenu().add((Action)this._menuAdd.newFile);
        this.getTree().getPopupMenu().add((Action)this._menuAdd.newDependency);
        this.getTree().getPopupMenu().addSeparator();
        this.getTree().getPopupMenu().add((Action)((Object)this._menuDelete));
        this.getProxyLaunchFileHandler().update();
        this.getProxyDeleteHandler().update();
    }

    private void addNewResource(MenuAction menuAction) {
        String title = (String)JOptionPane.showInputDialog(EditorFrame.getInstance(), "Location:", menuAction.getText(), 3, menuAction.getMenuIcon(), null, "http://");
        if (title != null) {
            this.getTree().addNewElement("resource", title);
        }
    }

    public ProxyLaunchFileHandler getProxyLaunchFileHandler() {
        if (this._launchFileHandler == null) {
            this._launchFileHandler = new ProxyLaunchFileHandler();
        }
        return this._launchFileHandler;
    }

    public void cleanup() {
        if (this._launchFileHandler != null) {
            this._launchFileHandler.clear();
        }
        super.cleanup();
    }

    static /* synthetic */ void access$200(LD_ResourcesTreePanel x0, MenuAction x1) {
        x0.addNewResource(x1);
    }

    class ProxyLaunchFileHandler
    extends ProxyAction {
        String url;

        public ProxyLaunchFileHandler() {
            super((MenuAction)MainMenu.getSharedInstance().actionViewFile);
        }

        public void update() {
            DataComponent component = null;
            DweezilTreeNode selNode = LD_ResourcesTreePanel.this.getTree().getSelectedNode();
            if (selNode != null) {
                component = (DataComponent)selNode.getUserObject();
            }
            if (component != null) {
                Element element = component.getElement();
                this.url = ((LD_DataModel)LD_ResourcesTreePanel.this.getDataModel()).getLearningDesign().getAbsoluteURL(element);
                if (this.url != null) {
                    this.setEnabled(true);
                    this.addListener();
                } else {
                    this.clear();
                }
            } else {
                this.clear();
            }
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            if (this.url != null) {
                Thread thread = new Thread(this){
                    private final /* synthetic */ ProxyLaunchFileHandler this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        ProxyLaunchFileHandler.access$300(this.this$1).setCursor(DweezilUIManager.WAIT_CURSOR);
                        NativeLauncher.launchURL((String)this.this$1.url);
                        ProxyLaunchFileHandler.access$300(this.this$1).setCursor(DweezilUIManager.DEFAULT_CURSOR);
                    }
                };
                thread.start();
            }
        }

        static /* synthetic */ LD_ResourcesTreePanel access$300(ProxyLaunchFileHandler x0) {
            return x0.LD_ResourcesTreePanel.this;
        }
    }

    class MenuAction_Add
    extends PopupMenuAction {
        MenuAction newResource = new MenuAction(this, "New Resource", "uk/ac/reload/editor/resources/images/resource.gif"){
            private final /* synthetic */ MenuAction_Add this$1;
            {
                this.this$1 = this$1;
            }

            public void actionPerformed(ActionEvent e) {
                LD_ResourcesTreePanel.access$200(MenuAction_Add.access$100(this.this$1), this);
            }
        };
        MenuAction newFile;
        MenuAction newDependency;

        public MenuAction_Add() {
            super("Add", "uk/ac/reload/editor/resources/images/add.gif");
            this.getPopupMenu().add((Action)this.newResource);
            this.newFile = new MenuAction(this, "New File", "uk/ac/reload/editor/resources/images/file.gif"){
                private final /* synthetic */ MenuAction_Add this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    MenuAction_Add.access$100(this.this$1).getTree().addNewElement("file", null);
                }
            };
            this.getPopupMenu().add((Action)this.newFile);
            this.newDependency = new MenuAction(this, "New Dependency", "uk/ac/reload/editor/resources/images/dependency.gif"){
                private final /* synthetic */ MenuAction_Add this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    MenuAction_Add.access$100(this.this$1).getTree().addNewElement("dependency", null);
                }
            };
            this.getPopupMenu().add((Action)this.newDependency);
        }

        static /* synthetic */ LD_ResourcesTreePanel access$100(MenuAction_Add x0) {
            return x0.LD_ResourcesTreePanel.this;
        }
    }
}

