/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.roles;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import uk.ac.reload.dweezil.gui.GradientPanel;
import uk.ac.reload.dweezil.gui.tree.DweezilTreeNode;
import uk.ac.reload.editor.gui.GroupingPanel;
import uk.ac.reload.editor.learningdesign.datamodel.ILD_DataModelHandler;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Component;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.roles.Role;
import uk.ac.reload.editor.learningdesign.editor.roles.RoleEditorPanel;
import uk.ac.reload.editor.learningdesign.editor.roles.RoleTreePanel;
import uk.ac.reload.jdom.XMLPath;

public class RolesPanel
extends GradientPanel
implements TreeSelectionListener,
ILD_DataModelHandler {
    public static XMLPath XMLPATH = new XMLPath("learning-design/components/roles");
    private LD_DataModel _ldDataModel;
    private JSplitPane _splitPane;
    private RoleTreePanel _treePanel;
    private RoleEditorPanel _editorPanel;
    private JScrollPane _editorPanelScrollPane;
    private GroupingPanel _groupingPanel;
    private JPanel _cardPanel;
    private LD_Component _currentSelectedLD_Component;

    public RolesPanel() {
        super((LayoutManager)new BorderLayout());
        JLabel label = new JLabel("Roles");
        label.setFont(label.getFont().deriveFont(1, 16.0f));
        this.add(label, "North");
        this._splitPane = new JSplitPane(1);
        this._splitPane.setOneTouchExpandable(true);
        this.add(this._splitPane, "Center");
        this._splitPane.setLeftComponent((Component)((Object)this.getRoleTreePanel()));
        this._cardPanel = new JPanel(new CardLayout());
        this._splitPane.setRightComponent(this._cardPanel);
        this.getRoleTreePanel().getTree().addTreeSelectionListener(this);
    }

    public void setDataModel(LD_DataModel ldDataModel) {
        this._ldDataModel = ldDataModel;
        this.getRoleTreePanel().setDataModel(ldDataModel);
    }

    public void valueChanged(TreeSelectionEvent e) {
        Object obj;
        if (!e.isAddedPath()) {
            return;
        }
        TreePath selPath = e.getPath();
        Object selectedNode = selPath.getLastPathComponent();
        if (selectedNode instanceof DweezilTreeNode && (obj = ((DweezilTreeNode)selectedNode).getUserObject()) instanceof LD_Component) {
            this.updateEditorPanel((LD_Component)obj);
        }
    }

    protected void updateEditorPanel(LD_Component ldComponent) {
        if (ldComponent == this._currentSelectedLD_Component) {
            return;
        }
        String panelName = null;
        if (ldComponent instanceof LD_Grouping) {
            panelName = "#GROUPING_PANEL";
            if (this.getGroupingPanel().getParent() != this._cardPanel) {
                this._cardPanel.add((Component)((Object)this.getGroupingPanel()), panelName);
            }
            this.getGroupingPanel().setComponent(ldComponent);
        } else if (ldComponent instanceof Role) {
            panelName = "#ROLE_PANEL";
            if (this.getEditorPanelScrollPane().getParent() != this._cardPanel) {
                this._cardPanel.add((Component)this.getEditorPanelScrollPane(), panelName);
            }
            this.getRoleEditorPanel().setComponent(ldComponent);
        }
        if (panelName != null) {
            ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, panelName);
        }
        this._currentSelectedLD_Component = ldComponent;
    }

    protected void setupView() {
        super.setupView();
        Border border = BorderFactory.createEmptyBorder(5, 10, 5, 10);
        this.setBorder(border);
    }

    public void initView() {
        this._splitPane.setDividerLocation(0.33);
        this.getRoleTreePanel().setSelected(true);
    }

    public void cleanup() {
        if (this._treePanel != null) {
            this._treePanel.cleanup();
        }
        if (this._editorPanel != null) {
            this._editorPanel.cleanup();
        }
        if (this._groupingPanel != null) {
            this._groupingPanel.cleanup();
        }
        this._ldDataModel = null;
    }

    public boolean doSave() {
        return true;
    }

    public RoleEditorPanel getRoleEditorPanel() {
        if (this._editorPanel == null) {
            this._editorPanel = new RoleEditorPanel();
        }
        return this._editorPanel;
    }

    public JScrollPane getEditorPanelScrollPane() {
        if (this._editorPanelScrollPane == null) {
            this._editorPanelScrollPane = new JScrollPane((Component)((Object)this.getRoleEditorPanel()));
            this._editorPanelScrollPane.setBorder(null);
        }
        return this._editorPanelScrollPane;
    }

    public GroupingPanel getGroupingPanel() {
        if (this._groupingPanel == null) {
            this._groupingPanel = new GroupingPanel();
        }
        return this._groupingPanel;
    }

    public RoleTreePanel getRoleTreePanel() {
        if (this._treePanel == null) {
            this._treePanel = new RoleTreePanel();
        }
        return this._treePanel;
    }
}

