/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.shared;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jdom.Element;
import uk.ac.reload.dweezil.gui.FlatComboBox;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.dweezil.util.NativeLauncher;
import uk.ac.reload.editor.EditorFrame;
import uk.ac.reload.editor.IIcons;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.DataElement;
import uk.ac.reload.editor.datamodel.IDataModelListener;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.datamodel.resources.LD_Resource;
import uk.ac.reload.editor.learningdesign.xml.LearningDesign;

public class LD_ResourceSelector
extends JPanel
implements ItemListener,
IIcons,
IDataModelListener {
    private LD_DataModel _ldDataModel;
    private DataElement _dataElement;
    private LD_Resource[] _ldResources;
    private JComboBox _comboBox;
    private JButton _buttonFileView;

    public LD_ResourceSelector() {
        this.setup();
    }

    protected void setup() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getComboBox(), "Center");
        this.add((Component)this.getFileViewButton(), "East");
        this.setupFileViewAction();
        this.getComboBox().addItemListener(this);
    }

    public void setElement(DataElement dataElement) {
        this._dataElement = dataElement;
        if (this._ldDataModel == null) {
            this._ldDataModel = (LD_DataModel)this._dataElement.getDataModel();
            this.getComboBox().setModel(new DefaultComboBoxModel<LD_Resource>(this.getLD_Resources()));
            this._ldDataModel.addIDataModelListener(this);
        }
        this.setSelectedItem();
    }

    private void updateComboBox() {
        this.getComboBox().removeItemListener(this);
        this._ldResources = null;
        this.getComboBox().setModel(new DefaultComboBoxModel<LD_Resource>(this.getLD_Resources()));
        this.setSelectedItem();
        this.getComboBox().addItemListener(this);
    }

    private void setSelectedItem() {
        LD_Resource selection = null;
        Element element = this._dataElement.getElement();
        if (element != null) {
            String id_ref = element.getAttributeValue("identifierref");
            selection = this._ldDataModel.getResources().getLD_Resource(id_ref);
        }
        this.getComboBox().removeItemListener(this);
        this.getComboBox().setSelectedItem(selection);
        this.getComboBox().addItemListener(this);
    }

    public JComboBox getComboBox() {
        if (this._comboBox == null) {
            this._comboBox = new FlatComboBox();
        }
        return this._comboBox;
    }

    public JButton getFileViewButton() {
        if (this._buttonFileView == null) {
            ImageIcon icon = DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/viewfile.gif");
            this._buttonFileView = new JButton(icon);
            this._buttonFileView.setPreferredSize(new Dimension(24, 0));
            this._buttonFileView.setToolTipText("View File");
        }
        return this._buttonFileView;
    }

    protected void setupFileViewAction() {
        if (this.getFileViewButton() != null) {
            this.getFileViewButton().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (LD_ResourceSelector.this._dataElement == null || LD_ResourceSelector.this._dataElement.getElement() == null) {
                        return;
                    }
                    LearningDesign ld = LD_ResourceSelector.this._ldDataModel.getLearningDesign();
                    String url = ld.getAbsoluteURL(LD_ResourceSelector.this._dataElement.getElement());
                    if (url != null) {
                        NativeLauncher.launchURL((String)url);
                    } else {
                        JOptionPane.showMessageDialog(EditorFrame.getInstance(), "The Resource's URL does not exist!", "View File", 2);
                    }
                }
            });
        }
    }

    protected LD_Resource[] getLD_Resources() {
        if (this._ldResources == null) {
            DataComponent[] ldResources = this._ldDataModel.getResources().getChildren();
            this._ldResources = new LD_Resource[ldResources.length + 1];
            this._ldResources[0] = new LD_Resource(this._ldDataModel, null);
            System.arraycopy(ldResources, 0, this._ldResources, 1, ldResources.length);
        }
        return this._ldResources;
    }

    public void itemStateChanged(ItemEvent e) {
        LD_Resource ldResource;
        String id;
        if (e.getStateChange() == 2) {
            return;
        }
        Element element = this._dataElement.getElement();
        if (element == null) {
            element = this._dataElement.createElement();
        }
        if ((id = (ldResource = (LD_Resource)this.getComboBox().getSelectedItem()).getIdentifier()) == null) {
            element.removeAttribute("identifierref");
        } else {
            element.setAttribute("identifierref", id);
        }
        this._ldDataModel.getSchemaDocument().changedElement((Object)this, element);
    }

    public void cleanup() {
        if (this._comboBox != null) {
            this._comboBox.removeItemListener(this);
        }
        if (this._ldDataModel != null) {
            this._ldDataModel.removeIDataModelListener(this);
        }
        this._ldDataModel = null;
        this._dataElement = null;
        this._ldResources = null;
    }

    public void componentAdded(DataComponent component) {
        if (component instanceof LD_Resource) {
            this.updateComboBox();
        }
    }

    public void componentRemoved(DataComponent component) {
        if (component instanceof LD_Resource) {
            this.updateComboBox();
        }
    }

    public void componentMoved(DataComponent component) {
    }

    public void componentChanged(DataComponent component) {
    }
}

