/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.scorm.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jdom.Element;
import uk.ac.reload.dweezil.gui.layout.XYConstraints;
import uk.ac.reload.dweezil.gui.layout.XYLayout;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.EditorFrame;
import uk.ac.reload.editor.IIcons;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.contentpackaging.CP_EditorHandler;
import uk.ac.reload.editor.contentpackaging.xml.ContentPackage;
import uk.ac.reload.editor.datamodel.ElementBinding;
import uk.ac.reload.editor.gui.ElementAttributePanel;
import uk.ac.reload.editor.gui.ElementEditor;
import uk.ac.reload.moonunit.SchemaController;
import uk.ac.reload.moonunit.schema.SchemaElement;

public class SCORM12_EditorDialog
extends JDialog
implements IIcons {
    private ContentPackage _contentPackage;
    private Element _itemElement;
    private SchemaElement _schema_itemElement;
    private JList _itemListBox;
    private ElementAttributePanel _prereqEditor;
    private int WIDTH = 780;
    private int HEIGHT = 555;

    public SCORM12_EditorDialog(ContentPackage contentPackage, Element itemElement, SchemaElement schema_itemElement) {
        super(EditorFrame.getInstance(), Messages.getString("uk.ac.reload.editor.contentpackaging.scorm12.SCORM12_EditorDialog.0"), true);
        this._itemElement = itemElement;
        this._contentPackage = contentPackage;
        this._schema_itemElement = schema_itemElement;
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SCORM12_EditorDialog.this.dispose();
            }
        });
        JPanel mainPanel = this.createMainPanel();
        this.getContentPane().add((Component)mainPanel, "Center");
        JPanel buttonPanel = this.createButtonPanel();
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setSize(this.WIDTH, this.HEIGHT);
        this.setLocationRelativeTo(EditorFrame.getInstance());
    }

    protected JPanel createMainPanel() {
        JPanel mainPanel = new JPanel((LayoutManager)new XYLayout());
        int x = 5;
        int y = 5;
        JPanel prereqPanel = this.createPrerequisitesPanel();
        mainPanel.add((Component)prereqPanel, new XYConstraints(x, y, this.WIDTH - 15, 250));
        JPanel otherPanel = this.createSCORMElementsPanel();
        mainPanel.add((Component)otherPanel, new XYConstraints(x, y += 265, this.WIDTH - 15, 220));
        return mainPanel;
    }

    protected JPanel createPrerequisitesPanel() {
        JPanel panel = new JPanel((LayoutManager)new XYLayout());
        panel.setBorder(BorderFactory.createEtchedBorder());
        SchemaController schemaController = this._contentPackage.getSchemaController();
        SchemaElement prereqSchemaElement = this._schema_itemElement.getChild("prerequisites", CP_EditorHandler.ADLCP_NAMESPACE_12);
        if (prereqSchemaElement != null) {
            int x = 5;
            int y = 0;
            String name = schemaController.getElementFriendlyName(prereqSchemaElement.getXMLPath());
            JLabel nameLabel = new JLabel();
            nameLabel.setForeground(Color.BLUE);
            nameLabel.setFont(DweezilUIManager.boldFont12);
            nameLabel.setText(name);
            panel.add((Component)nameLabel, new XYConstraints(x, y, 100, 25));
            y += 35;
            Element element = this._itemElement.getChild(prereqSchemaElement.getName(), prereqSchemaElement.getNamespace());
            ElementBinding eb = new ElementBinding(element, prereqSchemaElement, this._contentPackage);
            if (element == null) {
                eb.setParentElement(this._itemElement);
            }
            this._prereqEditor = new ElementAttributePanel();
            this._prereqEditor.setElementBinding(eb);
            panel.add((Component)this._prereqEditor, new XYConstraints(x, y, 340, 200));
            JButton addButton = new JButton(DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/left.gif"));
            panel.add((Component)addButton, new XYConstraints(345, 120, 0, 0));
            addButton.addActionListener(new AddClick(this._prereqEditor));
            this._itemListBox = new JList(new ItemListModel());
            this._itemListBox.setSelectionMode(0);
            this._itemListBox.addMouseListener(new AddClick(this._prereqEditor));
            panel.add((Component)new JScrollPane(this._itemListBox), new XYConstraints(405, y, 340, 200));
        }
        return panel;
    }

    protected JPanel createSCORMElementsPanel() {
        JPanel panel = new JPanel((LayoutManager)new XYLayout());
        panel.setBorder(BorderFactory.createEtchedBorder());
        int x = 5;
        int y = 0;
        SchemaElement maxtimeallowedSchemaElement = this._schema_itemElement.getChild("maxtimeallowed", CP_EditorHandler.ADLCP_NAMESPACE_12);
        this.addElement(maxtimeallowedSchemaElement, panel, x, y, 120, 25);
        SchemaElement schemaElement = this._schema_itemElement.getChild("timelimitaction", CP_EditorHandler.ADLCP_NAMESPACE_12);
        this.addElement(schemaElement, panel, x, y += 60, 320, 100);
        x = 360;
        y = 0;
        schemaElement = this._schema_itemElement.getChild("datafromlms", CP_EditorHandler.ADLCP_NAMESPACE_12);
        this.addElement(schemaElement, panel, x, y, 200, 25);
        schemaElement = this._schema_itemElement.getChild("masteryscore", CP_EditorHandler.ADLCP_NAMESPACE_12);
        this.addElement(schemaElement, panel, x, y += 60, 200, 25);
        return panel;
    }

    protected void addElement(SchemaElement schemaElement, JPanel panel, int x, int y, int width, int height) {
        if (schemaElement != null) {
            SchemaController schemaController = this._contentPackage.getSchemaController();
            String name = schemaController.getElementFriendlyName(schemaElement.getXMLPath());
            JLabel nameLabel = new JLabel();
            nameLabel.setForeground(Color.BLUE);
            nameLabel.setFont(DweezilUIManager.boldFont12);
            nameLabel.setText(name);
            panel.add((Component)nameLabel, new XYConstraints(x, y, 100, 25));
            y += 30;
            Element element = this._itemElement.getChild(schemaElement.getName(), schemaElement.getNamespace());
            ElementBinding eb = new ElementBinding(element, schemaElement, this._contentPackage);
            if (element == null) {
                eb.setParentElement(this._itemElement);
            }
            ElementEditor elementEditor = new ElementEditor();
            elementEditor.setElementBinding(eb);
            panel.add((Component)elementEditor, new XYConstraints(x, y, width, height));
        }
    }

    protected JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton btnOK = new JButton(Messages.getString("uk.ac.reload.editor.contentpackaging.scorm12.SCORM12_EditorDialog.1"));
        btnOK.addActionListener(new OKClick());
        this.getRootPane().setDefaultButton(btnOK);
        buttonPanel.add(btnOK);
        return buttonPanel;
    }

    public void show() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SCORM12_EditorDialog.this._prereqEditor.getSplitpane().setDividerLocation(0.7);
            }
        });
        super.show();
    }

    protected void finish() {
        this.dispose();
    }

    public void dispose() {
        try {
            super.dispose();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    class ItemListModel
    extends AbstractListModel {
        Vector v = new Vector();

        public ItemListModel() {
            Element manifestElement = SCORM12_EditorDialog.this._contentPackage.getParentManifestElement(SCORM12_EditorDialog.this._itemElement);
            if (manifestElement != null) {
                Element[] items = SCORM12_EditorDialog.this._contentPackage.getElementsInManifest(manifestElement, "item", manifestElement.getNamespace());
                for (int i = 0; i < items.length; ++i) {
                    if (items[i].equals((Object)SCORM12_EditorDialog.this._itemElement)) continue;
                    ID_Mapping mapping = new ID_Mapping(items[i]);
                    this.v.add(mapping);
                }
            }
        }

        public int getSize() {
            return this.v.size();
        }

        public Object getElementAt(int index) {
            return this.v.elementAt(index);
        }
    }

    class ID_Mapping {
        Element _element;

        ID_Mapping(Element element) {
            this._element = element;
        }

        public String getIdentifier() {
            return this._element.getAttributeValue("identifier");
        }

        public String toString() {
            return SCORM12_EditorDialog.this._contentPackage.getElementDisplayName(this._element) + "   (" + this.getIdentifier() + ")";
        }
    }

    private class AddClick
    extends AbstractAction
    implements MouseListener {
        ElementAttributePanel _elementEditor;

        public AddClick(ElementAttributePanel elementEditor) {
            this._elementEditor = elementEditor;
        }

        public void actionPerformed(ActionEvent e) {
            this.addText();
        }

        private void addText() {
            String id;
            Object object = SCORM12_EditorDialog.this._itemListBox.getSelectedValue();
            if (object instanceof ID_Mapping && (id = ((ID_Mapping)object).getIdentifier()) != null) {
                this._elementEditor.getElementEditor().insertText(id);
                this._elementEditor.getElementEditor().setFocus();
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                this.addText();
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    private class OKClick
    extends AbstractAction {
        private OKClick() {
        }

        public void actionPerformed(ActionEvent e) {
            SCORM12_EditorDialog.this.finish();
        }
    }
}

