/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.moonunit;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import uk.ac.reload.diva.util.FileUtils;
import uk.ac.reload.jdom.XMLUtils;
import uk.ac.reload.moonunit.Messages;

public class HelperProfile {
    private Document _doc;
    private File _file;
    public static final String ELEMENT_ROOT_NAME = "profile";
    public static final String ATT_VOCAB = "vocabfile";
    public static final String ATT_SCHEMA_HELPER = "schemahelperfile";
    public static final String ATT_SCHEMA_VERSION = "schemaversion";
    private File _vocabFolder;
    private File _schemaHelperFolder;
    private static Hashtable _helperProfileTable = new Hashtable();

    public static HelperProfile getHelperProfile(File fileProfile, File vocabFolder, File schemaHelperFolder) throws JDOMException, IOException {
        HelperProfile profile = (HelperProfile)_helperProfileTable.get(fileProfile);
        if (profile == null) {
            profile = new HelperProfile(fileProfile, vocabFolder, schemaHelperFolder);
            _helperProfileTable.put(fileProfile, profile);
        }
        return profile;
    }

    public HelperProfile() {
        this._doc = new Document();
        this._doc.setRootElement(new Element(ELEMENT_ROOT_NAME));
    }

    public HelperProfile(File fileProfile, File vocabFolder, File schemaHelperFolder) throws JDOMException, IOException {
        this._file = fileProfile;
        this._vocabFolder = vocabFolder;
        this._schemaHelperFolder = schemaHelperFolder;
        this.load();
    }

    public static String[] getHelperProfileNames(File profileFolder) {
        FileFilter filter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return false;
                }
                return FileUtils.getFileExtension((File)file).equals("xml");
            }
        };
        Vector<String> v = new Vector<String>();
        File[] files = profileFolder.listFiles(filter);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                v.addElement(FileUtils.getFileNameWithoutExtension((File)files[i]));
            }
        }
        Object[] profiles = new String[v.size()];
        v.copyInto(profiles);
        Arrays.sort(profiles);
        return profiles;
    }

    public void load() throws FileNotFoundException, JDOMException, IOException {
        this._doc = XMLUtils.readXMLFile((File)this.getFile());
    }

    public void save() throws IOException {
        if (this._file != null) {
            XMLUtils.write2XMLFile((Document)this._doc, (File)this.getFile());
        }
    }

    protected void setFile(File file) {
        this._file = file;
    }

    public File getFile() {
        return this._file;
    }

    public Document getDocument() {
        return this._doc;
    }

    public String getProfileName() {
        return this._file == null ? Messages.getString("uk.ac.reload.moonunit.HelperProfile.1") : FileUtils.getFileNameWithoutExtension((File)this._file);
    }

    public String getVocabularyFileName() {
        return this.getRootAttributeValue(ATT_VOCAB);
    }

    public void setVocabularyFileName(String vocabularyFilename) {
        this._doc.getRootElement().setAttribute(ATT_VOCAB, vocabularyFilename);
    }

    public String getSchemaHelperFileName() {
        return this.getRootAttributeValue(ATT_SCHEMA_HELPER);
    }

    public void setSchemaHelperFileName(String schemaHelperFileName) {
        this._doc.getRootElement().setAttribute(ATT_SCHEMA_HELPER, schemaHelperFileName);
    }

    public String getSchemaVersion() {
        return this.getRootAttributeValue(ATT_SCHEMA_VERSION);
    }

    public void setSchemaVersion(String schemaVersion) {
        this._doc.getRootElement().setAttribute(ATT_SCHEMA_VERSION, schemaVersion);
    }

    public File getVocabFile() {
        return new File(this.getVocabFolder(), this.getVocabularyFileName());
    }

    public File getSchemaHelperFile() {
        return new File(this.getSchemaHelperFolder(), this.getSchemaHelperFileName());
    }

    public File getVocabFolder() {
        return this._vocabFolder;
    }

    public File getSchemaHelperFolder() {
        return this._schemaHelperFolder;
    }

    protected String getRootAttributeValue(String attName) {
        if (this._doc != null && this._doc.hasRootElement()) {
            Element root = this._doc.getRootElement();
            Attribute att = root.getAttribute(attName);
            return att == null ? null : att.getValue();
        }
        return null;
    }

    public String toString() {
        return this.getProfileName();
    }
}

