/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.moonunit.vocab;

import java.util.Locale;

public class VocabularyList
implements Comparable {
    public static String LANG_LISTNAME = "lang";
    public static String YESNO_LISTNAME = "yesno";
    public static String TRUEFALSE_LISTNAME = "truefalse";
    public static String NONE_LISTNAME = "none";
    public static String[] ISO_LANGS = Locale.getISOLanguages();
    private String[] _list;
    private String _listName;
    private String _defaultValue;

    public static VocabularyList getYesNoList() {
        return new VocabularyList(YESNO_LISTNAME, new String[]{"", "yes", "no"});
    }

    public static VocabularyList getTrueFalseList() {
        return new VocabularyList(TRUEFALSE_LISTNAME, new String[]{"", "true", "false"});
    }

    public static VocabularyList getLangList() {
        return new VocabularyList(LANG_LISTNAME, ISO_LANGS);
    }

    public VocabularyList() {
        this._listName = "blank";
        this._list = new String[0];
    }

    public VocabularyList(String listName, String[] list, String defaultValue) {
        this._listName = listName;
        this._list = list;
        this._defaultValue = defaultValue;
    }

    public VocabularyList(String listName, String[] list) {
        this(listName, list, null);
    }

    public String[] getList() {
        return this._list;
    }

    public String getListName() {
        return this._listName;
    }

    public boolean isLangList() {
        return this._listName.equals(LANG_LISTNAME);
    }

    public void setDefaultValue(String defaultValue) {
        this._defaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this._defaultValue;
    }

    public String toString() {
        return this._listName;
    }

    public int compareTo(Object o) {
        if (o instanceof VocabularyList && this.getListName() != null) {
            VocabularyList vlist = (VocabularyList)o;
            return this.getListName().compareTo(vlist.getListName());
        }
        return 0;
    }
}

