/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging.htmlparser;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import uk.ac.reload.editor.contentpackaging.htmlparser.CSSParser;
import uk.ac.reload.editor.contentpackaging.htmlparser.FileType;
import uk.ac.reload.editor.properties.EditorProperties;

public class HTMLParserImporter {
    public static HTML.Attribute[] htmlAttributesToParse = new HTML.Attribute[]{HTML.Attribute.HREF, HTML.Attribute.BACKGROUND, HTML.Attribute.SRC, HTML.Attribute.CODE, HTML.Attribute.ACTION};
    private File _htmlFile;
    private boolean _firstPage = true;
    private File _targetFolder;
    private boolean _higherLocalLinkFound;
    private boolean _absoluteLocalLinkFound;
    private Hashtable _htmlResourcesTable;
    private File _startPath;

    public HTMLParserImporter(File htmlFile, File targetFolder) {
        this._htmlFile = htmlFile;
        this._targetFolder = targetFolder;
        this._startPath = htmlFile;
        this._htmlResourcesTable = new Hashtable();
        File destination = new File(this._targetFolder, htmlFile.getName());
        this._htmlResourcesTable.put(htmlFile, destination);
        this.parseTheHtml(htmlFile, this._targetFolder.getAbsolutePath());
    }

    public Hashtable getLinks() {
        return this._htmlResourcesTable;
    }

    public boolean isAbsoluteLocalLinkFound() {
        return this._absoluteLocalLinkFound;
    }

    public boolean isHigherLocalLinkFound() {
        return this._higherLocalLinkFound;
    }

    protected void parseTheHtml(final File HtmlFile, String destPath) {
        block4: {
            final String sourcePath = HtmlFile.getParent() + File.separatorChar;
            final String packagePath = destPath + File.separatorChar;
            if (HtmlFile.getName().toLowerCase().endsWith(".css")) {
                CSSParser aCssFile = new CSSParser(HtmlFile);
                String[] theCssLinks = aCssFile.getLinks();
                for (int i = 0; i < theCssLinks.length; ++i) {
                    this.buildTheResource(theCssLinks[i], sourcePath, packagePath, HtmlFile);
                }
                return;
            }
            HTMLEditorKit.ParserCallback callback = new HTMLEditorKit.ParserCallback(){

                public void handleStartTag(HTML.Tag tag, MutableAttributeSet attrSet, int pos) {
                    HTMLParserImporter.this.buildTheResource(HTMLParserImporter.this.parseAttributes(tag, attrSet, pos, sourcePath, packagePath, HtmlFile), sourcePath, packagePath, HtmlFile);
                }

                public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet attrSet, int pos) {
                    HTMLParserImporter.this.buildTheResource(HTMLParserImporter.this.parseAttributes(tag, attrSet, pos, sourcePath, packagePath, HtmlFile), sourcePath, packagePath, HtmlFile);
                }
            };
            try {
                FileReader reader = new FileReader(HtmlFile.getAbsolutePath());
                new ParserDelegator().parse(reader, callback, true);
            }
            catch (Exception ex) {
                if (!EditorProperties.getString("DEBUG").equals("true")) break block4;
                ex.printStackTrace();
            }
        }
    }

    protected void dealWithJavascriptEvent(String aLink, String sourcePath, String packagePath, File pageFrom) {
        String[] javascriptBits = aLink.split("'");
        for (int scriptArrayIndex = 0; scriptArrayIndex < javascriptBits.length; ++scriptArrayIndex) {
            Iterator listElement = FileType.ALL_EXTENSIONS.iterator();
            while (listElement.hasNext()) {
                if (!javascriptBits[scriptArrayIndex].toLowerCase().endsWith(listElement.next().toString())) continue;
                this.buildTheResource(javascriptBits[scriptArrayIndex], sourcePath, packagePath, pageFrom);
            }
        }
    }

    protected String parseAttributes(HTML.Tag tag, MutableAttributeSet attrSet, int pos, String sourcePath, String packagePath, File pageFrom) {
        String returnString = null;
        Enumeration<?> attributes = attrSet.getAttributeNames();
        while (attributes.hasMoreElements()) {
            Object o = attributes.nextElement();
            String attributename = o.toString();
            Iterator listElement = FileType.JAVASCRIPTEVENTS.iterator();
            while (listElement.hasNext()) {
                if (attributename.toLowerCase().compareTo(listElement.next().toString()) != 0) continue;
                String attributevalue = (String)attrSet.getAttribute(o);
                this.dealWithJavascriptEvent(attributevalue, sourcePath, packagePath, pageFrom);
            }
            for (int attributeArrayIndex = 0; attributeArrayIndex < htmlAttributesToParse.length; ++attributeArrayIndex) {
                String aLink;
                String aLinkLowerCase;
                if (o != htmlAttributesToParse[attributeArrayIndex] || (aLinkLowerCase = (aLink = (String)attrSet.getAttribute(o)).toLowerCase()).startsWith("http:") || aLinkLowerCase.startsWith("https:") || aLinkLowerCase.startsWith("mailto:")) continue;
                if (aLinkLowerCase.startsWith("javascript:") || aLinkLowerCase.startsWith("#")) {
                    this.dealWithJavascriptEvent(aLink, sourcePath, packagePath, pageFrom);
                    returnString = null;
                    continue;
                }
                if (aLinkLowerCase.startsWith("file:")) {
                    this._absoluteLocalLinkFound = true;
                    System.out.println("Warning: The link '" + aLink.toString() + "' in the file '" + pageFrom.getAbsolutePath() + "' is an absolute link.");
                    returnString = null;
                    continue;
                }
                returnString = aLink;
            }
        }
        return returnString;
    }

    protected void buildTheResource(String localLink, String sourcePath, String packagePath, File pageFrom) {
        block9: {
            File destinationCanonical = null;
            if (localLink != null) {
                try {
                    File original = new File(URLDecoder.decode(sourcePath + localLink, "UTF-8"));
                    File destination = new File(URLDecoder.decode(packagePath + localLink, "UTF-8"));
                    if (!original.exists()) break block9;
                    try {
                        File originalCanonical = new File(original.getCanonicalPath());
                        destinationCanonical = new File(destination.getCanonicalPath());
                        if (destinationCanonical.getAbsolutePath().toLowerCase().startsWith(this._targetFolder.getAbsolutePath().toLowerCase())) {
                            boolean gotit = this._htmlResourcesTable.containsKey(originalCanonical);
                            if (!gotit) {
                                if (!originalCanonical.isDirectory()) {
                                    this._htmlResourcesTable.put(originalCanonical, destinationCanonical);
                                }
                                Iterator listElement = FileType.EXTENSIONS_TO_PARSE.iterator();
                                while (listElement.hasNext()) {
                                    if (!localLink.toLowerCase().endsWith(listElement.next().toString())) continue;
                                    this._firstPage = false;
                                    this.parseTheHtml(original, destinationCanonical.getParent());
                                }
                            }
                            break block9;
                        }
                        this._higherLocalLinkFound = true;
                    }
                    catch (IOException e) {
                        System.out.println("Error: A problem occured during parsing '" + e.toString() + "'");
                    }
                }
                catch (UnsupportedEncodingException e) {
                    System.out.println("Error: Encoding exception in HTML document '" + e.toString() + "'");
                }
            }
        }
    }
}

