/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.gui;

import javax.swing.Icon;
import org.jdom.Element;
import uk.ac.reload.dweezil.gui.tree.DweezilTreeNode;
import uk.ac.reload.editor.datamodel.ElementBinding;
import uk.ac.reload.editor.gui.TreeIconInterface;
import uk.ac.reload.moonunit.SchemaDocument;
import uk.ac.reload.moonunit.schema.SchemaElement;

public abstract class ElementTreeNode
extends DweezilTreeNode {
    private SchemaElement _schemaElement;
    private SchemaDocument _doc;
    private ElementBinding _eb;

    public ElementTreeNode(SchemaDocument doc) {
        super((Object)doc.getRootElement());
        this._schemaElement = doc.getSchemaController().getSchemaModel().getRootElement();
        this._doc = doc;
    }

    public ElementTreeNode(Element element) {
        super((Object)element);
    }

    public ElementBinding createElementBinding() {
        if (this._eb == null) {
            this._eb = new ElementBinding(this.getElement(), this.getSchemaElement(), this.getSchemaDocument());
        }
        return this._eb;
    }

    public Element getElement() {
        return (Element)this.getUserObject();
    }

    public SchemaElement getSchemaElement() {
        if (this._schemaElement == null && this.getParent() != null) {
            this._schemaElement = ((ElementTreeNode)((Object)this.getParent())).getSchemaElement();
            if (this._schemaElement != null) {
                this._schemaElement = this._schemaElement.getChild(this.getElement().getName(), this.getElement().getNamespace());
            }
        }
        return this._schemaElement;
    }

    public SchemaDocument getSchemaDocument() {
        if (this._doc == null && this.getParent() != null) {
            this._doc = ((ElementTreeNode)((Object)this.getParent())).getSchemaDocument();
        }
        return this._doc;
    }

    public String getName() {
        return this.getElement().getName();
    }

    public Icon getLeafIcon() {
        return ((TreeIconInterface)this.getSchemaDocument().getSchemaController()).getLeafIcon(this.getElement().getName(), this.getElement().getNamespace());
    }

    public Icon getOpenIcon() {
        return ((TreeIconInterface)this.getSchemaDocument().getSchemaController()).getOpenIcon(this.getElement().getName(), this.getElement().getNamespace());
    }

    public Icon getClosedIcon() {
        return ((TreeIconInterface)this.getSchemaDocument().getSchemaController()).getClosedIcon(this.getElement().getName(), this.getElement().getNamespace());
    }
}

