/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import uk.ac.reload.dweezil.gui.GradientPanel;
import uk.ac.reload.dweezil.gui.UIFactory;
import uk.ac.reload.dweezil.gui.layout.RelativeLayoutManager;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.DataModel;
import uk.ac.reload.editor.datamodel.IDataComponentIcon;
import uk.ac.reload.editor.datamodel.IDataModelListener;
import uk.ac.reload.editor.gui.widgets.TitleLabelTextField;

public class TitledEditorPanel
extends GradientPanel
implements IDataModelListener,
Scrollable {
    public static final String TOPPANEL_ID = "TitledEditorPanel.TOPPANEL_ID";
    private DataModel _dataModel;
    private DataComponent _dataComponent;
    private RelativeLayoutManager _layoutManager;
    private TitleLabelTextField _labelTitle;
    private JLabel _labelDescription;

    public void setComponent(DataComponent dataComponent) {
        this._dataComponent = dataComponent;
        if (dataComponent instanceof IDataComponentIcon) {
            this.getTitleLabel().setIcon(((IDataComponentIcon)((Object)dataComponent)).getIcon());
        }
        this.getTitleLabel().setText(this.getTitle());
        this.getDescriptionLabel().setText("<html>" + this.getDescription());
        if (this._dataModel == null) {
            this._dataModel = dataComponent.getDataModel();
            if (this._dataModel != null) {
                this._dataModel.addIDataModelListener(this);
            }
        }
    }

    public DataComponent getComponent() {
        return this._dataComponent;
    }

    public TitleLabelTextField getTitleLabel() {
        if (this._labelTitle == null) {
            this._labelTitle = new TitleLabelTextField("Title");
            this._labelTitle.setFont(this._labelTitle.getFont().deriveFont(1, 16.0f));
        }
        return this._labelTitle;
    }

    public JLabel getDescriptionLabel() {
        if (this._labelDescription == null) {
            this._labelDescription = new JLabel("Description");
            this._labelDescription.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        }
        return this._labelDescription;
    }

    public String getTitle() {
        return this._dataComponent == null ? "Title" : this._dataComponent.getTitle();
    }

    public String getDescription() {
        return this._dataComponent == null ? "Description" : this._dataComponent.getDescription();
    }

    public RelativeLayoutManager getRelativeLayoutManager() {
        if (this._layoutManager == null) {
            this._layoutManager = new RelativeLayoutManager((Container)((Object)this));
        }
        return this._layoutManager;
    }

    protected void setupView() {
        super.setupView();
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 60));
        RelativeLayoutManager layoutManager = this.getRelativeLayoutManager();
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setOpaque(false);
        topPanel.add((Component)((Object)this.getTitleLabel()), "North");
        topPanel.add((Component)UIFactory.createGradientUnderLineBar(), "Center");
        topPanel.add((Component)this.getDescriptionLabel(), "South");
        layoutManager.addFromLeftToRightEdges((JComponent)topPanel, TOPPANEL_ID, "_container", 2, 0, 0);
    }

    public void cleanup() {
        this._dataComponent = null;
        this._dataModel = null;
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 15;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 15;
    }

    public void componentAdded(DataComponent component) {
    }

    public void componentRemoved(DataComponent component) {
    }

    public void componentChanged(DataComponent component) {
        if (component == this._dataComponent) {
            this.getTitleLabel().setText(this.getTitle());
        }
    }

    public void componentMoved(DataComponent component) {
    }
}

