/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.gui.widgets;

import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.IIcons;
import uk.ac.reload.editor.gui.widgets.FileTextFieldWidget;
import uk.ac.reload.editor.gui.widgets.ListBoxWidget;
import uk.ac.reload.editor.gui.widgets.NumberFieldWidget;
import uk.ac.reload.editor.gui.widgets.TextFieldWidget;
import uk.ac.reload.editor.gui.widgets.TextPaneWidget;
import uk.ac.reload.editor.gui.widgets.Widget;
import uk.ac.reload.moonunit.SchemaController;
import uk.ac.reload.moonunit.schema.SchemaElement;
import uk.ac.reload.moonunit.schema.SchemaNode;
import uk.ac.reload.moonunit.vocab.VocabularyList;

public final class WidgetFactory
implements IIcons {
    private WidgetFactory() {
    }

    public static Widget getWidget(SchemaController schemaController, SchemaElement schemaElement) {
        if (schemaElement == null) {
            return WidgetFactory.getTextFieldWidget();
        }
        Widget component = null;
        VocabularyList vocab = schemaController.getVocabularyList((SchemaNode)schemaElement);
        if (vocab != null) {
            component = WidgetFactory.getListBoxWidget();
            component.setListData(vocab.getList());
        } else {
            String widget_type = schemaController.getWidgetType(schemaElement.getXMLPath());
            component = widget_type != null ? (widget_type.equals("textpane") ? WidgetFactory.getTextPaneWidget() : (widget_type.equals("numberfield") ? WidgetFactory.getNumberFieldWidget() : (widget_type.equals("filechooser") ? WidgetFactory.getFileTextFieldWidget() : WidgetFactory.getTextFieldWidget()))) : WidgetFactory.getTextFieldWidget();
        }
        int maxLength = -1;
        String value = schemaController.getFacetValue((SchemaNode)schemaElement, "maxLength");
        if (value != null) {
            maxLength = Integer.parseInt(value);
        }
        component.setMaxLength(maxLength);
        return component;
    }

    public static TextFieldWidget getTextFieldWidget() {
        return new TextFieldWidget();
    }

    public static ListBoxWidget getListBoxWidget() {
        return new ListBoxWidget();
    }

    public static TextPaneWidget getTextPaneWidget() {
        return new TextPaneWidget();
    }

    public static NumberFieldWidget getNumberFieldWidget() {
        return new NumberFieldWidget();
    }

    public static FileTextFieldWidget getFileTextFieldWidget() {
        return new FileTextFieldWidget(FileTextFieldWidget.FILE_TYPE, "Select File", DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/open.gif"));
    }
}

