/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.datamodel.components.environments;

import org.jdom.Element;
import uk.ac.reload.editor.datamodel.IDataComponentIcon;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Component;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.jdom.XMLDocumentListener;
import uk.ac.reload.moonunit.SchemaDocument;

public abstract class Service
extends LD_Component
implements IDataComponentIcon {
    protected Service() {
    }

    protected Service(LD_DataModel ldDataModel, Element element) {
        this.setDataModel(ldDataModel);
        this.setElement(element);
    }

    public void setElement(Element element) {
        super.setElement(element);
        this.ensureTitleElement();
    }

    public void setTitle(String title) {
        this.setTitleElement(title);
    }

    public void delete() {
        Element element = this.getElement();
        if (element != null) {
            this.getDataModel().getSchemaDocument().removeElement((Object)this, element.getParent());
        }
        if (this.getParent() != null) {
            this.getParent().removeChild(this);
        }
        this.getDataModel().fireDataComponentRemoved(this);
        this.getDataModel().removeIDataModelListener(this);
        this.getDataModel().getSchemaDocument().removeXMLDocumentListener((XMLDocumentListener)this);
    }

    public String getIdentifier() {
        String id = null;
        Element element = this.getElement();
        if (element != null && (element = element.getParent()) != null) {
            id = element.getAttributeValue("identifier");
        }
        return id;
    }

    protected void moveElementUp() {
        SchemaDocument schemaDocument;
        Element element = this.getElement();
        if (element != null && (element = element.getParent()) != null && (schemaDocument = this.getDataModel().getSchemaDocument()).canMoveElementUp(element)) {
            schemaDocument.moveElementUpSameType((Object)this, element, true);
        }
    }

    protected void moveElementDown() {
        SchemaDocument schemaDocument;
        Element element = this.getElement();
        if (element != null && (element = element.getParent()) != null && (schemaDocument = this.getDataModel().getSchemaDocument()).canMoveElementDown(element)) {
            schemaDocument.moveElementDownSameType((Object)this, element, true);
        }
    }
}

