/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.datamodel.components.roles;

import java.util.Iterator;
import javax.swing.Icon;
import org.jdom.Element;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.IDataComponentIcon;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Component;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.roles.Learner;

public class Learner_Grouping
extends LD_Grouping
implements IDataComponentIcon {
    static final String TITLE = "Learners";
    static final String DESCRIPTION = "Add Learner roles to the Learning Design. You can add Learner types and Learner Group types.";

    public Learner_Grouping(LD_DataModel ldDataModel, Element element) {
        this.setDataModel(ldDataModel);
        this.setElement(element);
        this.setTitle(TITLE);
        this.setDescription(DESCRIPTION);
        this.addChildren();
    }

    protected void addChildren() {
        Iterator it = this.getElement().getChildren("learner", this.getElement().getNamespace()).iterator();
        while (it.hasNext()) {
            Element child = (Element)it.next();
            Learner learner = new Learner(this.getLD_DataModel(), child);
            this.addChild(learner);
        }
    }

    public DataComponent addChildElement(String elementName, String title) {
        if (!"learner".equals(elementName)) {
            return null;
        }
        Learner learner = null;
        Element element = this.addChildElement(this.getElement(), elementName);
        if (element != null) {
            learner = new Learner(this.getLD_DataModel(), element);
            this.addChild(learner);
            if (title != null) {
                learner.setTitle(title);
            }
            this.getDataModel().fireDataComponentAdded(learner);
        }
        return learner;
    }

    public LD_Component getChildByIdentifer(String id) {
        if (id == null || "".equals(id)) {
            return null;
        }
        DataComponent[] children = this.getAllChildren();
        for (int i = 0; i < children.length; ++i) {
            LD_Component ldComponent = (LD_Component)children[i];
            String id2 = ldComponent.getIdentifier();
            if (!id.equals(id2)) continue;
            return ldComponent;
        }
        return null;
    }

    public Icon getIcon() {
        return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/learners.gif");
    }
}

