/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.environment;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.MutableTreeNode;
import uk.ac.reload.dweezil.gui.tree.DweezilTree;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.IIcons;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.DataModel;
import uk.ac.reload.editor.datamodel.IDataComponentIcon;
import uk.ac.reload.editor.datamodel.IDataContainer;
import uk.ac.reload.editor.gui.Editor_TreeModel;
import uk.ac.reload.editor.gui.Editor_TreeNode;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.activities.ActivityStructure_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.activities.LearningActivity_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.activities.SupportActivity_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Environment;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Environments_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.IndexSearch;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.LearningObject;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Service;
import uk.ac.reload.editor.learningdesign.editor.shared.LD_SelectorTree;

public class IndexElementSelectorTree
extends LD_SelectorTree
implements IIcons {
    private IndexSearch _is;

    public IndexElementSelectorTree() {
        this.setRootVisible(false);
        this.setEditor_TreeModel(new IndexSearchSelectorTreeModel(this));
        this.setCellRenderer(new IndexSearchSelectorTreeTreeRenderer());
    }

    public void setIndexSearch(IndexSearch is) {
        this._is = is;
        if (this.getDataModel() == null) {
            this.setDataModel(is.getDataModel());
        }
        ((IndexSearchSelectorTreeModel)this.getEditor_TreeModel()).setIndexSearch(is);
    }

    public void nodeSelected(Editor_TreeNode node) {
        Object o = node.getUserObject();
        if (!(o instanceof LD_Grouping)) {
            node.setSelected(!node.isSelected());
        }
    }

    public void cleanup() {
        super.cleanup();
        this._is = null;
    }

    class Tree_ServiceGrouping
    extends LD_SelectorTree.LD_TreeGrouping
    implements IDataComponentIcon {
        public Tree_ServiceGrouping(DataModel dataModel) {
            super(IndexElementSelectorTree.this);
            this.setDataModel(dataModel);
        }

        public void reset() {
            this.removeChildren();
            Service[] services = this.getLD_DataModel().getEnvironment_Grouping().getServices();
            for (int i = 0; i < services.length; ++i) {
                this.addChild(services[i]);
            }
        }

        public String getTitle() {
            return "Services";
        }

        public Icon getIcon() {
            return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/service.gif");
        }
    }

    class Tree_LearningObjectGrouping
    extends LD_SelectorTree.LD_TreeGrouping
    implements IDataComponentIcon {
        public Tree_LearningObjectGrouping(DataModel dataModel) {
            super(IndexElementSelectorTree.this);
            this.setDataModel(dataModel);
        }

        public void reset() {
            this.removeChildren();
            LearningObject[] los = this.getLD_DataModel().getEnvironment_Grouping().getLearningObjects();
            for (int i = 0; i < los.length; ++i) {
                this.addChild(los[i]);
            }
        }

        public String getTitle() {
            return "Learning Objects";
        }

        public Icon getIcon() {
            return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/learning_objects.gif");
        }
    }

    class IndexSearchSelectorTreeTreeRenderer
    extends LD_SelectorTree.LD_SelectorTreeTreeRenderer {
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof Editor_TreeNode) {
                Editor_TreeNode selNode = (Editor_TreeNode)((Object)value);
                Object obj = selNode.getUserObject();
                this.cb.setVisible(!(obj instanceof LD_Grouping));
            }
            return super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
    }

    class IndexSearchSelectorTreeModel
    extends Editor_TreeModel {
        private DataComponent[] _referencedComponents;
        private LD_SelectorTree.LD_TreeGrouping _rootGroup;
        private Tree_LearningObjectGrouping _loGroup;
        private Tree_ServiceGrouping _servicesGroup;

        public IndexSearchSelectorTreeModel(DweezilTree tree) {
            super(tree);
            this.setSelectNodeOnAdd(false);
        }

        public void setDataModel(DataModel dataModel) {
            super.setDataModel(dataModel);
            this._rootGroup = new LD_SelectorTree.LD_TreeGrouping(IndexElementSelectorTree.this);
            LD_DataModel ldDataModel = (LD_DataModel)this.getDataModel();
            Environments_Grouping envGroup = ldDataModel.getEnvironment_Grouping();
            this._rootGroup.addChild(envGroup);
            this._loGroup = new Tree_LearningObjectGrouping(ldDataModel);
            this._rootGroup.addChild(this._loGroup);
            this._servicesGroup = new Tree_ServiceGrouping(ldDataModel);
            this._rootGroup.addChild(this._servicesGroup);
            LearningActivity_Grouping act1Group = ldDataModel.getActivities_Grouping().getLearningActivity_Grouping();
            this._rootGroup.addChild(act1Group);
            SupportActivity_Grouping act2Group = ldDataModel.getActivities_Grouping().getSupportActivity_Grouping();
            this._rootGroup.addChild(act2Group);
            ActivityStructure_Grouping act3Group = ldDataModel.getActivities_Grouping().getActivityStructure_Grouping();
            this._rootGroup.addChild(act3Group);
        }

        public void setIndexSearch(IndexSearch is) {
            this._referencedComponents = is.getIndexElements();
            this._loGroup.reset();
            this._servicesGroup.reset();
            this.root = new Editor_TreeNode(this._rootGroup);
            this.buildChildren((Editor_TreeNode)((Object)this.root));
            this.reload();
        }

        protected void buildChildren(Editor_TreeNode node) {
            IDataContainer component;
            Object obj = node.getUserObject();
            if (obj instanceof IDataContainer && (component = (IDataContainer)obj).hasChildren()) {
                DataComponent[] children = component.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    if (!this.isAllowedTreeNode(children[i])) continue;
                    Editor_TreeNode childNode = new Editor_TreeNode(children[i]);
                    node.add((MutableTreeNode)((Object)childNode));
                    this.buildChildren(childNode);
                }
            }
        }

        private boolean isAllowedTreeNode(DataComponent component) {
            if (component == IndexElementSelectorTree.this._is) {
                return false;
            }
            if (component.getParent() instanceof Environment) {
                return false;
            }
            return !this.isAlreadyReferencedComponent(component);
        }

        private boolean isAlreadyReferencedComponent(DataComponent component) {
            for (int i = 0; i < this._referencedComponents.length; ++i) {
                if (component != this._referencedComponents[i]) continue;
                return true;
            }
            return false;
        }

        public void cleanup() {
            super.cleanup();
            this._referencedComponents = null;
            if (this._rootGroup != null) {
                this._rootGroup.removeChildren();
            }
            if (this._loGroup != null) {
                this._loGroup.removeChildren();
            }
            if (this._servicesGroup != null) {
                this._servicesGroup.removeChildren();
            }
        }
    }
}

