/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.method;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import uk.ac.reload.dweezil.gui.GradientPanel;
import uk.ac.reload.dweezil.gui.tree.DweezilTreeNode;
import uk.ac.reload.editor.learningdesign.datamodel.ILD_DataModelHandler;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Component;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.datamodel.method.Act;
import uk.ac.reload.editor.learningdesign.datamodel.method.Method;
import uk.ac.reload.editor.learningdesign.datamodel.method.Play;
import uk.ac.reload.editor.learningdesign.datamodel.method.RolePart;
import uk.ac.reload.editor.learningdesign.editor.method.ActEditorPanel;
import uk.ac.reload.editor.learningdesign.editor.method.MethodEditorPanel;
import uk.ac.reload.editor.learningdesign.editor.method.MethodTreePanel;
import uk.ac.reload.editor.learningdesign.editor.method.PlayEditorPanel;
import uk.ac.reload.editor.learningdesign.editor.method.RolePartEditorPanel;
import uk.ac.reload.jdom.XMLPath;

public class MethodPanel
extends GradientPanel
implements TreeSelectionListener,
ILD_DataModelHandler {
    public static XMLPath XMLPATH = new XMLPath("learning-design/method");
    private LD_DataModel _ldDataModel;
    private JSplitPane _splitPane;
    private JPanel _cardPanel;
    private MethodTreePanel _treePanel;
    private MethodEditorPanel _methodEditorPanel;
    private JScrollPane _methodEditorPanelScrollPane;
    private PlayEditorPanel _playEditorPanel;
    private JScrollPane _playEditorPanelScrollPane;
    private ActEditorPanel _actEditorPanel;
    private JScrollPane _actEditorPanelScrollPane;
    private RolePartEditorPanel _rolepartEditorPanel;
    private JScrollPane _rolepartEditorPanelScrollPane;
    private LD_Component _currentSelectedLD_Component;

    public MethodPanel() {
        super((LayoutManager)new BorderLayout());
        JLabel label = new JLabel("Method");
        label.setFont(label.getFont().deriveFont(1, 16.0f));
        this.add(label, "North");
        this._splitPane = new JSplitPane(1);
        this._splitPane.setOneTouchExpandable(true);
        this.add(this._splitPane, "Center");
        this._splitPane.setLeftComponent((Component)((Object)this.getMethodTreePanel()));
        this._cardPanel = new JPanel(new CardLayout());
        this._splitPane.setRightComponent(this._cardPanel);
        this.getMethodTreePanel().getTree().addTreeSelectionListener(this);
    }

    public void setDataModel(LD_DataModel ldDataModel) {
        this._ldDataModel = ldDataModel;
        this.getMethodTreePanel().setDataModel(ldDataModel);
    }

    public void valueChanged(TreeSelectionEvent e) {
        Object obj;
        if (!e.isAddedPath()) {
            return;
        }
        TreePath selPath = e.getPath();
        Object selectedNode = selPath.getLastPathComponent();
        if (selectedNode instanceof DweezilTreeNode && (obj = ((DweezilTreeNode)selectedNode).getUserObject()) instanceof LD_Component) {
            this.updateEditorPanel((LD_Component)obj);
        }
    }

    protected void updateEditorPanel(LD_Component ldComponent) {
        if (ldComponent == this._currentSelectedLD_Component) {
            return;
        }
        String panelName = null;
        if (ldComponent instanceof Method) {
            panelName = "#METHOD_PANEL";
            if (this.getMethodEditorPanelScrollPane().getParent() != this._cardPanel) {
                this._cardPanel.add((Component)this.getMethodEditorPanelScrollPane(), panelName);
            }
            this.getMethodEditorPanel().setComponent(ldComponent);
        } else if (ldComponent instanceof Play) {
            panelName = "#PLAY_PANEL";
            if (this.getPlayEditorPanelScrollPane().getParent() != this._cardPanel) {
                this._cardPanel.add((Component)this.getPlayEditorPanelScrollPane(), panelName);
            }
            this.getPlayEditorPanel().setComponent(ldComponent);
        } else if (ldComponent instanceof Act) {
            panelName = "#ACT_PANEL";
            if (this.getActEditorPanelScrollPane().getParent() != this._cardPanel) {
                this._cardPanel.add((Component)this.getActEditorPanelScrollPane(), panelName);
            }
            this.getActEditorPanel().setComponent(ldComponent);
        } else if (ldComponent instanceof RolePart) {
            panelName = "#ROLEPART_PANEL";
            if (this.getRolePartEditorPanelScrollPane().getParent() != this._cardPanel) {
                this._cardPanel.add((Component)this.getRolePartEditorPanelScrollPane(), panelName);
            }
            this.getRolePartEditorPanel().setComponent(ldComponent);
        }
        if (panelName != null) {
            ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, panelName);
        }
        this._currentSelectedLD_Component = ldComponent;
    }

    protected void setupView() {
        super.setupView();
        Border border = BorderFactory.createEmptyBorder(5, 10, 5, 10);
        this.setBorder(border);
    }

    public void initView() {
        this._splitPane.setDividerLocation(0.33);
        this.getMethodTreePanel().setSelected(true);
    }

    public void cleanup() {
        if (this._treePanel != null) {
            this._treePanel.cleanup();
        }
        if (this._methodEditorPanel != null) {
            this._methodEditorPanel.cleanup();
        }
        if (this._playEditorPanel != null) {
            this._playEditorPanel.cleanup();
        }
        if (this._actEditorPanel != null) {
            this._actEditorPanel.cleanup();
        }
        if (this._rolepartEditorPanel != null) {
            this._rolepartEditorPanel.cleanup();
        }
        this._ldDataModel = null;
    }

    public boolean doSave() {
        return true;
    }

    public JScrollPane getMethodEditorPanelScrollPane() {
        if (this._methodEditorPanelScrollPane == null) {
            this._methodEditorPanelScrollPane = new JScrollPane((Component)((Object)this.getMethodEditorPanel()));
            this._methodEditorPanelScrollPane.setBorder(null);
        }
        return this._methodEditorPanelScrollPane;
    }

    public MethodEditorPanel getMethodEditorPanel() {
        if (this._methodEditorPanel == null) {
            this._methodEditorPanel = new MethodEditorPanel();
        }
        return this._methodEditorPanel;
    }

    public JScrollPane getPlayEditorPanelScrollPane() {
        if (this._playEditorPanelScrollPane == null) {
            this._playEditorPanelScrollPane = new JScrollPane((Component)((Object)this.getPlayEditorPanel()));
            this._playEditorPanelScrollPane.setBorder(null);
        }
        return this._playEditorPanelScrollPane;
    }

    public PlayEditorPanel getPlayEditorPanel() {
        if (this._playEditorPanel == null) {
            this._playEditorPanel = new PlayEditorPanel();
        }
        return this._playEditorPanel;
    }

    public JScrollPane getActEditorPanelScrollPane() {
        if (this._actEditorPanelScrollPane == null) {
            this._actEditorPanelScrollPane = new JScrollPane((Component)((Object)this.getActEditorPanel()));
            this._actEditorPanelScrollPane.setBorder(null);
        }
        return this._actEditorPanelScrollPane;
    }

    public ActEditorPanel getActEditorPanel() {
        if (this._actEditorPanel == null) {
            this._actEditorPanel = new ActEditorPanel();
        }
        return this._actEditorPanel;
    }

    public JScrollPane getRolePartEditorPanelScrollPane() {
        if (this._rolepartEditorPanelScrollPane == null) {
            this._rolepartEditorPanelScrollPane = new JScrollPane((Component)((Object)this.getRolePartEditorPanel()));
            this._rolepartEditorPanelScrollPane.setBorder(null);
        }
        return this._rolepartEditorPanelScrollPane;
    }

    public RolePartEditorPanel getRolePartEditorPanel() {
        if (this._rolepartEditorPanel == null) {
            this._rolepartEditorPanel = new RolePartEditorPanel();
        }
        return this._rolepartEditorPanel;
    }

    public MethodTreePanel getMethodTreePanel() {
        if (this._treePanel == null) {
            this._treePanel = new MethodTreePanel();
        }
        return this._treePanel;
    }
}

