/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.method;

import javax.swing.JLabel;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.DataModel;
import uk.ac.reload.editor.datamodel.IDataComponentIcon;
import uk.ac.reload.editor.datamodel.IDataModelListener;
import uk.ac.reload.editor.gui.Editor_TreeNode;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Component;
import uk.ac.reload.editor.learningdesign.datamodel.components.roles.Role;
import uk.ac.reload.editor.learningdesign.datamodel.method.RolePart;
import uk.ac.reload.editor.learningdesign.editor.roles.RoleSelectorTree;

public class RolePartRoleSelectorTree
extends RoleSelectorTree
implements IDataModelListener {
    private RolePart _rolePart;
    private JLabel _label;

    public RolePartRoleSelectorTree(JLabel label) {
        this._label = label;
    }

    public void setRolePartComponent(RolePart rolePart) {
        this._rolePart = rolePart;
        if (this.getDataModel() == null) {
            this.setDataModel(rolePart.getDataModel());
            this.expandTree(true);
        }
        this.update();
    }

    private void update() {
        Role role = this._rolePart.getReferencedRole();
        this.setSelectedNodes(new LD_Component[]{role});
        this.updateLabel(role);
    }

    public void setDataModel(DataModel ldDataModel) {
        super.setDataModel(ldDataModel);
        ldDataModel.addIDataModelListener(this);
    }

    public void nodeSelected(Editor_TreeNode node) {
        Object o = node.getUserObject();
        if (o instanceof Role) {
            Role role = (Role)o;
            this._rolePart.setReferencedRole(role);
        }
    }

    protected void updateLabel(LD_Component component) {
        if (component != null) {
            this._label.setText("<html>" + component.getTitle());
            this._label.setIcon(((IDataComponentIcon)((Object)component)).getIcon());
        } else {
            this._label.setText("(not set)");
            this._label.setIcon(null);
        }
    }

    public void cleanup() {
        if (this.getDataModel() != null) {
            this.getDataModel().removeIDataModelListener(this);
        }
        super.cleanup();
        this._rolePart = null;
    }

    public void componentAdded(DataComponent component) {
    }

    public void componentRemoved(DataComponent component) {
    }

    public void componentMoved(DataComponent component) {
    }

    public void componentChanged(DataComponent component) {
        if (component == this._rolePart) {
            this.update();
        }
    }
}

