/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.roles;

import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import uk.ac.reload.dweezil.gui.LabelComponentPanel;
import uk.ac.reload.dweezil.gui.layout.RelativeLayoutManager;
import uk.ac.reload.dweezil.gui.layout.SGLayout;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.DataElement;
import uk.ac.reload.editor.gui.IdentifierLabelTextField;
import uk.ac.reload.editor.gui.TitledEditorPanel;
import uk.ac.reload.editor.gui.widgets.DataElementComboBox;
import uk.ac.reload.editor.gui.widgets.DataElementNumberField;
import uk.ac.reload.editor.gui.widgets.DataElementTextField;
import uk.ac.reload.editor.learningdesign.datamodel.components.roles.Role;
import uk.ac.reload.editor.learningdesign.editor.shared.ItemModelTypePanel;
import uk.ac.reload.editor.learningdesign.editor.shared.MetadataPanel;

public class RoleEditorPanel
extends TitledEditorPanel {
    static final boolean SHOW_IDENTIFIER = false;
    private IdentifierLabelTextField _tfIdentifier;
    private DataElementTextField _tfHREF;
    private DataElementNumberField _tfMinPersons;
    private DataElementNumberField _tfMaxPersons;
    private DataElementComboBox _cbCreateNew;
    private DataElementComboBox _cbMatchPersons;
    private ItemModelTypePanel _infoPanel;
    private MetadataPanel _metadataPanel;

    public void setComponent(DataComponent dataComponent) {
        super.setComponent(dataComponent);
        Role role = (Role)dataComponent;
        this.getTitleLabel().setComponent(dataComponent);
        DataElement roleElement = dataComponent.getDataElement();
        this._tfHREF.setAttribute(roleElement, "href", null);
        this._tfMinPersons.setAttribute(roleElement, "min-persons", null);
        this._tfMaxPersons.setAttribute(roleElement, "max-persons", null);
        this._cbCreateNew.setAttribute(roleElement, "create-new", null);
        this._cbMatchPersons.setAttribute(roleElement, "match-persons", null);
        this._infoPanel.setItemModelType(role.getInformationItemModelType());
        this._metadataPanel.setMetadataType(role.getMetadataType());
    }

    protected void setupView() {
        super.setupView();
        RelativeLayoutManager layoutManager = this.getRelativeLayoutManager();
        SGLayout fieldPanelLayout = new SGLayout(5, 1, 0, 5);
        JPanel fieldPanel = new JPanel((LayoutManager)fieldPanelLayout);
        fieldPanel.setOpaque(false);
        layoutManager.addFromLeftToRightEdges((JComponent)fieldPanel, "fieldPanel", "TitledEditorPanel.TOPPANEL_ID", 1, 10, 10);
        this._tfHREF = new DataElementTextField();
        LabelComponentPanel panelHREF = new LabelComponentPanel("HREF:", (JComponent)this._tfHREF, 0.3, 0.0);
        fieldPanel.add((Component)panelHREF);
        this._tfMinPersons = new DataElementNumberField(4);
        LabelComponentPanel panelMinPersons = new LabelComponentPanel("Min Persons:", (JComponent)this._tfMinPersons, 0.3, 5.0);
        fieldPanel.add((Component)panelMinPersons);
        this._tfMaxPersons = new DataElementNumberField(4);
        LabelComponentPanel panelMaxPersons = new LabelComponentPanel("Max Persons:", (JComponent)this._tfMaxPersons, 0.3, 5.0);
        fieldPanel.add((Component)panelMaxPersons);
        this._cbCreateNew = new DataElementComboBox(new String[]{"", "allowed", "not-allowed"});
        LabelComponentPanel panelCreateNew = new LabelComponentPanel("Create New:", (JComponent)((Object)this._cbCreateNew), 0.3, 1.5);
        fieldPanel.add((Component)panelCreateNew);
        this._cbMatchPersons = new DataElementComboBox(new String[]{"", "exclusively-in-roles", "not-exclusively"});
        LabelComponentPanel panelMatchPersons = new LabelComponentPanel("Match Persons:", (JComponent)((Object)this._cbMatchPersons), 0.3, 1.5);
        fieldPanel.add((Component)panelMatchPersons);
        this._infoPanel = new ItemModelTypePanel(false);
        layoutManager.addFromLeftToRightEdges((JComponent)this._infoPanel, "_infoPanel", "fieldPanel", 1, 10, 10);
        this._metadataPanel = new MetadataPanel();
        layoutManager.addFromLeftToRightEdges((JComponent)this._metadataPanel, "_metadataPanel", "_infoPanel", 1, 20, 10);
    }

    public void cleanup() {
        super.cleanup();
        if (this._infoPanel != null) {
            this._infoPanel.cleanup();
        }
        if (this._metadataPanel != null) {
            this._metadataPanel.cleanup();
        }
    }
}

