/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.shared;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import uk.ac.reload.dweezil.gui.ComponentHiderLabelPanel;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.gui.widgets.DataElementDurationField;
import uk.ac.reload.editor.learningdesign.editor.shared.ItemModelTypePanel;

public abstract class CompletionPanel
extends JPanel {
    private int _currentButton;
    private DataComponent _dataComponent;
    private ComponentHiderLabelPanel _hiderPanel;
    private JPanel _centerPanel;
    private JRadioButton[] _radioButtons;
    private DataElementDurationField _dfTimeLimit;
    private ItemModelTypePanel _completionFeedbackPanel;

    protected CompletionPanel(boolean isHidden) {
        this.setupView(isHidden);
    }

    public void setComponent(DataComponent dataComponent) {
        this._dataComponent = dataComponent;
    }

    public DataComponent getComponent() {
        return this._dataComponent;
    }

    protected void setupView(boolean isHidden) {
        this.setOpaque(false);
        this.setLayout(new BorderLayout(10, 10));
        this.add((Component)this.getCenterPanel(), "Center");
        this._hiderPanel = new ComponentHiderLabelPanel("", null);
        this._hiderPanel.getComponentHiderButton().setComponent((JComponent)this.getCenterPanel());
        this._hiderPanel.getComponentHiderButton().showComponent(isHidden);
        this.add((Component)this._hiderPanel, "North");
        this.getCenterPanel().add((Component)this.getCompletionFeedbackPanel(), "South");
    }

    protected ComponentHiderLabelPanel getHiderLabelPanel() {
        return this._hiderPanel;
    }

    protected DataElementDurationField getTimeLimitField() {
        if (this._dfTimeLimit == null) {
            this._dfTimeLimit = new DataElementDurationField();
            this._dfTimeLimit.setEditable(false);
        }
        return this._dfTimeLimit;
    }

    protected JRadioButton[] getRadioButtons() {
        if (this._radioButtons == null) {
            ButtonGroup bg = new ButtonGroup();
            this._radioButtons = new JRadioButton[this.getNumberRadioButtons()];
            for (int i = 0; i < this.getNumberRadioButtons(); ++i) {
                this._radioButtons[i] = this.createRadioButton(i);
                bg.add(this._radioButtons[i]);
            }
        }
        return this._radioButtons;
    }

    protected JRadioButton createRadioButton(final int num) {
        JRadioButton rb = new JRadioButton();
        rb.setOpaque(false);
        rb.setText(this.getRadioButtonText(num));
        rb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CompletionPanel.this._currentButton != num) {
                    CompletionPanel.this.radioButtonPressed(num);
                }
                CompletionPanel.this._currentButton = num;
            }
        });
        return rb;
    }

    protected ItemModelTypePanel getCompletionFeedbackPanel() {
        if (this._completionFeedbackPanel == null) {
            this._completionFeedbackPanel = new ItemModelTypePanel(false);
            this._completionFeedbackPanel.setBorder(new EmptyBorder(10, 10, 0, 0));
        }
        return this._completionFeedbackPanel;
    }

    protected JPanel getCenterPanel() {
        if (this._centerPanel == null) {
            this._centerPanel = new JPanel(new BorderLayout());
            this._centerPanel.setOpaque(false);
        }
        return this._centerPanel;
    }

    public void cleanup() {
        if (this._completionFeedbackPanel != null) {
            this._completionFeedbackPanel.cleanup();
        }
        this._dataComponent = null;
    }

    protected void selectRadioButton(int button) {
        this._radioButtons[button].setSelected(true);
        this._currentButton = button;
    }

    protected abstract int getNumberRadioButtons();

    protected abstract String getRadioButtonText(int var1);

    protected abstract void radioButtonPressed(int var1);
}

