/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.metadata;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.Icon;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.EditorHandler;
import uk.ac.reload.editor.EditorInternalFrame;
import uk.ac.reload.editor.IEditorHandler;
import uk.ac.reload.editor.IIcons;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.metadata.datamodel.MD_DataModel;
import uk.ac.reload.editor.metadata.editor.MD_Editor;
import uk.ac.reload.editor.metadata.editor.MD_NewDialog;
import uk.ac.reload.editor.metadata.xml.MD11_SchemaController;
import uk.ac.reload.editor.metadata.xml.MD121_SchemaController;
import uk.ac.reload.editor.metadata.xml.MD122_SchemaController;
import uk.ac.reload.editor.metadata.xml.MD_IEEE_100_SchemaController;
import uk.ac.reload.editor.metadata.xml.MD_SchemaController;
import uk.ac.reload.editor.metadata.xml.Metadata;
import uk.ac.reload.editor.prefs.EditorPrefs;
import uk.ac.reload.jdom.XMLUtils;
import uk.ac.reload.moonunit.SchemaController;
import uk.ac.reload.moonunit.schema.SchemaException;

public class MD_EditorHandler
implements IEditorHandler,
IIcons {
    public static final String IEEE_METADATA_1_0_0 = "IEEE LOM Metadata 1.0";
    public static String IEEE_NAMESPACE_PREFIX = "lom";
    public static Namespace IEEE_NAMESPACE_100 = Namespace.getNamespace((String)"http://ltsc.ieee.org/xsd/LOMv1p0");
    public static final String IMS_METADATA_1_1 = "IMS Metadata 1.1";
    public static final String IMS_METADATA_1_2 = "IMS Metadata 1.2";
    public static final String IMS_METADATA_1_2_1 = "IMS Metadata 1.2.1";
    public static final String IMS_METADATA_1_2_2 = "IMS Metadata 1.2.2";
    public static String IMSMD_NAMESPACE_PREFIX = "imsmd";
    public static Namespace IMSMD_NAMESPACE_122 = Namespace.getNamespace((String)"http://www.imsglobal.org/xsd/imsmd_v1p2");
    public static Namespace IMSMD_NAMESPACE_121 = Namespace.getNamespace((String)"http://www.imsglobal.org/xsd/imsmd_rootv1p2p1");
    public static Namespace IMSMD_NAMESPACE_12 = Namespace.getNamespace((String)"http://www.imsproject.org/xsd/imsmd_rootv1p2");
    public static Namespace IMSMD_NAMESPACE_11 = Namespace.getNamespace((String)"http://www.imsproject.org/xsd/ims_md_rootv1p1");
    public static Namespace MD_BOGUS_NAMESPACE1 = Namespace.getNamespace((String)"http://www.imsproject.org/metadata");
    static Hashtable SUPPORTED_NAMESPACES = new Hashtable();
    public static final File HELPER_FOLDER;
    public static final File PROFILE_FOLDER;
    public static final File SCHEMAHELPER_FOLDER;
    public static final File VOCAB_FOLDER;

    public boolean canCreateDocuments() {
        return true;
    }

    public boolean canEditFile(File file) {
        Document doc;
        try {
            doc = XMLUtils.readXMLFile((File)file);
        }
        catch (Exception ex) {
            return false;
        }
        Namespace nameSpace = XMLUtils.getDocumentNamespace((Document)doc);
        if (nameSpace == null || nameSpace.equals((Object)Namespace.NO_NAMESPACE)) {
            return false;
        }
        return SUPPORTED_NAMESPACES.containsKey(nameSpace);
    }

    public EditorInternalFrame editFile(File file) throws JDOMException, SchemaException, IOException {
        Metadata md = new Metadata(file);
        return new MD_Editor(md);
    }

    public EditorInternalFrame newDocument() throws JDOMException, SchemaException, IOException {
        boolean doAsk;
        String version = EditorPrefs.getInstance().getValue("default_md_version");
        boolean bl = doAsk = EditorPrefs.getInstance().getBooleanValue("do_ask_md_version") || version == null;
        if (doAsk) {
            String[] versionsMD = this.getSupportedVersions();
            MD_NewDialog dialog = new MD_NewDialog(versionsMD, version);
            int response = dialog.showDialog();
            if (response == 0) {
                version = dialog.getVersion();
                boolean dontAsk = dialog.getDontAsk();
                if (dontAsk) {
                    EditorPrefs.getInstance().putBooleanValue("do_ask_md_version", false);
                    EditorPrefs.getInstance().putValue("default_md_version", version);
                }
            } else {
                return null;
            }
        }
        MD_SchemaController controller = (MD_SchemaController)this.getSchemaControllerInstance(version);
        Metadata md = new Metadata(true, controller);
        return new MD_Editor(md);
    }

    public static MD_DataModel loadNewTestInstance() throws JDOMException, SchemaException, IOException {
        Metadata md;
        File file = new File("z-md-test/md.xml");
        if (file.exists()) {
            md = new Metadata(file);
        } else {
            MD122_SchemaController mdController = new MD122_SchemaController();
            md = new Metadata(true, mdController);
            md.setFile(file);
        }
        return new MD_DataModel(md);
    }

    public String getName() {
        return Messages.getString("uk.ac.reload.editor.metadata.MD_EditorHandler.0");
    }

    public Icon getIcon() {
        return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/md.gif");
    }

    public String[] getSupportedVersions() {
        return new String[]{IMS_METADATA_1_1, IMS_METADATA_1_2_1, IMS_METADATA_1_2_2};
    }

    public String getDefaultVersion() {
        return IMS_METADATA_1_2_2;
    }

    public String getVersion(Namespace ns) {
        return ns == null ? null : (String)SUPPORTED_NAMESPACES.get(ns);
    }

    public SchemaController getSchemaControllerInstance(String version) throws JDOMException, SchemaException, IOException {
        MD_SchemaController schemaController = null;
        if (IMS_METADATA_1_2_1.equals(version)) {
            schemaController = new MD121_SchemaController();
        } else if (IMS_METADATA_1_2_2.equals(version)) {
            schemaController = new MD122_SchemaController();
        } else if (IMS_METADATA_1_1.equals(version)) {
            schemaController = new MD11_SchemaController();
        } else if (IEEE_METADATA_1_0_0.equals(version)) {
            schemaController = new MD_IEEE_100_SchemaController();
        }
        return schemaController;
    }

    static {
        SUPPORTED_NAMESPACES.put(IMSMD_NAMESPACE_11, IMS_METADATA_1_1);
        SUPPORTED_NAMESPACES.put(IMSMD_NAMESPACE_121, IMS_METADATA_1_2_1);
        SUPPORTED_NAMESPACES.put(IMSMD_NAMESPACE_122, IMS_METADATA_1_2_2);
        HELPER_FOLDER = new File(EditorHandler.HELPERFOLDER, "md");
        PROFILE_FOLDER = new File(HELPER_FOLDER, "profile");
        SCHEMAHELPER_FOLDER = new File(HELPER_FOLDER, "schemahelper");
        VOCAB_FOLDER = new File(HELPER_FOLDER, "vocab");
    }
}

