/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.metadata.editor;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.filechooser.FileFilter;
import uk.ac.reload.dweezil.gui.DweezilFileChooser;
import uk.ac.reload.dweezil.gui.DweezilFileFilter;
import uk.ac.reload.dweezil.gui.ErrorDialogBox;
import uk.ac.reload.dweezil.menu.DweezilMenuEvent;
import uk.ac.reload.dweezil.menu.MenuAction;
import uk.ac.reload.dweezil.menu.ProxyAction;
import uk.ac.reload.editor.EditorHandler;
import uk.ac.reload.editor.EditorInternalFrame;
import uk.ac.reload.editor.IIcons;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.menu.MainMenu;
import uk.ac.reload.editor.metadata.editor.MD_EditorPanel;
import uk.ac.reload.editor.metadata.editor.tableview.MD_TreeTable;
import uk.ac.reload.editor.metadata.xml.Metadata;
import uk.ac.reload.jdom.XMLDocument;
import uk.ac.reload.jdom.XMLDocumentListener;
import uk.ac.reload.jdom.XMLDocumentListenerEvent;

public class MD_Editor
extends EditorInternalFrame
implements XMLDocumentListener,
IIcons {
    private MD_EditorPanel _mdEditorPanel;
    private ProxySaveHandler _saveHandler;
    private ProxySaveHandler _saveAsHandler;

    public MD_Editor() {
        super(Messages.getString("uk.ac.reload.editor.metadata.MD_Editor.0"), "uk/ac/reload/editor/resources/images/md.gif");
        this.setDefaultCloseOperation(0);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        1.access$000(this.this$1).checkNeedsSaving();
                    }
                });
            }

            public void internalFrameActivated(InternalFrameEvent e) {
                MD_Editor.this.setFocusGained();
            }

            public void internalFrameDeactivated(InternalFrameEvent e) {
                MD_Editor.this.setFocusLost();
            }

            static /* synthetic */ MD_Editor access$000(1 x0) {
                return x0.MD_Editor.this;
            }
        });
        this._mdEditorPanel = new MD_EditorPanel(MainMenu.getSharedInstance().editMenu);
        this.getContentPane().add(this._mdEditorPanel);
    }

    public MD_Editor(Metadata md) {
        this();
        if (md.getFile() == null) {
            this.setTitle(Messages.getString("uk.ac.reload.editor.metadata.MD_Editor.0") + " - " + Messages.getString("uk.ac.reload.editor.metadata.MD_Editor.1"));
        } else {
            this.setTitle(Messages.getString("uk.ac.reload.editor.metadata.MD_Editor.0") + " - " + md.getFile().getPath());
        }
        this._mdEditorPanel.setDocument(md);
        md.addXMLDocumentListener(this);
        this._saveHandler = new ProxySaveHandler(MainMenu.getSharedInstance().actionSave);
        this._saveAsHandler = new ProxySaveHandler(MainMenu.getSharedInstance().actionSaveAs);
    }

    public void show() {
        super.show();
        this._mdEditorPanel.initView();
    }

    public void elementAdded(XMLDocumentListenerEvent e) {
        if (this.isSelected()) {
            this._saveHandler.setEnabled(this._mdEditorPanel.getMetadata().isDirty());
        }
    }

    public void elementChanged(XMLDocumentListenerEvent e) {
        if (this.isSelected()) {
            this._saveHandler.setEnabled(this._mdEditorPanel.getMetadata().isDirty());
        }
    }

    public void elementRemoved(XMLDocumentListenerEvent e) {
        if (this.isSelected()) {
            this._saveHandler.setEnabled(this._mdEditorPanel.getMetadata().isDirty());
        }
    }

    public void documentSaved(XMLDocument doc) {
        if (this.isSelected()) {
            this._saveHandler.setEnabled(this._mdEditorPanel.getMetadata().isDirty());
        }
    }

    protected void setFocusGained() {
        if (this._mdEditorPanel.getMetadata() != null) {
            this._mdEditorPanel.getUndoManager().setFocusGained();
            MD_TreeTable treeTable = this._mdEditorPanel.getMD_TablePanel().getMD_TreeTable();
            if (treeTable != null) {
                treeTable.updateMenus();
            }
            this._saveHandler.setEnabled(this._mdEditorPanel.getMetadata().isDirty());
            this._saveHandler.addListener();
            this._saveAsHandler.setEnabled(true);
            this._saveAsHandler.addListener();
        }
    }

    protected void setFocusLost() {
        this._mdEditorPanel.getUndoManager().setFocusLost();
        MD_TreeTable treeTable = this._mdEditorPanel.getMD_TablePanel().getMD_TreeTable();
        if (treeTable != null) {
            treeTable.clearMenus();
        }
        this._saveHandler.setEnabled(false);
        this._saveHandler.removeListener();
        this._saveAsHandler.setEnabled(false);
        this._saveAsHandler.removeListener();
    }

    public boolean applicationClosing() {
        return this.checkNeedsSaving();
    }

    protected boolean checkNeedsSaving() {
        boolean isOK = true;
        Metadata md = this._mdEditorPanel.getMetadata();
        if (md != null && md.isDirty()) {
            File file = md.getFile();
            String msg = file != null ? file.getName() + " " + Messages.getString("uk.ac.reload.editor.metadata.MD_Editor.2") : Messages.getString("uk.ac.reload.editor.metadata.MD_Editor.3");
            int doSave = JOptionPane.showConfirmDialog((Component)((Object)this), msg + " " + Messages.getString("uk.ac.reload.editor.metadata.MD_Editor.4"), Messages.getString("uk.ac.reload.editor.metadata.MD_Editor.5"), 1);
            if (doSave == 0) {
                isOK = this.saveDocument();
            } else if (doSave == 2) {
                isOK = false;
            }
        }
        if (isOK) {
            this.dispose();
        }
        return isOK;
    }

    public void dispose() {
        this.cleanup();
        super.dispose();
    }

    public void cleanup() {
        if (this._saveHandler != null) {
            this._saveHandler.removeListener();
        }
        if (this._saveAsHandler != null) {
            this._saveAsHandler.removeListener();
        }
        if (this._mdEditorPanel != null) {
            Metadata md = this._mdEditorPanel.getMetadata();
            if (md != null) {
                md.removeXMLDocumentListener(this);
            }
            this._mdEditorPanel.cleanup();
        }
    }

    protected boolean saveDocument() {
        if (this._mdEditorPanel.getMetadata().getFile() == null) {
            return this.saveAsDocument();
        }
        try {
            this._mdEditorPanel.getMetadata().saveDocument();
        }
        catch (IOException ex) {
            ErrorDialogBox.showWarning((Component)((Object)this), (String)Messages.getString("uk.ac.reload.editor.metadata.MD_Editor.6"), (String)Messages.getString("uk.ac.reload.editor.metadata.MD_Editor.5"), (Exception)ex);
            return false;
        }
        return true;
    }

    protected boolean saveAsDocument() {
        DweezilFileFilter filter = new DweezilFileFilter(new String[]{"xml"}, "xml files");
        File file = DweezilFileChooser.askFileNameSave((Component)((Object)this), (String)Messages.getString("uk.ac.reload.editor.metadata.MD_Editor.5"), (FileFilter)filter, (String)"xml");
        if (file == null) {
            return false;
        }
        try {
            this._mdEditorPanel.getMetadata().saveAsDocument(file);
        }
        catch (IOException ex) {
            ErrorDialogBox.showWarning((Component)((Object)this), (String)Messages.getString("uk.ac.reload.editor.metadata.MD_Editor.6"), (String)Messages.getString("uk.ac.reload.editor.metadata.MD_Editor.5"), (Exception)ex);
            return false;
        }
        this.setTitle(Messages.getString("uk.ac.reload.editor.metadata.MD_Editor.0") + " - " + file.getPath());
        EditorHandler.getSharedInstance().registerOpenedFile(file, this);
        return true;
    }

    class ProxySaveHandler
    extends ProxyAction {
        public ProxySaveHandler(MenuAction menuAction) {
            super(menuAction);
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            if (MD_Editor.this.isSelected() && event.getSource() == MainMenu.getSharedInstance().actionSave) {
                MD_Editor.this.saveDocument();
            }
            if (MD_Editor.this.isSelected() && event.getSource() == MainMenu.getSharedInstance().actionSaveAs) {
                MD_Editor.this.saveAsDocument();
            }
        }
    }
}

