/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.prefs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import uk.ac.reload.diva.prefs.UserPrefs;
import uk.ac.reload.diva.util.CopyTask;
import uk.ac.reload.dweezil.gui.FileTextField;
import uk.ac.reload.dweezil.gui.layout.XYConstraints;
import uk.ac.reload.dweezil.gui.layout.XYLayout;
import uk.ac.reload.dweezil.prefs.PrefsPanel;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.IIcons;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.prefs.EditorPrefs;

public class General_PrefsPanel
extends PrefsPanel
implements IIcons {
    private FileTextField _tfDefaultFolder;
    private JCheckBox _checkSupportBox;

    public General_PrefsPanel() {
        this.setLayout((LayoutManager)new XYLayout());
        this.constructFields();
    }

    private void constructFields() {
        int x = 10;
        int y = 10;
        JLabel label = new JLabel(Messages.getString("uk.ac.reload.editor.prefs.General_PrefsPanel.0"));
        this.add(label, new XYConstraints(x, y + 2, 0, 0));
        this._tfDefaultFolder = new FileTextField(FileTextField.FOLDER_TYPE, Messages.getString("uk.ac.reload.editor.prefs.General_PrefsPanel.1"), (Icon)DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/open.gif"));
        this.add((Component)this._tfDefaultFolder, new XYConstraints(x + 230, y, 300, 22));
        this._checkSupportBox = new JCheckBox(Messages.getString("uk.ac.reload.editor.prefs.General_PrefsPanel.2"));
        JButton repairButton = new JButton(new AbstractAction(Messages.getString("uk.ac.reload.editor.prefs.General_PrefsPanel.3")){

            public void actionPerformed(ActionEvent e) {
                try {
                    General_PrefsPanel.this.checkSupportFolder();
                    JOptionPane.showMessageDialog((Component)((Object)General_PrefsPanel.this), Messages.getString("uk.ac.reload.editor.prefs.General_PrefsPanel.4"));
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog((Component)((Object)General_PrefsPanel.this), Messages.getString("uk.ac.reload.editor.prefs.General_PrefsPanel.5") + ": " + e1.getMessage());
                }
            }
        });
        this.add(this._checkSupportBox, new XYConstraints(x, y + 30, 0, 0));
        this.add(repairButton, new XYConstraints(x + 230, y + 27, 0, 0));
    }

    public void saveToUserPrefs(UserPrefs prefs) {
        prefs.putValue("default_folder", this._tfDefaultFolder.getTextValue());
        prefs.putBooleanValue("check_support", this._checkSupportBox.isSelected());
    }

    public void setFields(UserPrefs prefs) {
        this._tfDefaultFolder.setTextValue(prefs.getValue("default_folder"));
        this._checkSupportBox.setSelected(prefs.getBooleanValue("check_support"));
    }

    public void cancel() {
    }

    private void checkSupportFolder() throws IOException {
        try {
            new CopyTask("reload-support.jar", EditorPrefs.getInstance().getPrefsFolder()).execute(true);
        }
        catch (IOException e) {
            new CopyTask("helpers", EditorPrefs.getInstance().getPrefsFolder()).execute(true);
        }
    }
}

