/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.scorm;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.Icon;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.EditorHandler;
import uk.ac.reload.editor.EditorInternalFrame;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.contentpackaging.CP_EditorHandler;
import uk.ac.reload.editor.metadata.xml.MD_SchemaController;
import uk.ac.reload.editor.prefs.EditorPrefs;
import uk.ac.reload.editor.scorm.editor.SCORM12_Editor;
import uk.ac.reload.editor.scorm.editor.SCORM12_NewDialog;
import uk.ac.reload.editor.scorm.xml.SCORM12_CP112_SchemaController;
import uk.ac.reload.editor.scorm.xml.SCORM12_CP113_SchemaController;
import uk.ac.reload.editor.scorm.xml.SCORM12_Package;
import uk.ac.reload.editor.scorm.xml.SCORM12_SchemaController;
import uk.ac.reload.jdom.XMLUtils;
import uk.ac.reload.moonunit.SchemaController;
import uk.ac.reload.moonunit.schema.SchemaException;

public class SCORM12_EditorHandler
extends CP_EditorHandler {
    public static final String ADL_SCORM_1_2 = "ADL SCORM 1.2";
    public static final String ADL_SCORM_1_3 = "ADL SCORM 1.3";
    public static final String ADL_SCORM_1_2_CP_1_1_2 = "ADL SCORM 1.2, IMS Content Packaging 1.1.2";
    public static final String ADL_SCORM_1_2_CP_1_1_3 = "ADL SCORM 1.2, IMS Content Packaging 1.1.3";
    static Hashtable SUPPORTED_SCORM_NAMESPACES = new Hashtable();
    public static final File HELPER_FOLDER;
    public static final File PROFILE_FOLDER;
    public static final File SCHEMAHELPER_FOLDER;
    public static final File VOCAB_FOLDER;

    public boolean canEditFile(File file) {
        Document doc = null;
        try {
            doc = this.getDocument(file);
        }
        catch (Exception ex) {
            return false;
        }
        Namespace nameSpace = XMLUtils.getDocumentNamespace((Document)doc);
        if (nameSpace == null || nameSpace.equals((Object)Namespace.NO_NAMESPACE)) {
            return false;
        }
        Namespace nsSCORM = SCORM12_EditorHandler.getSCORM_Namespace(doc);
        if (nsSCORM == null) {
            return false;
        }
        if (!SUPPORTED_SCORM_NAMESPACES.containsKey(nsSCORM)) {
            return false;
        }
        return SUPPORTED_CP_NAMESPACES.containsKey(nameSpace);
    }

    public EditorInternalFrame editFile(File file) throws JDOMException, SchemaException, IOException {
        if (file.getName().toLowerCase().endsWith(".zip")) {
            File manifest = this.unzipManifest(file);
            if (manifest != null) {
                file = manifest;
            } else {
                throw new IOException("No manifest file");
            }
        }
        SCORM12_Package sp = new SCORM12_Package(file);
        return new SCORM12_Editor(sp);
    }

    public EditorInternalFrame newDocument() throws JDOMException, SchemaException, IOException {
        String versionCP = EditorPrefs.getInstance().getValue("default_scorm_cp_version");
        String versionMD = EditorPrefs.getInstance().getValue("default_scorm_md_version");
        String[] versionsMD = EditorHandler.MD_EDITORHANDLER.getSupportedVersions();
        String[] versionsCP = super.getSupportedVersions();
        SCORM12_NewDialog dialog = new SCORM12_NewDialog(versionsCP, versionCP, versionsMD, versionMD);
        File cpFolder = dialog.showDialog();
        if (cpFolder == null) {
            return null;
        }
        versionCP = dialog.getVersionCP();
        versionMD = dialog.getVersionMD();
        EditorPrefs.getInstance().putValue("default_scorm_cp_version", versionCP);
        EditorPrefs.getInstance().putValue("default_scorm_md_version", versionMD);
        String versionSCORM = "ADL SCORM 1.2, " + versionCP;
        SCORM12_SchemaController scormController = (SCORM12_SchemaController)this.getSchemaControllerInstance(versionSCORM);
        MD_SchemaController mdController = (MD_SchemaController)EditorHandler.MD_EDITORHANDLER.getSchemaControllerInstance(versionMD);
        SCORM12_Package sp = new SCORM12_Package(cpFolder, scormController, mdController);
        return new SCORM12_Editor(sp);
    }

    public String getName() {
        return Messages.getString("uk.ac.reload.editor.contentpackaging.scorm12.SCORM12_EditorHandler.0");
    }

    public Icon getIcon() {
        return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/cp_scorm.gif");
    }

    public String getDefaultVersion() {
        return "IMS Content Packaging 1.1.2";
    }

    public String getDefaultMDVersion() {
        return "IMS Metadata 1.2.1";
    }

    public String[] getSupportedVersions() {
        return new String[]{ADL_SCORM_1_2_CP_1_1_2, ADL_SCORM_1_2_CP_1_1_3};
    }

    public String getVersion(Namespace ns) {
        if (ns == null) {
            return null;
        }
        return "ADL SCORM 1.2, " + (String)SUPPORTED_CP_NAMESPACES.get(ns);
    }

    public SchemaController getSchemaControllerInstance(String version) throws JDOMException, SchemaException, IOException {
        SCORM12_SchemaController schemaController = null;
        if (ADL_SCORM_1_2_CP_1_1_2.equals(version)) {
            schemaController = new SCORM12_CP112_SchemaController();
        } else if (ADL_SCORM_1_2_CP_1_1_3.equals(version)) {
            schemaController = new SCORM12_CP113_SchemaController();
        }
        return schemaController;
    }

    static {
        SUPPORTED_SCORM_NAMESPACES.put(ADLCP_NAMESPACE_12, ADL_SCORM_1_2);
        HELPER_FOLDER = new File(EditorHandler.HELPERFOLDER, "scorm");
        PROFILE_FOLDER = new File(HELPER_FOLDER, "profile");
        SCHEMAHELPER_FOLDER = new File(HELPER_FOLDER, "schemahelper");
        VOCAB_FOLDER = new File(HELPER_FOLDER, "vocab");
    }
}

