/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.moonunit;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import uk.ac.reload.jdom.XMLPath;
import uk.ac.reload.moonunit.SchemaHelper;
import uk.ac.reload.moonunit.schema.SchemaAttribute;
import uk.ac.reload.moonunit.schema.SchemaElement;
import uk.ac.reload.moonunit.schema.SchemaException;
import uk.ac.reload.moonunit.schema.SchemaModel;
import uk.ac.reload.moonunit.schema.SchemaNode;
import uk.ac.reload.moonunit.vocab.Vocabulary;
import uk.ac.reload.moonunit.vocab.VocabularyList;

public abstract class SchemaController {
    private SchemaModel _schemaModel;
    private Vocabulary _vocab;
    private SchemaHelper _schemaHelper;

    protected SchemaController() {
    }

    protected SchemaController(SchemaModel schemaModel) {
        this.setSchemaModel(schemaModel);
    }

    protected SchemaController(SchemaModel schemaModel, Vocabulary vocab, SchemaHelper schemaHelper) {
        this.setSchemaModel(schemaModel);
        this.setVocabulary(vocab);
        this.setSchemaHelper(schemaHelper);
    }

    public void loadSchemaModel() throws SchemaException, IOException {
        if (this.getSchemaModel() == null) {
            this._schemaModel = SchemaModel.getSchemaModel(this.getVersion(), this.getSchemaFile(), this.getRootElementName());
        }
    }

    public void addImportedSchema(SchemaController subSchemaController, String nsPrefix) throws SchemaException {
        this.getSchemaModel().addImportedSchema(subSchemaController.getSchemaModel(), nsPrefix);
    }

    public void attachSchemaElement(SchemaController subSchemaController, String complexTypeName, String elementName) throws SchemaException {
        this.getSchemaModel().attachSchemaElement(subSchemaController.getSchemaModel(), complexTypeName, elementName);
    }

    public void setDefaultVocabLanguage(String lang) {
        Vocabulary vocab = this.getVocabulary();
        if (vocab != null) {
            vocab.setDefaultLanguage(lang);
        }
    }

    public boolean isTopLevelElement(SchemaElement schemaElement) {
        return schemaElement.getParent() == this.getSchemaModel().getRootElement();
    }

    public SchemaNode getSchemaNode(XMLPath xmlPath) {
        String attName;
        SchemaAttribute schemaAttribute;
        SchemaElement schemaElement = this.getSchemaModel().getRootElement();
        StringTokenizer t = xmlPath.getElements();
        while (t.hasMoreElements()) {
            String name = t.nextToken();
            if (name.equals(this.getSchemaModel().getRootElementName()) || (schemaElement = schemaElement.getChild(name)) != null) continue;
            return null;
        }
        if (xmlPath.isAttribute() && (schemaAttribute = schemaElement.getSchemaAttribute(attName = xmlPath.getAttributePart())) != null) {
            return schemaAttribute;
        }
        return schemaElement;
    }

    public String getElementHelperValue(XMLPath xmlPath, String helperKey) {
        SchemaHelper helper = this.getSchemaHelper();
        return helper == null ? null : helper.getHelperValue(xmlPath, helperKey);
    }

    public String getElementFriendlyName(XMLPath xmlPath) {
        return this.getElementHelperValue(xmlPath, "fname");
    }

    public String getElementTip(XMLPath xmlPath) {
        return this.getElementHelperValue(xmlPath, "tip");
    }

    public String getWidgetType(XMLPath xmlPath) {
        return this.getElementHelperValue(xmlPath, "widget");
    }

    public VocabularyList getVocabularyList(SchemaNode schemaNode) {
        if (schemaNode == null) {
            return null;
        }
        VocabularyList vList = null;
        Vocabulary vocab = this.getVocabulary();
        if (vocab != null) {
            vList = vocab.getVocabularyList(schemaNode);
        }
        if (vList == null) {
            vList = schemaNode.getVocabularyList();
        }
        return vList;
    }

    public String getDefaultValue(SchemaNode schemaNode) {
        String def = null;
        VocabularyList vList = this.getVocabularyList(schemaNode);
        if (vList != null) {
            def = vList.getDefaultValue();
        }
        if (def == null) {
            def = schemaNode.getDefaultValue();
        }
        return def;
    }

    public String getFacetValue(SchemaNode schemaNode, String facetName) {
        String value = this.getElementHelperValue(schemaNode.getXMLPath(), facetName);
        if (value == null) {
            value = schemaNode.getFacetValue(facetName);
        }
        return value;
    }

    public void setVocabulary(Vocabulary vocab) {
        this._vocab = vocab;
    }

    public Vocabulary getVocabulary() {
        return this._vocab;
    }

    public void setSchemaHelper(SchemaHelper schemaHelper) {
        this._schemaHelper = schemaHelper;
    }

    public SchemaHelper getSchemaHelper() {
        return this._schemaHelper;
    }

    public void setSchemaModel(SchemaModel schemaModel) {
        this._schemaModel = schemaModel;
    }

    public SchemaModel getSchemaModel() {
        return this._schemaModel;
    }

    public abstract String getVersion();

    public abstract String getRootElementName();

    public abstract File getSchemaFile();
}

