/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.diva.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import javax.swing.filechooser.FileSystemView;
import uk.ac.reload.diva.util.IProgressMonitor;

public final class FileUtils {
    private FileUtils() {
    }

    public static String getFileExtension(File file) {
        String fileName = file.getName();
        int i = fileName.lastIndexOf(46);
        if (i > 0 && i < fileName.length() - 1) {
            return fileName.substring(i + 1).toLowerCase();
        }
        return "";
    }

    public static String getFileNameWithoutExtension(File file) {
        String fileName = file.getName();
        int i = fileName.lastIndexOf(46);
        if (i > 0 && i < fileName.length() - 1) {
            return fileName.substring(0, i);
        }
        return fileName;
    }

    public static boolean copyFolder(File srcFolder, File destFolder, IProgressMonitor progressMonitor) throws IOException {
        if (srcFolder.equals(destFolder)) {
            if (progressMonitor != null) {
                progressMonitor.close();
            }
            throw new IOException("Source and target folders cannot be the same.");
        }
        for (File dest = destFolder.getParentFile(); dest != null; dest = dest.getParentFile()) {
            if (!dest.equals(srcFolder)) continue;
            if (progressMonitor != null) {
                progressMonitor.close();
            }
            throw new IOException("The destination folder cannot be a subfolder of the source folder.");
        }
        destFolder.mkdirs();
        File[] srcFiles = srcFolder.listFiles();
        for (int i = 0; i < srcFiles.length; ++i) {
            File srcFile = srcFiles[i];
            if (progressMonitor != null) {
                progressMonitor.setNote(srcFile.getName());
                if (progressMonitor.isCanceled()) {
                    return false;
                }
            }
            if (srcFile.isDirectory()) {
                FileUtils.copyFolder(srcFile, new File(destFolder, srcFile.getName()), progressMonitor);
                continue;
            }
            FileUtils.copyFile(srcFile, new File(destFolder, srcFile.getName()));
        }
        return true;
    }

    public static void copyFolder(File srcFolder, File destFolder) throws IOException {
        FileUtils.copyFolder(srcFolder, destFolder, null);
    }

    public static void copyFile(File srcFile, File destFile) throws IOException {
        int size;
        if (srcFile.equals(destFile)) {
            throw new IOException("Source and Target Files cannot be the same");
        }
        int bufSize = 1024;
        byte[] buf = new byte[bufSize];
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(srcFile), bufSize);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destFile), bufSize);
        while ((size = bis.read(buf)) != -1) {
            bos.write(buf, 0, size);
        }
        bos.flush();
        bos.close();
        bis.close();
    }

    public static void moveFile(File srcFile, File destFile) throws IOException {
        FileUtils.copyFile(srcFile, destFile);
        srcFile.delete();
    }

    public static void deleteFolder(File afolder) throws IOException {
        if (afolder == null) {
            return;
        }
        File parent = new File(afolder.getAbsolutePath()).getParentFile();
        if (parent == null) {
            throw new IOException("Cannot delete root folder");
        }
        FileSystemView view = FileSystemView.getFileSystemView();
        if (view.isRoot(afolder)) {
            throw new IOException("Cannot delete root folder");
        }
        if (afolder.exists() && afolder.isDirectory()) {
            File[] files = afolder.listFiles();
            int count = files.length;
            for (int i = 0; i < count; ++i) {
                File f = files[i];
                if (f.isFile()) {
                    f.delete();
                    continue;
                }
                if (!f.isDirectory()) continue;
                FileUtils.deleteFolder(f);
            }
            afolder.delete();
        }
    }

    public static String getRelativePath(File rootFolder, File file) {
        try {
            rootFolder = rootFolder.getCanonicalFile();
            file = file.getCanonicalFile();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        URI uriRoot = rootFolder.toURI();
        URI uriFile = file.toURI();
        URI result = uriRoot.relativize(uriFile);
        if (result == null) {
            return file.getName();
        }
        String str = result.getPath();
        return str == null ? file.getName() : str;
    }

    public static String getJarFilePath(Class aClass) {
        String myClassName = aClass.getName().replace('.', '/') + ".class";
        ClassLoader myClassLoader = aClass.getClassLoader();
        URL urlJar = myClassLoader.getResource(myClassName);
        String urlStr = urlJar.toString();
        if (urlStr.indexOf("jar:file:") == -1) {
            System.out.println("Not a jar");
            return null;
        }
        int from = "jar:file:".length();
        int to = urlStr.indexOf("!/");
        return urlStr.substring(from, to);
    }
}

