/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import uk.ac.reload.dweezil.gui.DweezilFileChooser;
import uk.ac.reload.dweezil.gui.DweezilToolBar;
import uk.ac.reload.dweezil.menu.MenuAction;
import uk.ac.reload.editor.IIcons;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.properties.EditorProperties;

public class EditorOpenDialog
implements IIcons {
    private static EditorOpenDialog _dialog = new EditorOpenDialog();
    private DweezilFileChooser _chooser = new DweezilFileChooser();

    public static File askFileNameOpen(Component parent, String title, FileFilter filter) {
        _dialog.getFileChooser().setDialogTitle(title);
        _dialog.getFileChooser().setFileFilter(filter);
        int returnVal = _dialog.getFileChooser().showOpenDialog(parent);
        if (returnVal != 0) {
            return null;
        }
        return _dialog.getFileChooser().getSelectedFileAndStore();
    }

    public EditorOpenDialog() {
        this.createAccessoryPanel();
    }

    public DweezilFileChooser getFileChooser() {
        return this._chooser;
    }

    protected void createAccessoryPanel() {
        final File folderSCORM = EditorProperties.getFileProperty("scormpackage.dir");
        if (folderSCORM == null || !folderSCORM.exists()) {
            return;
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        MenuAction action = new MenuAction("SCORM Player " + Messages.getString("uk.ac.reload.editor.EditorOpenDialog.0"), "uk/ac/reload/editor/resources/images/cp_scorm.gif"){

            public void actionPerformed(ActionEvent e) {
                EditorOpenDialog.this._chooser.setCurrentDirectory(folderSCORM);
            }
        };
        DweezilToolBar toolBar = new DweezilToolBar();
        toolBar.setOrientation(1);
        toolBar.add(action);
        panel.add((Component)toolBar);
        this._chooser.setAccessory((JComponent)panel);
    }
}

