/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging.xml;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import uk.ac.reload.diva.undo.UndoableAction;
import uk.ac.reload.diva.util.FileUtils;
import uk.ac.reload.diva.util.HTMLUtils;
import uk.ac.reload.diva.util.IProgressMonitor;
import uk.ac.reload.diva.util.RandomGUID;
import uk.ac.reload.editor.EditorHandler;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.contentpackaging.CP_EditorHandler;
import uk.ac.reload.editor.contentpackaging.datamodel.CP_Resource;
import uk.ac.reload.editor.contentpackaging.htmlparser.FileType;
import uk.ac.reload.editor.contentpackaging.htmlparser.HTMLParser;
import uk.ac.reload.editor.contentpackaging.xml.CP_SchemaController;
import uk.ac.reload.editor.metadata.MD_EditorHandler;
import uk.ac.reload.editor.metadata.xml.MD_SchemaController;
import uk.ac.reload.editor.properties.EditorProperties;
import uk.ac.reload.jdom.XMLDocument;
import uk.ac.reload.jdom.XMLDocumentListenerEvent;
import uk.ac.reload.jdom.XMLPath;
import uk.ac.reload.jdom.XMLUtils;
import uk.ac.reload.moonunit.SchemaController;
import uk.ac.reload.moonunit.SchemaDocument;
import uk.ac.reload.moonunit.contentpackaging.CP_Core;
import uk.ac.reload.moonunit.schema.SchemaElement;
import uk.ac.reload.moonunit.schema.SchemaException;
import uk.ac.reload.moonunit.schema.SchemaModel;

public class ContentPackage
extends SchemaDocument {
    static final String[] cp_comments = new String[]{"This is a Reload version " + EditorProperties.getString("VERSION") + " Content Package document", "Spawned from the Reload Content Package Generator - http://www.reload.ac.uk"};
    private CP_Core _cpCore = new CP_Core((XMLDocument)this);

    public ContentPackage() {
    }

    public ContentPackage(File projectFolder, CP_SchemaController cpController, MD_SchemaController mdController) throws IOException {
        if (projectFolder == null) {
            throw new NullPointerException("File cannot be null in ContentPackage constructor");
        }
        if (cpController == null) {
            throw new NullPointerException("CP_SchemaController cannot be null in ContentPackage constructor");
        }
        if (mdController == null) {
            throw new NullPointerException("MD_SchemaController cannot be null in ContentPackage constructor");
        }
        this.setSchemaController((SchemaController)cpController);
        cpController.setMD_SchemaController(mdController);
        this.init(projectFolder, cpController);
        this.saveDocument();
        this.setDirty(false);
        cpController.copySchemaFilesToFolder(projectFolder);
    }

    public ContentPackage(File file) throws JDOMException, SchemaException, IOException {
        String version;
        if (file == null) {
            throw new NullPointerException("File cannot be null in ContentPackage constructor");
        }
        this.setFile(file);
        this.setDocument(XMLUtils.readXMLFile((File)file));
        Namespace nameSpace = XMLUtils.getDocumentNamespace((Document)this.getDocument());
        String versionCP = EditorHandler.CP_EDITORHANDLER.getVersion(nameSpace);
        CP_SchemaController cpController = (CP_SchemaController)EditorHandler.CP_EDITORHANDLER.getSchemaControllerInstance(versionCP);
        this.setSchemaController((SchemaController)cpController);
        Namespace nsMD = this.getDocument().getRootElement().getNamespace("imsmd");
        if (nsMD != null && (version = EditorHandler.MD_EDITORHANDLER.getVersion(nsMD)) != null) {
            MD_SchemaController mdController = (MD_SchemaController)EditorHandler.MD_EDITORHANDLER.getSchemaControllerInstance(version);
            cpController.setMD_SchemaController(mdController);
        }
    }

    protected void init(File projectFolder, CP_SchemaController cpController) {
        this.setDocument(new Document());
        this.addCommentsToDocument();
        SchemaModel cpSchema = cpController.getSchemaModel();
        Element root = this.addElementBySchema((Object)this, null, cpSchema.getRootElement(), false);
        this.getDocument().setRootElement(root);
        SchemaModel mdSchema = cpController.getMD_SchemaController().getSchemaModel();
        Namespace mdNamespace = Namespace.getNamespace((String)MD_EditorHandler.IMSMD_NAMESPACE_PREFIX, (String)mdSchema.getTargetNamespaceURI());
        root.addNamespaceDeclaration(mdNamespace);
        root.addNamespaceDeclaration(XMLUtils.XSI_Namespace);
        StringBuffer schemaLocationURI = new StringBuffer();
        schemaLocationURI.append(cpSchema.getTargetNamespaceURI());
        schemaLocationURI.append(" ");
        schemaLocationURI.append(cpSchema.getSchemaName());
        schemaLocationURI.append(" ");
        schemaLocationURI.append(mdSchema.getTargetNamespaceURI());
        schemaLocationURI.append(" ");
        schemaLocationURI.append(mdSchema.getSchemaName());
        root.setAttribute(XMLUtils.XSI_SchemaLocation, schemaLocationURI.toString(), XMLUtils.XSI_Namespace);
        this.setFile(new File(projectFolder, "imsmanifest.xml"));
    }

    public void destroy() {
        this._cpCore.destroy();
        this._cpCore = null;
    }

    public String[] getComments() {
        return cp_comments;
    }

    public Element importManifest(File manifestFile, Element manifestElement, String base) throws FileNotFoundException, JDOMException, IOException {
        Element importedRootElement = null;
        Document importedDoc = XMLUtils.readXMLFile((File)manifestFile);
        if (importedDoc != null) {
            importedRootElement = importedDoc.getRootElement().detach();
            String rootSource = importedRootElement.getName();
            if (!rootSource.equals("manifest")) {
                throw new FileNotFoundException(Messages.getString("uk.ac.reload.editor.contentpackaging.ContentPackage.0"));
            }
            Namespace ns = importedRootElement.getNamespace();
            if (ns != null) {
                XMLUtils.replaceNamespaces((Element)importedRootElement, (Namespace)ns, (Namespace)this.getRootNamespace());
            }
            importedRootElement.removeAttribute(XMLUtils.XSI_SchemaLocation, XMLUtils.XSI_Namespace);
            importedRootElement.removeAttribute(XMLUtils.XSI_SchemaLocation, XMLUtils.XSI_NamespaceOLD);
            importedRootElement.removeNamespaceDeclaration(XMLUtils.XSI_Namespace);
            importedRootElement.removeNamespaceDeclaration(XMLUtils.XSI_NamespaceOLD);
            Vector<Namespace> v = new Vector<Namespace>();
            Iterator it = importedRootElement.getAdditionalNamespaces().listIterator();
            while (it.hasNext()) {
                ns = (Namespace)it.next();
                v.add(ns);
            }
            it = v.iterator();
            while (it.hasNext()) {
                ns = (Namespace)it.next();
                importedRootElement.removeNamespaceDeclaration(ns);
                Namespace ns2 = this.getRootElement().getNamespace(ns.getPrefix());
                if (ns2 != null) continue;
                this.getRootElement().addNamespaceDeclaration(ns);
            }
            Hashtable idmap = this.createNewIDs(importedRootElement);
            this.createNewIDRefs(importedRootElement, idmap);
            this.createNewPrerequisiteRefs(importedRootElement, idmap);
            importedRootElement.setAttribute("base", base + "/", Namespace.XML_NAMESPACE);
            this.addElementUndoable((Object)this, manifestElement, importedRootElement, false);
        }
        return importedRootElement;
    }

    public boolean exportManifest(Element manifestElement, File targetFolder) throws IOException {
        File imsmanifestFile;
        File sourceFolder;
        String base = this.getElementBase(manifestElement);
        if (base != null && (sourceFolder = new File(this.getProjectFolder(), base)).exists() && targetFolder.exists() && (imsmanifestFile = new File(sourceFolder, "imsmanifest.xml")).exists()) {
            FileUtils.copyFolder((File)sourceFolder, (File)targetFolder);
            return true;
        }
        File[] files = this.getResourceFiles(manifestElement);
        for (int i = 0; i < files.length; ++i) {
            String path = FileUtils.getRelativePath((File)this.getProjectFolder(), (File)files[i]);
            File newFile = new File(targetFolder, path);
            newFile.getParentFile().mkdirs();
            FileUtils.copyFile((File)files[i], (File)newFile);
        }
        File newFile = new File(targetFolder, "imsmanifest.xml");
        ContentPackage cp = new ContentPackage();
        cp.setDocument(new Document());
        cp.setFile(newFile);
        cp.addCommentsToDocument();
        Element newRoot = (Element)manifestElement.clone();
        cp.getDocument().setRootElement(newRoot);
        Element documentRoot = this.getDocument().getRootElement();
        newRoot.setAttributes(null);
        Iterator it = documentRoot.getAttributes().iterator();
        while (it.hasNext()) {
            Attribute att = (Attribute)it.next();
            newRoot.setAttribute((Attribute)att.clone());
        }
        it = documentRoot.getAdditionalNamespaces().iterator();
        while (it.hasNext()) {
            Namespace ns = (Namespace)it.next();
            newRoot.addNamespaceDeclaration(ns);
        }
        newRoot.setAttribute("identifier", RandomGUID.getUniqueID((String)"MANIFEST-"));
        cp.saveDocument();
        FileFilter filter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return false;
                }
                return file.getName().toLowerCase().endsWith(".xsd");
            }
        };
        files = this.getProjectFolder().listFiles(filter);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                FileUtils.copyFile((File)files[i], (File)new File(targetFolder, files[i].getName()));
            }
        }
        return true;
    }

    public boolean saveDocumentAs(File targetFolder, IProgressMonitor monitor) throws IOException {
        File targetManifest = new File(targetFolder, this.getFile().getName());
        boolean result = FileUtils.copyFolder((File)this.getProjectFolder(), (File)targetFolder, (IProgressMonitor)monitor);
        if (!result) {
            return false;
        }
        Hashtable idmap = this.createNewIDs(this.getRootElement());
        this.createNewIDRefs(this.getRootElement(), idmap);
        this.createNewPrerequisiteRefs(this.getRootElement(), idmap);
        this.setFile(targetManifest);
        this.saveDocument();
        return true;
    }

    public String getProjectName() {
        return this.getProjectFolder() == null ? null : this.getProjectFolder().getName();
    }

    public File getProjectFolder() {
        return this.getFile() == null ? null : this.getFile().getParentFile();
    }

    public Element getMetadataLomElement(Element mdElement) {
        Element lomElement = null;
        Namespace ns = this.getDocument().getRootElement().getNamespace("imsmd");
        if (ns != null && (lomElement = mdElement.getChild("lom", ns)) == null) {
            lomElement = mdElement.getChild("record", ns);
        }
        if (lomElement == null) {
            Iterator i = mdElement.getChildren().iterator();
            while (i.hasNext()) {
                Element element = (Element)i.next();
                if (!element.getName().equals("lom") && !element.getName().equals("record")) continue;
                lomElement = element;
                break;
            }
        }
        return lomElement;
    }

    public boolean canCopyElement(Element element) {
        return false;
    }

    public boolean canCutElement(Element element) {
        return false;
    }

    public boolean canPasteFromClipboard(Element element) {
        return false;
    }

    public boolean canDragElement(Element element, int action) {
        if (element != null) {
            if (!this.isDocumentNamespace(element)) {
                return false;
            }
            String name = element.getName();
            if (name.equals("resource") || name.equals("metadata") || name.equals("item") || name.equals("organization") || name.equals("manifest")) {
                return true;
            }
        }
        return false;
    }

    public boolean acceptElement(Element sourceElement, Element targetElement, int actionCopyMove) {
        if (sourceElement != null && targetElement != null) {
            boolean differentDoc;
            if (!sourceElement.getNamespace().equals((Object)targetElement.getNamespace())) {
                return false;
            }
            if (sourceElement.equals((Object)targetElement)) {
                return false;
            }
            if ((actionCopyMove & 2) != 0) {
                if (targetElement.getContent().contains(sourceElement)) {
                    return false;
                }
                if (targetElement.isAncestor(sourceElement)) {
                    return false;
                }
            }
            Element targetManifest = this.getParentManifestElement(targetElement);
            Element sourceManifest = this.getParentManifestElement(sourceElement);
            if (targetManifest == null || sourceManifest == null) {
                return false;
            }
            String sourceName = sourceElement.getName();
            String targetName = targetElement.getName();
            boolean bl = differentDoc = !XMLUtils.isMemberOfSameDocument((Element)sourceElement, (Element)targetElement);
            if (differentDoc) {
                return false;
            }
            if (sourceName.equals("resource")) {
                if (targetName.equals("organization") || targetName.equals("item")) {
                    if (targetManifest == sourceManifest) {
                        return true;
                    }
                    return sourceManifest.isAncestor(targetManifest);
                }
                if (targetName.equals("resources")) {
                    return !this.containsResource(sourceElement, targetElement);
                }
            }
            if (sourceName.equals("item")) {
                if (targetName.equals("organization") || targetName.equals("item")) {
                    if (targetManifest == sourceManifest) {
                        return true;
                    }
                    Element refElement = this.getReferencedElement(sourceElement);
                    if (refElement != null) {
                        Element ref_targetManifest = this.getParentManifestElement(refElement);
                        return ref_targetManifest.isAncestor(targetManifest) || ref_targetManifest == targetManifest;
                    }
                    return true;
                }
            } else if (sourceName.equals("manifest")) {
                if (targetName.equals("organization") || targetName.equals("item")) {
                    return sourceManifest.isAncestor(targetManifest);
                }
                if (targetName.equals("manifest")) {
                    return false;
                }
            } else {
                return this.isAllowedChild(targetElement, sourceElement);
            }
        }
        return false;
    }

    public Element shiftElement(Element sourceElement, Element targetElement, int action) {
        if (sourceElement != null && targetElement != null) {
            Element targetManifest = this.getParentManifestElement(targetElement);
            Element sourceManifest = this.getParentManifestElement(sourceElement);
            if (targetManifest == null || sourceManifest == null) {
                return null;
            }
            if (targetManifest != sourceManifest) {
                action = 1;
            }
            String sourceName = sourceElement.getName();
            String targetName = targetElement.getName();
            if (sourceName.equals("resource")) {
                if (targetName.equals("organization") || targetName.equals("item")) {
                    return this.addItemResource(targetElement, sourceElement, true);
                }
                if (targetName.equals("resources")) {
                    return this.shiftElement(sourceElement, targetElement, action, true);
                }
            } else if (sourceName.equals("manifest")) {
                if (targetName.equals("organization") || targetName.equals("item")) {
                    return this.addItemManifest(sourceElement, targetElement, true);
                }
                if (targetName.equals("manifest")) {
                    return this.shiftElement(sourceElement, targetElement, action, true);
                }
            } else if (this.isAllowedChild(targetElement, sourceElement)) {
                return this.shiftElement(sourceElement, targetElement, action, true);
            }
        }
        return null;
    }

    protected Element shiftElement(Element sourceElement, Element targetElement, int action, boolean doSelect) {
        if ((action & 1) != 0) {
            return this.copyElementUndoable((Object)this, sourceElement, targetElement, doSelect);
        }
        if ((action & 2) != 0) {
            return this.moveElementUndoable((Object)this, sourceElement, targetElement, doSelect);
        }
        return null;
    }

    public Element addElementBySchema(Object source, Element parentElement, SchemaElement newSchemaElement, boolean doSelect) {
        Element newElement = super.addElementBySchema(source, parentElement, newSchemaElement, doSelect);
        if (newElement != null && this.isDocumentNamespace(newElement)) {
            String name = newElement.getName();
            if (name.equals("organization")) {
                this.setDefaultOrganization(newElement);
                this.addTitle(newElement, "Organization");
                this.addAttributeWithDefaultValue(source, newElement, "structure");
            } else if (name.equals("item")) {
                this.addTitle(newElement, "Item");
                this.addAttributeWithDefaultValue(source, newElement, "isvisible");
            }
        }
        this.fireElementChanged(new XMLDocumentListenerEvent(source, (XMLDocument)this, newElement, false));
        return newElement;
    }

    public Element copyElementUndoable(Object source, Element element, Element newParent, boolean doSelect) {
        Element newElement = super.copyElementUndoable(source, element, newParent, doSelect);
        this.copypasteElement(newElement);
        return newElement;
    }

    public Element pasteElementUndoable(Object source, Element element, Element newParent, boolean doSelect) {
        Element newElement = super.pasteElementUndoable(source, element, newParent, doSelect);
        this.copypasteElement(newElement);
        return newElement;
    }

    protected void copypasteElement(Element newElement) {
        if (newElement != null) {
            String name = newElement.getName();
            if (name.equals("item") || name.equals("resource")) {
                this.createNewIDs(newElement);
            } else if (name.equals("organization")) {
                this.createNewIDs(newElement);
                this.setDefaultOrganization(newElement);
                this.checkIDRefs(newElement);
            } else if (name.equals("manifest")) {
                Hashtable map = this.createNewIDs(newElement);
                this.createNewIDRefs(newElement, map);
            }
        }
    }

    protected Element addItemManifest(Element manifestElement, Element targetElement, boolean doSelect) {
        String manifestID;
        XMLPath xmlPath = XMLPath.getXMLPathForElement((Element)targetElement);
        xmlPath.appendElementName("item");
        SchemaElement schemaElement = (SchemaElement)this.getSchemaController().getSchemaNode(xmlPath);
        Element itemElement = this.addElementBySchemaUndoable((Object)this, targetElement, schemaElement, doSelect);
        if (itemElement != null && (manifestID = manifestElement.getAttributeValue("identifier")) != null) {
            itemElement.setAttribute("identifierref", manifestID);
        }
        return itemElement;
    }

    protected Element addItemResource(Element parentElement, Element resourceElement, boolean doSelect) {
        XMLPath xmlPath = XMLPath.getXMLPathForElement((Element)parentElement);
        xmlPath.appendElementName("item");
        SchemaElement schemaElement = (SchemaElement)this.getSchemaController().getSchemaNode(xmlPath);
        Element itemElement = this.addElementBySchemaUndoable((Object)this, parentElement, schemaElement, doSelect);
        if (itemElement != null && resourceElement != null) {
            String resourceID = resourceElement.getAttributeValue("identifier");
            if (resourceID != null) {
                itemElement.setAttribute("identifierref", resourceID);
            }
            this.addItemTitle(itemElement, resourceElement);
        }
        return itemElement;
    }

    protected Element addOrganization(Element parentElement, boolean doSelect) {
        XMLPath xmlPath = XMLPath.getXMLPathForElement((Element)parentElement);
        xmlPath.appendElementName("organization");
        SchemaElement schemaElement = (SchemaElement)this.getSchemaController().getSchemaNode(xmlPath);
        return this.addElementBySchemaUndoable((Object)this, parentElement, schemaElement, doSelect);
    }

    protected Element addTitle(Element parentElement, String text) {
        Element titleElement = parentElement.getChild("title", parentElement.getNamespace());
        if (titleElement != null) {
            titleElement.setText(text);
        } else {
            titleElement = new Element("title", parentElement.getNamespace());
            titleElement.setText(text);
            this.addElement((Object)this, parentElement, titleElement, false);
        }
        return titleElement;
    }

    protected Element addItemTitle(Element itemElement, Element resourceElement) {
        Element titleElement = null;
        if (itemElement != null && resourceElement != null) {
            String title = null;
            File file = this.getResourceFile(resourceElement);
            if (file != null) {
                String ext = FileUtils.getFileExtension((File)file);
                if (ext.equals("html") || ext.equals("htm")) {
                    try {
                        title = HTMLUtils.getTagText((File)file, (String)"title");
                        if (title == null) {
                            title = FileUtils.getFileNameWithoutExtension((File)file);
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        title = FileUtils.getFileNameWithoutExtension((File)file);
                    }
                } else {
                    title = FileUtils.getFileNameWithoutExtension((File)file);
                }
            }
            titleElement = this.addTitle(itemElement, title);
        }
        return titleElement;
    }

    public String getElementDisplayName(Element element) {
        String fname = null;
        if (element != null) {
            String name = element.getName();
            if (name.equals("item") || name.equals("organization")) {
                Element titleElement = element.getChild("title", element.getNamespace());
                if (titleElement != null) {
                    fname = titleElement.getText();
                }
            } else if (name.equals("dependency")) {
                fname = this.getElementHREF(element);
            } else if (name.equals("manifest")) {
                fname = element.getAttributeValue("identifier");
            } else if (name.equals("resource")) {
                fname = element.getAttributeValue("href");
                if (fname == null) {
                    fname = element.getAttributeValue("identifier");
                }
            } else if (name.equals("file")) {
                fname = element.getAttributeValue("href");
            } else if (name.equals("schema") || name.equals("schemaversion")) {
                fname = element.getText();
            }
            if ((fname == null || fname.equals("")) && (fname = this.getSchemaController().getElementFriendlyName(XMLPath.getXMLPathForElement((Element)element))) == null) {
                fname = element.getQualifiedName();
            }
        }
        return fname;
    }

    public Element getReferencedElement(Element sourceElement) {
        return this._cpCore.getReferencedElement(sourceElement);
    }

    public boolean isReferencingElement(Element element) {
        return this._cpCore.isReferencingElement(element);
    }

    public String[] getReferencedIdentifersAllowed(Element element) {
        return this._cpCore.getReferencedIdentifersAllowed(element);
    }

    public Element[] getReferencedElementsAllowed(Element element) {
        return this._cpCore.getReferencedElementsAllowed(element);
    }

    public Element[] getOrganizations(Element orgsElement) {
        return this._cpCore.getOrganizations(orgsElement);
    }

    public Element[] getOrganizationsAllowed(Element orgsElement) {
        return this._cpCore.getOrganizationsAllowed(orgsElement);
    }

    public Element getDefaultOrganization(Element orgsElement) {
        return this._cpCore.getDefaultOrganization(orgsElement);
    }

    public Element getParentManifestElement(Element element) {
        return this._cpCore.getParentManifestElement(element);
    }

    public Element[] getElementsInManifest(Element manifestElement, String elementName, Namespace ns) {
        return this._cpCore.getElementsInManifest(manifestElement, elementName, ns);
    }

    public Element getElementByIdentifier(Element parent, String identifier) {
        return this._cpCore.getElementByIdentifier(parent, identifier);
    }

    public boolean isMetadataRoot(String name) {
        return this._cpCore.isMetadataRoot(name);
    }

    public boolean isMetadataElement(String name) {
        return this._cpCore.isMetadataElement(name);
    }

    public String getRelativeURL(Element element) {
        return this._cpCore.getRelativeURL(element);
    }

    public String getAbsoluteURL(Element element) {
        return this._cpCore.getAbsoluteURL(element);
    }

    public String getElementHREF(Element element) {
        return this._cpCore.getElementHREF(element);
    }

    public String getElementBase(Element element) {
        return this._cpCore.getElementBase(element);
    }

    public String getParameters(Element element) {
        return this._cpCore.getParameters(element);
    }

    public File getResourceFile(Element element) {
        return this._cpCore.getResourceFile(element);
    }

    public File[] getResourceFiles(Element manifestElement) {
        return this._cpCore.getResourceFiles(manifestElement);
    }

    public Element getResourceElementByHREF(String href, Element resourcesElement) {
        return this._cpCore.getResourceElementByHREF(href, resourcesElement);
    }

    public Element getFileElementByHREF(String href, Element resourceElement) {
        return this._cpCore.getFileElementByHREF(href, resourceElement);
    }

    public Element getResourcesElement(Element element) {
        return this._cpCore.getResourcesElement(element);
    }

    protected Hashtable createNewIDs(Element element) {
        Hashtable idmap = new Hashtable();
        this.createNewIDs(element, idmap);
        return idmap;
    }

    protected void createNewIDs(Element element, Hashtable idmap) {
        if (element != null && this.isDocumentNamespace(element)) {
            String oldID = element.getAttributeValue("identifier");
            if (oldID != null) {
                String newID = this.generateUniqueID(element);
                idmap.put(oldID, element);
                element.setAttribute("identifier", newID);
            }
            Iterator it = element.getChildren().iterator();
            while (it.hasNext()) {
                Element child = (Element)it.next();
                this.createNewIDs(child, idmap);
            }
        }
    }

    protected void createNewIDRefs(Element element, Hashtable idmap) {
        if (element != null && this.isDocumentNamespace(element)) {
            String newID;
            Element ref_element;
            String name = element.getName();
            String attrib = name.equals("organizations") ? "default" : "identifierref";
            String idref = element.getAttributeValue(attrib);
            if (idref != null && !idref.equals("") && (ref_element = (Element)idmap.get(idref)) != null && (newID = ref_element.getAttributeValue("identifier")) != null) {
                element.setAttribute(attrib, newID);
            }
            Iterator it = element.getChildren().iterator();
            while (it.hasNext()) {
                Element child = (Element)it.next();
                this.createNewIDRefs(child, idmap);
            }
        }
    }

    protected void createNewPrerequisiteRefs(Element element, Hashtable id_map) {
        if (element != null && this.isDocumentNamespace(element)) {
            String script;
            Element prereq = element.getChild("prerequisites", CP_EditorHandler.ADLCP_NAMESPACE_12);
            if (prereq != null && (script = prereq.getText()) != null && !script.equals("")) {
                Enumeration e = id_map.keys();
                while (e.hasMoreElements()) {
                    String newID;
                    Element ref_element;
                    String oldID = (String)e.nextElement();
                    int index = script.indexOf(oldID);
                    if (index == -1 || (ref_element = (Element)id_map.get(oldID)) == null || (newID = ref_element.getAttributeValue("identifier")) == null) continue;
                    script = script.replaceAll(oldID, newID);
                }
                prereq.setText(script);
            }
            Iterator it = element.getChildren().iterator();
            while (it.hasNext()) {
                Element child = (Element)it.next();
                this.createNewPrerequisiteRefs(child, id_map);
            }
        }
    }

    protected void checkIDRefs(Element element) {
        if (element != null && this.isDocumentNamespace(element)) {
            Attribute att;
            Element ref_element = this.getReferencedElement(element);
            if (ref_element == null && (att = element.getAttribute("identifierref")) != null) {
                element.removeAttribute(att);
            }
            Iterator it = element.getChildren().iterator();
            while (it.hasNext()) {
                Element child = (Element)it.next();
                this.checkIDRefs(child);
            }
        }
    }

    public String generateUniqueID(Element element) {
        String elementName = element.getName();
        String prefix = elementName.equals("manifest") ? "MANIFEST-" : (elementName.equals("organization") ? "ORG-" : (elementName.equals("item") ? "ITEM-" : (elementName.equals("resource") ? "RES-" : "RLD-")));
        return RandomGUID.getUniqueID((String)prefix);
    }

    protected void setDefaultOrganization(Element organization) {
        String id;
        Element orgs = organization.getParent();
        if (orgs.getChildren("organization", orgs.getNamespace()).size() == 1 && (id = organization.getAttributeValue("identifier")) != null) {
            orgs.setAttribute("default", id);
        }
    }

    public Element addCP_Resources(CP_Resource[] reloadResources, Element parentElement) {
        Element element = null;
        for (int i = 0; i < reloadResources.length; ++i) {
            element = this.addCP_Resource(reloadResources[i], parentElement);
        }
        return element;
    }

    public Element addCP_Resource(CP_Resource reloadResource, Element parentElement) {
        if (reloadResource.isDirectory()) {
            String name = parentElement.getName();
            if (name.equals("organizations")) {
                parentElement = this.addOrganization(parentElement, false);
                this.addTitle(parentElement, reloadResource.getName());
            } else if (name.equals("organization") || name.equals("item")) {
                parentElement = this.addItemResource(parentElement, null, false);
                this.addTitle(parentElement, reloadResource.getName());
            }
            CP_Resource[] resources = reloadResource.getChildren();
            if (resources != null) {
                for (int i = 0; i < resources.length; ++i) {
                    this.addCP_Resource(resources[i], parentElement);
                }
            }
            return parentElement;
        }
        return this.addCP_Resource(reloadResource, parentElement, false);
    }

    protected Element addCP_Resource(CP_Resource reloadResource, Element parentElement, boolean doSelect) {
        String name = parentElement.getName();
        if (name.equals("resource")) {
            Element fileElement = this.getFileByCP_Resource(reloadResource, parentElement);
            if (fileElement == null) {
                fileElement = this.addFileElement(reloadResource, parentElement, doSelect);
            }
            return fileElement;
        }
        Element resourcesElement = this.getResourcesElement(parentElement);
        Element resourceElement = this.getResourceByCP_Resource(reloadResource, resourcesElement);
        if (resourceElement == null) {
            resourceElement = this.addCP_ResourceToResourcesElement(reloadResource, resourcesElement, doSelect);
        }
        if (name.equals("organization") || name.equals("item")) {
            return this.addItemResource(parentElement, resourceElement, doSelect);
        }
        return resourceElement;
    }

    protected Element addCP_ResourceToResourcesElement(CP_Resource reloadResource, Element resourcesElement, boolean doSelect) {
        XMLPath xmlPath = XMLPath.getXMLPathForElement((Element)resourcesElement);
        xmlPath.appendElementName("resource");
        SchemaElement schemaElement = (SchemaElement)this.getSchemaController().getSchemaNode(xmlPath);
        Element resourceElement = this.addElementBySchema((Object)this, resourcesElement, schemaElement, doSelect);
        if (resourceElement != null) {
            String href = FileUtils.getRelativePath((File)this.getProjectFolder(), (File)reloadResource);
            href = href.replaceAll(" ", "%20");
            resourceElement.setAttribute("href", href);
            this.addFileElements(reloadResource, resourceElement, doSelect);
            if (this.getUndoHandler() != null) {
                SchemaDocument.UndoableAddAction addAction = new SchemaDocument.UndoableAddAction((SchemaDocument)this, resourcesElement, resourceElement);
                this.getUndoHandler().addUndoableAction((UndoableAction)addAction);
            }
        }
        return resourceElement;
    }

    protected Element getResourceByCP_Resource(CP_Resource reloadResource, Element resourcesElement) {
        String href = FileUtils.getRelativePath((File)this.getProjectFolder(), (File)reloadResource);
        return this.getResourceElementByHREF(href, resourcesElement);
    }

    protected Element getFileByCP_Resource(CP_Resource reloadResource, Element resourceElement) {
        String href = FileUtils.getRelativePath((File)this.getProjectFolder(), (File)reloadResource);
        return this.getFileElementByHREF(href, resourceElement);
    }

    public boolean containsResource(Element sourceElement, Element resourcesElement) {
        String href;
        if (sourceElement != null && resourcesElement != null && sourceElement.getName().equals("resource") && resourcesElement.getName().equals("resources") && (href = sourceElement.getAttributeValue("href")) != null) {
            return this.containsResource(href, resourcesElement);
        }
        return false;
    }

    protected boolean containsResource(String href, Element resourcesElement) {
        Element element = this.getResourceElementByHREF(href, resourcesElement);
        return element != null;
    }

    protected boolean containsFile(String href, Element resourceElement) {
        Element element = this._cpCore.getFileElementByHREF(href, resourceElement);
        return element != null;
    }

    public boolean acceptsCP_Resources(Element targetElement) {
        if (!targetElement.getNamespace().equals((Object)this.getTargetNamespace())) {
            return false;
        }
        String name = targetElement.getName();
        return name.equals("manifest") || name.equals("resources") || name.equals("resource") || name.equals("organization") || name.equals("item") || name.equals("organizations");
    }

    protected void addFileElements(CP_Resource cpResource, Element resourceElement, boolean doSelect) {
        XMLPath xmlPath = XMLPath.getXMLPathForElement((Element)resourceElement);
        xmlPath.appendElementName("file");
        SchemaElement fileSchemaElement = (SchemaElement)this.getSchemaController().getSchemaNode(xmlPath);
        Element fileElement = this.addElementBySchema((Object)this, resourceElement, fileSchemaElement, doSelect);
        if (fileElement != null) {
            String href = FileUtils.getRelativePath((File)this.getProjectFolder(), (File)cpResource);
            href = href.replaceAll(" ", "%20");
            fileElement.setAttribute("href", href);
        }
        if (FileType.isParseableFile(cpResource)) {
            HTMLParser parser = new HTMLParser(cpResource, this.getProjectFolder());
            File[] files = parser.getAllLinks();
            for (int i = 0; i < files.length; ++i) {
                String href = FileUtils.getRelativePath((File)this.getProjectFolder(), (File)files[i]);
                if (this.containsFile(href = href.replaceAll(" ", "%20"), resourceElement)) continue;
                fileElement = this.addElementBySchema((Object)this, resourceElement, fileSchemaElement, doSelect);
                fileElement.setAttribute("href", href);
            }
        }
    }

    protected Element addFileElement(File reloadResource, Element resourceElement, boolean doSelect) {
        XMLPath xmlPath = XMLPath.getXMLPathForElement((Element)resourceElement);
        xmlPath.appendElementName("file");
        SchemaElement fileSchemaElement = (SchemaElement)this.getSchemaController().getSchemaNode(xmlPath);
        Element fileElement = this.addElementBySchemaUndoable((Object)this, resourceElement, fileSchemaElement, doSelect);
        if (fileElement != null) {
            String href = FileUtils.getRelativePath((File)this.getProjectFolder(), (File)reloadResource);
            href = href.replaceAll(" ", "%20");
            fileElement.setAttribute("href", href);
            this.fireElementChanged(new XMLDocumentListenerEvent((Object)this, (XMLDocument)this, fileElement, false));
        }
        return fileElement;
    }
}

