/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.datamodel;

import java.util.Vector;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.IDataModelListener;
import uk.ac.reload.moonunit.SchemaDocument;

public abstract class DataModel {
    private SchemaDocument _schemaDocument;
    private Vector _listeners = new Vector();

    public DataModel(SchemaDocument schemaDocument) {
        this._schemaDocument = schemaDocument;
    }

    public SchemaDocument getSchemaDocument() {
        return this._schemaDocument;
    }

    public void destroy() {
        this._schemaDocument.destroy();
        this._schemaDocument = null;
        this._listeners.clear();
        this._listeners = null;
    }

    public synchronized void addIDataModelListener(IDataModelListener listener) {
        if (!this._listeners.contains(listener)) {
            this._listeners.addElement(listener);
        }
    }

    public synchronized void removeIDataModelListener(IDataModelListener listener) {
        this._listeners.removeElement(listener);
    }

    public void fireDataComponentAdded(DataComponent component) {
        for (int i = this._listeners.size() - 1; i >= 0; --i) {
            IDataModelListener listener = (IDataModelListener)this._listeners.elementAt(i);
            listener.componentAdded(component);
        }
    }

    public void fireDataComponentRemoved(DataComponent component) {
        for (int i = this._listeners.size() - 1; i >= 0; --i) {
            IDataModelListener listener = (IDataModelListener)this._listeners.elementAt(i);
            listener.componentRemoved(component);
        }
    }

    public void fireDataComponentMoved(DataComponent component) {
        for (int i = this._listeners.size() - 1; i >= 0; --i) {
            IDataModelListener listener = (IDataModelListener)this._listeners.elementAt(i);
            listener.componentMoved(component);
        }
    }

    public void fireDataComponentChanged(DataComponent component) {
        for (int i = this._listeners.size() - 1; i >= 0; --i) {
            IDataModelListener listener = (IDataModelListener)this._listeners.elementAt(i);
            listener.componentChanged(component);
        }
    }
}

