/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.datamodel.types;

public class DurationType {
    int _years;
    int _months;
    int _days;
    int _hours;
    int _mins;
    int _secs;

    public DurationType() {
    }

    public DurationType(String durationString) {
        this.setDurationString(durationString);
    }

    public DurationType(int years, int months, int days, int hours, int mins, int secs) {
        this._years = years;
        this._months = months;
        this._days = days;
        this._hours = hours;
        this._mins = mins;
        this._secs = secs;
    }

    public void setDurationString(String durationString) {
        this._years = this.parseValue(durationString, "y");
        this._months = this.parseValue(durationString, "m");
        this._days = this.parseValue(durationString, "d");
        this._hours = this.parseValue(durationString, "h");
        this._mins = this.parseValue(durationString, "mm");
        this._secs = this.parseValue(durationString, "s");
    }

    public String getDurationString() {
        String s = "";
        if (this.getYears() != 0) {
            s = this.getYears() + "Y";
        }
        if (this.getMonths() != 0) {
            s = s + this.getMonths() + "M";
        }
        if (this.getDays() != 0) {
            s = s + this.getDays() + "D";
        }
        if (this.getHours() != 0 || this.getMinutes() != 0 || this.getSeconds() != 0) {
            s = s + "T";
        }
        if (this.getHours() != 0) {
            s = s + this.getHours() + "H";
        }
        if (this.getMinutes() != 0) {
            s = s + this.getMinutes() + "M";
        }
        if (this.getSeconds() != 0) {
            s = s + this.getSeconds() + "S";
        }
        return s == "" ? null : "P" + s;
    }

    public int getYears() {
        return this._years;
    }

    public void setYears(int years) {
        this._years = years;
    }

    public int getMonths() {
        return this._months;
    }

    public void setMonths(int months) {
        this._months = months;
    }

    public int getDays() {
        return this._days;
    }

    public void setDays(int days) {
        this._days = days;
    }

    public int getHours() {
        return this._hours;
    }

    public void setHours(int hours) {
        this._hours = hours;
    }

    public int getMinutes() {
        return this._mins;
    }

    public void setMinutes(int mins) {
        this._mins = mins;
    }

    public int getSeconds() {
        return this._secs;
    }

    public void setSeconds(int secs) {
        this._secs = secs;
    }

    private int parseValue(String durationString, String delimiter) {
        char c;
        int startpos;
        if (this.isEmptyOrNull(durationString)) {
            return 0;
        }
        if (!this.hasStartDesignator(durationString)) {
            return 0;
        }
        String d = durationString.toLowerCase();
        if ("m".equals(delimiter)) {
            int t = d.indexOf("t");
            if (t != -1) {
                d = d.substring(0, d.indexOf("t"));
            }
        } else if ("h".equals(delimiter) || "mm".equals(delimiter) || "s".equals(delimiter)) {
            if (!this.hasTimeDelimiter(durationString)) {
                return 0;
            }
            try {
                d = d.substring(d.indexOf("t"));
            }
            catch (StringIndexOutOfBoundsException ex) {
                return 0;
            }
            if ("mm".equals(delimiter)) {
                delimiter = "m";
            }
        }
        int endpos = d.indexOf(delimiter);
        if (endpos <= 0) {
            return 0;
        }
        for (startpos = endpos - 1; startpos >= 0 && Character.isDigit(c = d.charAt(startpos)); --startpos) {
        }
        if (startpos < 0) {
            return 0;
        }
        String num = d.substring(startpos + 1, endpos);
        try {
            return Integer.parseInt(num);
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    private boolean hasStartDesignator(String durationString) {
        if (this.isEmptyOrNull(durationString)) {
            return false;
        }
        String d = durationString.toLowerCase();
        return d.indexOf("p") == 0;
    }

    private boolean hasTimeDelimiter(String durationString) {
        if (this.isEmptyOrNull(durationString)) {
            return false;
        }
        String d = durationString.toLowerCase();
        return d.indexOf("t") != -1;
    }

    private boolean isEmptyOrNull(String s) {
        return s == null || "".equals(s);
    }
}

