/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.gui.widgets;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import uk.ac.reload.editor.datamodel.DataElement;
import uk.ac.reload.jdom.XMLPath;
import uk.ac.reload.moonunit.schema.SchemaAttribute;

public class DocumentListenerAdapter
implements DocumentListener {
    private DataElement _dataElement;
    private String _attName;
    private Namespace _ns;
    private SchemaAttribute _schemaAttribute;
    private JTextComponent _textComponent;
    private boolean doNotify = true;

    public DocumentListenerAdapter(JTextComponent textComponent) {
        this._textComponent = textComponent;
        this._textComponent.getDocument().addDocumentListener(this);
    }

    public void setAttribute(DataElement dataElement, String attName, Namespace ns) {
        Attribute att;
        this._dataElement = dataElement;
        this._attName = attName;
        this._ns = ns == null ? Namespace.NO_NAMESPACE : ns;
        String text = "";
        Element element = this._dataElement.getElement();
        if (element != null && (att = element.getAttribute(attName, this._ns)) != null) {
            text = att.getValue();
        }
        this.doNotify = false;
        this._textComponent.setText(text);
        this.doNotify = true;
    }

    public void setElement(DataElement dataElement) {
        this._dataElement = dataElement;
        this._attName = null;
        this.doNotify = false;
        Element element = this._dataElement.getElement();
        String text = element == null ? "" : element.getText();
        this._textComponent.setText(text);
        this.doNotify = true;
    }

    private SchemaAttribute getSchemaAttribute(Attribute att) {
        if (this._schemaAttribute == null) {
            XMLPath xmlPath = XMLPath.getXMLPathForAttribute((Attribute)att);
            this._schemaAttribute = (SchemaAttribute)this._dataElement.getDataModel().getSchemaDocument().getSchemaController().getSchemaNode(xmlPath);
        }
        return this._schemaAttribute;
    }

    public void changedUpdate(DocumentEvent e) {
        this.notifyTextChange();
    }

    public void insertUpdate(DocumentEvent e) {
        this.notifyTextChange();
    }

    public void removeUpdate(DocumentEvent e) {
        this.notifyTextChange();
    }

    protected void notifyTextChange() {
        if (this.doNotify) {
            Element element = this._dataElement.getElement();
            if (element == null) {
                element = this._dataElement.createElement();
            }
            if (element != null) {
                String text = this._textComponent.getText();
                if (this._attName != null) {
                    Attribute att = element.getAttribute(this._attName, this._ns);
                    if ("".equals(text) && att != null) {
                        String use = this.getSchemaAttribute(att).getUse();
                        if ("optional".equals(use)) {
                            element.removeAttribute(att);
                        } else {
                            element.setAttribute(this._attName, "", this._ns);
                        }
                    } else {
                        element.setAttribute(this._attName, text, this._ns);
                    }
                } else {
                    element.setText(text);
                }
                this._dataElement.getDataModel().getSchemaDocument().changedElement((Object)this, element);
            }
        }
    }
}

