/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.gui.widgets;

import java.util.HashSet;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.gui.widgets.Widget;

public class TextPaneWidget
extends JTextPane
implements Widget {
    private int _maxLength;

    public TextPaneWidget() {
        this.setTabKeyBehaviour();
        this.setUI();
    }

    public void setTextValue(String value) {
        this.setText(value);
        this.setCaretPosition(0);
    }

    public void insertTextValue(String text) {
        try {
            this.getDocument().insertString(this.getCaretPosition(), text, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public String getTextValue() {
        return this.getText();
    }

    public void setMaxLength(int maxLength) {
        this._maxLength = maxLength;
    }

    public boolean isSingleLine() {
        return false;
    }

    public void addDocumentListener(DocumentListener dl) {
        this.getDocument().addDocumentListener(dl);
    }

    public void removeDocumentListener(DocumentListener dl) {
        this.getDocument().removeDocumentListener(dl);
    }

    protected void setUI() {
        this.setFont(DweezilUIManager.plainFont11);
    }

    public void updateUI() {
        super.updateUI();
        this.setUI();
    }

    protected void setTabKeyBehaviour() {
        HashSet<KeyStroke> forwardTraversalKeys = new HashSet<KeyStroke>();
        forwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 0));
        forwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 2));
        this.setFocusTraversalKeys(0, forwardTraversalKeys);
        HashSet<KeyStroke> backwardTraversalKeys = new HashSet<KeyStroke>();
        backwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 1));
        backwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 3));
        this.setFocusTraversalKeys(1, backwardTraversalKeys);
    }
}

