/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.Icon;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.EditorInternalFrame;
import uk.ac.reload.editor.contentpackaging.CP_EditorHandler;
import uk.ac.reload.editor.contentpackaging.xml.CP113_SchemaController;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.editor.LD_Editor;
import uk.ac.reload.editor.learningdesign.editor.LD_NewDialog;
import uk.ac.reload.editor.learningdesign.xml.LDA10_CP113_SchemaController;
import uk.ac.reload.editor.learningdesign.xml.LDB10_CP113_SchemaController;
import uk.ac.reload.editor.learningdesign.xml.LDC10_CP113_SchemaController;
import uk.ac.reload.editor.learningdesign.xml.LearningDesign;
import uk.ac.reload.editor.metadata.xml.MD_SchemaController;
import uk.ac.reload.jdom.XMLUtils;
import uk.ac.reload.moonunit.SchemaController;
import uk.ac.reload.moonunit.schema.SchemaException;

public class LD_EditorHandler
extends CP_EditorHandler {
    public static final String IMS_LEARNING_DESIGN_A_1_0 = "IMS Learning Design A 1.0";
    public static final String IMS_LEARNING_DESIGN_B_1_0 = "IMS Learning Design B 1.0";
    public static final String IMS_LEARNING_DESIGN_C_1_0 = "IMS Learning Design C 1.0";
    public static final String IMS_LEARNING_DESIGN_A_1_0_CP_1_1_3 = "IMS Learning Design A 1.0, IMS Content Packaging 1.1.3";
    public static final String IMS_LEARNING_DESIGN_B_1_0_CP_1_1_3 = "IMS Learning Design B 1.0, IMS Content Packaging 1.1.3";
    public static final String IMS_LEARNING_DESIGN_C_1_0_CP_1_1_3 = "IMS Learning Design C 1.0, IMS Content Packaging 1.1.3";
    static Hashtable SUPPORTED_LD_NAMESPACES = new Hashtable();
    public static final String LD_MAGIC_FOLDER = "reload-magicfolder";
    public static final String AUTHOR_NOTES_FILE = "reload-magicfolder/ld-authornotes.txt";

    public boolean canCreateDocuments() {
        return true;
    }

    public boolean canEditFile(File file) {
        Document doc = null;
        try {
            doc = this.getDocument(file);
        }
        catch (Exception ex) {
            return false;
        }
        Namespace nameSpace = XMLUtils.getDocumentNamespace((Document)doc);
        if (nameSpace == null || nameSpace.equals((Object)Namespace.NO_NAMESPACE)) {
            return false;
        }
        Namespace nsLD = LD_EditorHandler.getLD_Namespace(doc);
        if (nsLD == null) {
            return false;
        }
        if (!SUPPORTED_LD_NAMESPACES.containsKey(nsLD)) {
            return false;
        }
        return SUPPORTED_CP_NAMESPACES.containsKey(nameSpace);
    }

    public EditorInternalFrame editFile(File file) throws JDOMException, SchemaException, IOException {
        if (file.getName().toLowerCase().endsWith(".zip")) {
            File manifest = this.unzipManifest(file);
            if (manifest == null) {
                return null;
            }
            file = manifest;
        }
        LearningDesign ld = new LearningDesign(file);
        LD_DataModel ldDataModel = new LD_DataModel(ld);
        LD_Editor editor = new LD_Editor();
        editor.setDataModel(ldDataModel);
        ld.setDirty(false);
        return editor;
    }

    public EditorInternalFrame newDocument() throws JDOMException, SchemaException, IOException {
        LD_NewDialog dialog = new LD_NewDialog("Choose Folder for Learning Design");
        File ldFolder = dialog.showDialog();
        if (ldFolder == null) {
            return null;
        }
        LDA10_CP113_SchemaController ldController = new LDA10_CP113_SchemaController();
        MD_SchemaController mdController = ldController.getDefaultMD_SchemaController();
        LearningDesign ld = new LearningDesign(ldFolder, ldController, mdController);
        LD_DataModel ldDataModel = new LD_DataModel(ld);
        LD_Editor editor = new LD_Editor();
        editor.setDataModel(ldDataModel);
        ldDataModel.getLearningDesign().saveDocument();
        return editor;
    }

    public String getName() {
        return "IMS Learning Design";
    }

    public Icon getIcon() {
        return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/ld.gif");
    }

    public String getDefaultVersion() {
        return IMS_LEARNING_DESIGN_A_1_0;
    }

    public String getDefaultMDVersion() {
        return "IMS Metadata 1.2.1";
    }

    public String[] getSupportedVersions() {
        return new String[]{IMS_LEARNING_DESIGN_A_1_0_CP_1_1_3, IMS_LEARNING_DESIGN_B_1_0_CP_1_1_3, IMS_LEARNING_DESIGN_C_1_0_CP_1_1_3};
    }

    public String getVersion(Namespace ns, String level) {
        if (ns == null || level == null) {
            return null;
        }
        if (level.equalsIgnoreCase("A")) {
            return "IMS Learning Design A 1.0, " + (String)SUPPORTED_CP_NAMESPACES.get(ns);
        }
        if (level.equalsIgnoreCase("B")) {
            return "IMS Learning Design B 1.0, " + (String)SUPPORTED_CP_NAMESPACES.get(ns);
        }
        return "IMS Learning Design C 1.0, " + (String)SUPPORTED_CP_NAMESPACES.get(ns);
    }

    public SchemaController getSchemaControllerInstance(String version) throws JDOMException, SchemaException, IOException {
        CP113_SchemaController schemaController = null;
        if (IMS_LEARNING_DESIGN_A_1_0_CP_1_1_3.equals(version)) {
            schemaController = new LDA10_CP113_SchemaController();
        } else if (IMS_LEARNING_DESIGN_B_1_0_CP_1_1_3.equals(version)) {
            schemaController = new LDB10_CP113_SchemaController();
        } else if (IMS_LEARNING_DESIGN_C_1_0_CP_1_1_3.equals(version)) {
            schemaController = new LDC10_CP113_SchemaController();
        }
        return schemaController;
    }

    static {
        SUPPORTED_LD_NAMESPACES.put(IMSLD_NAMESPACE_10, IMS_LEARNING_DESIGN_A_1_0);
    }
}

