/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.activities;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import uk.ac.reload.dweezil.gui.GradientPanel;
import uk.ac.reload.dweezil.gui.tree.DweezilTreeNode;
import uk.ac.reload.editor.gui.GroupingPanel;
import uk.ac.reload.editor.learningdesign.datamodel.ILD_DataModelHandler;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Component;
import uk.ac.reload.editor.learningdesign.datamodel.LD_ComponentRef;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.activities.ActivityStructure;
import uk.ac.reload.editor.learningdesign.datamodel.components.activities.LearningActivity;
import uk.ac.reload.editor.learningdesign.datamodel.components.activities.SupportActivity;
import uk.ac.reload.editor.learningdesign.datamodel.components.activities.UnitOfLearningHREF;
import uk.ac.reload.editor.learningdesign.editor.activities.ActivityStructureEditorPanel;
import uk.ac.reload.editor.learningdesign.editor.activities.ActivityTreePanel;
import uk.ac.reload.editor.learningdesign.editor.activities.LearningActivityEditorPanel;
import uk.ac.reload.editor.learningdesign.editor.activities.SupportActivityEditorPanel;
import uk.ac.reload.editor.learningdesign.editor.activities.UnitOfLearningHREFEditorPanel;
import uk.ac.reload.editor.learningdesign.editor.shared.ReferencePanel;
import uk.ac.reload.jdom.XMLPath;

public class ActivitiesPanel
extends GradientPanel
implements TreeSelectionListener,
ILD_DataModelHandler {
    public static XMLPath XMLPATH = new XMLPath("learning-design/components/activities");
    private LD_DataModel _ldDataModel;
    private JSplitPane _splitPane;
    private JPanel _cardPanel;
    private ActivityTreePanel _treePanel;
    private GroupingPanel _groupingPanel;
    private LearningActivityEditorPanel _learningActivityEditorPanel;
    private JScrollPane _learningActivityEditorPanelScrollPane;
    private SupportActivityEditorPanel _supportActivityEditorPanel;
    private JScrollPane _supportActivityEditorPanelScrollPane;
    private ActivityStructureEditorPanel _structureEditorPanel;
    private JScrollPane _structureEditorPanelScrollPane;
    private UnitOfLearningHREFEditorPanel _uolHREFEditorPanel;
    private JScrollPane _uolHREFEditorPanelScrollPane;
    private ReferencePanel _referencePanel;
    private LD_Component _currentSelectedLD_Component;

    public ActivitiesPanel() {
        super((LayoutManager)new BorderLayout());
        JLabel label = new JLabel("Activities");
        label.setFont(label.getFont().deriveFont(1, 16.0f));
        this.add(label, "North");
        this._splitPane = new JSplitPane(1);
        this._splitPane.setOneTouchExpandable(true);
        this.add(this._splitPane, "Center");
        this._splitPane.setLeftComponent((Component)((Object)this.getActivityTreePanel()));
        this._cardPanel = new JPanel(new CardLayout());
        this._splitPane.setRightComponent(this._cardPanel);
        this.getActivityTreePanel().getTree().addTreeSelectionListener(this);
    }

    public void setDataModel(LD_DataModel ldDataModel) {
        this._ldDataModel = ldDataModel;
        this.getActivityTreePanel().setDataModel(ldDataModel);
    }

    public void valueChanged(TreeSelectionEvent e) {
        Object obj;
        if (!e.isAddedPath()) {
            return;
        }
        TreePath selPath = e.getPath();
        Object selectedNode = selPath.getLastPathComponent();
        if (selectedNode instanceof DweezilTreeNode && (obj = ((DweezilTreeNode)selectedNode).getUserObject()) instanceof LD_Component) {
            this.updateEditorPanel((LD_Component)obj);
        }
    }

    protected void updateEditorPanel(DweezilTreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        Object obj = treeNode.getUserObject();
        if (treeNode.getUserObject() instanceof LD_Component) {
            this.updateEditorPanel((LD_Component)obj);
        }
    }

    protected synchronized void updateEditorPanel(LD_Component ldComponent) {
        if (ldComponent == this._currentSelectedLD_Component) {
            return;
        }
        String panelName = null;
        if (ldComponent instanceof LD_ComponentRef) {
            panelName = "#REF_PANEL";
            if (this.getReferencePanel().getParent() != this._cardPanel) {
                this._cardPanel.add((Component)((Object)this.getReferencePanel()), panelName);
            }
            this.getReferencePanel().setComponent(ldComponent);
        } else if (ldComponent instanceof LD_Grouping) {
            panelName = "#GROUPING_PANEL";
            if (this.getGroupingPanel().getParent() != this._cardPanel) {
                this._cardPanel.add((Component)((Object)this.getGroupingPanel()), panelName);
            }
            this.getGroupingPanel().setComponent(ldComponent);
        } else if (ldComponent instanceof LearningActivity) {
            panelName = "#LEARNING_ACTIVITY_PANEL";
            if (this.getLearningActivityEditorScrollPane().getParent() != this._cardPanel) {
                this._cardPanel.add((Component)this.getLearningActivityEditorScrollPane(), panelName);
            }
            this.getLearningActivityEditorPanel().setComponent(ldComponent);
        } else if (ldComponent instanceof SupportActivity) {
            panelName = "#SUPPORT_ACTIVITY_PANEL";
            if (this.getSupportActivityEditorScrollPane().getParent() != this._cardPanel) {
                this._cardPanel.add((Component)this.getSupportActivityEditorScrollPane(), panelName);
            }
            this.getSupportActivityEditorPanel().setComponent(ldComponent);
        } else if (ldComponent instanceof ActivityStructure) {
            panelName = "#ACT_STRUCT_PANEL";
            if (this.getActivityStructureEditorScrollPane().getParent() != this._cardPanel) {
                this._cardPanel.add((Component)this.getActivityStructureEditorScrollPane(), panelName);
            }
            this.getActivityStructureEditorPanel().setComponent(ldComponent);
        } else if (ldComponent instanceof UnitOfLearningHREF) {
            panelName = "#UOL_PANEL";
            if (this.getUnitOfLearningHREFEditorScrollPane().getParent() != this._cardPanel) {
                this._cardPanel.add((Component)this.getUnitOfLearningHREFEditorScrollPane(), panelName);
            }
            this.getUnitOfLearningHREFEditorPanel().setComponent(ldComponent);
        }
        if (panelName != null) {
            ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, panelName);
        }
        this._currentSelectedLD_Component = ldComponent;
    }

    protected void setupView() {
        super.setupView();
        Border border = BorderFactory.createEmptyBorder(5, 10, 5, 10);
        this.setBorder(border);
    }

    public void initView() {
        this._splitPane.setDividerLocation(0.33);
        this.getActivityTreePanel().setSelected(true);
    }

    public void cleanup() {
        if (this._treePanel != null) {
            this._treePanel.cleanup();
        }
        if (this._learningActivityEditorPanel != null) {
            this._learningActivityEditorPanel.cleanup();
        }
        if (this._supportActivityEditorPanel != null) {
            this._supportActivityEditorPanel.cleanup();
        }
        if (this._structureEditorPanel != null) {
            this._structureEditorPanel.cleanup();
        }
        if (this._uolHREFEditorPanel != null) {
            this._uolHREFEditorPanel.cleanup();
        }
        if (this._referencePanel != null) {
            this._referencePanel.cleanup();
        }
        this._ldDataModel = null;
    }

    public boolean doSave() {
        return true;
    }

    public JScrollPane getLearningActivityEditorScrollPane() {
        if (this._learningActivityEditorPanelScrollPane == null) {
            this._learningActivityEditorPanelScrollPane = new JScrollPane((Component)((Object)this.getLearningActivityEditorPanel()));
            this._learningActivityEditorPanelScrollPane.setBorder(null);
        }
        return this._learningActivityEditorPanelScrollPane;
    }

    public LearningActivityEditorPanel getLearningActivityEditorPanel() {
        if (this._learningActivityEditorPanel == null) {
            this._learningActivityEditorPanel = new LearningActivityEditorPanel();
        }
        return this._learningActivityEditorPanel;
    }

    public JScrollPane getSupportActivityEditorScrollPane() {
        if (this._supportActivityEditorPanelScrollPane == null) {
            this._supportActivityEditorPanelScrollPane = new JScrollPane((Component)((Object)this.getSupportActivityEditorPanel()));
            this._supportActivityEditorPanelScrollPane.setBorder(null);
        }
        return this._supportActivityEditorPanelScrollPane;
    }

    public SupportActivityEditorPanel getSupportActivityEditorPanel() {
        if (this._supportActivityEditorPanel == null) {
            this._supportActivityEditorPanel = new SupportActivityEditorPanel();
        }
        return this._supportActivityEditorPanel;
    }

    public JScrollPane getActivityStructureEditorScrollPane() {
        if (this._structureEditorPanelScrollPane == null) {
            this._structureEditorPanelScrollPane = new JScrollPane((Component)((Object)this.getActivityStructureEditorPanel()));
            this._structureEditorPanelScrollPane.setBorder(null);
        }
        return this._structureEditorPanelScrollPane;
    }

    public ActivityStructureEditorPanel getActivityStructureEditorPanel() {
        if (this._structureEditorPanel == null) {
            this._structureEditorPanel = new ActivityStructureEditorPanel();
        }
        return this._structureEditorPanel;
    }

    public JScrollPane getUnitOfLearningHREFEditorScrollPane() {
        if (this._uolHREFEditorPanelScrollPane == null) {
            this._uolHREFEditorPanelScrollPane = new JScrollPane((Component)((Object)this.getUnitOfLearningHREFEditorPanel()));
            this._uolHREFEditorPanelScrollPane.setBorder(null);
        }
        return this._uolHREFEditorPanelScrollPane;
    }

    public UnitOfLearningHREFEditorPanel getUnitOfLearningHREFEditorPanel() {
        if (this._uolHREFEditorPanel == null) {
            this._uolHREFEditorPanel = new UnitOfLearningHREFEditorPanel();
        }
        return this._uolHREFEditorPanel;
    }

    public GroupingPanel getGroupingPanel() {
        if (this._groupingPanel == null) {
            this._groupingPanel = new GroupingPanel();
        }
        return this._groupingPanel;
    }

    public ReferencePanel getReferencePanel() {
        if (this._referencePanel == null) {
            this._referencePanel = new ReferencePanel();
        }
        return this._referencePanel;
    }

    public ActivityTreePanel getActivityTreePanel() {
        if (this._treePanel == null) {
            this._treePanel = new ActivityTreePanel();
        }
        return this._treePanel;
    }
}

