/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.activities;

import javax.swing.Icon;
import javax.swing.JOptionPane;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Component;
import uk.ac.reload.editor.learningdesign.datamodel.components.activities.Activity;
import uk.ac.reload.editor.learningdesign.editor.shared.ComponentListPanel;

public abstract class ActivityListPanel
extends ComponentListPanel {
    protected Activity _activity;

    protected ActivityListPanel(String title, Icon icon, int listHeight) {
        super(title, icon, listHeight);
    }

    public void setActivity(Activity activity) {
        this._activity = activity;
        if (this.getDataModel() == null) {
            this.setDataModel(activity.getDataModel());
        }
        this.updateListModel();
        this.updateMenus();
    }

    protected void deleteListItems() {
        Object[] components = this.getList().getSelectedValues();
        if (components.length == 0) {
            return;
        }
        int result = JOptionPane.showConfirmDialog(this.getParent(), "Are you sure you want to delete the reference(s)?", "Confirm Delete", 0);
        if (result != 0) {
            return;
        }
        int pos = this.getList().getSelectedIndex() - 1;
        for (int i = 0; i < components.length; ++i) {
            this._activity.removeRef((LD_Component)components[i]);
        }
        if (pos == -1 && this.getList().getModel().getSize() > 0) {
            pos = 0;
        }
        this.getList().setSelectedIndex(pos);
    }

    protected void moveListItemUp() {
        Object component = this.getList().getSelectedValue();
        if (component != null) {
            this._activity.moveRefUp((LD_Component)component);
            this.getList().setSelectedValue(component, true);
        }
    }

    protected void moveListItemDown() {
        Object component = this.getList().getSelectedValue();
        if (component != null) {
            this._activity.moveRefDown((LD_Component)component);
            this.getList().setSelectedValue(component, true);
        }
    }

    public void componentAdded(DataComponent component) {
    }

    public void componentRemoved(DataComponent component) {
    }

    public void componentMoved(DataComponent component) {
    }

    public void componentChanged(DataComponent component) {
        if (component == this._activity) {
            this.updateListModel();
        }
    }
}

