/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.method;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.DataElement;
import uk.ac.reload.editor.learningdesign.datamodel.method.Act;
import uk.ac.reload.editor.learningdesign.editor.method.ActRolePartListPanel;
import uk.ac.reload.editor.learningdesign.editor.shared.CompletionPanel;

public class ActCompletionPanel
extends CompletionPanel {
    static final String TITLE = "Act Completion";
    static final String DESCRIPTION = "Information relating to the completion of this Act.";
    private static String[] radioText = new String[]{"None", "Time Limit", "When Role Parts Completed", "When a condition is true", "When a property is set"};
    private ActRolePartListPanel _listPanel;

    protected ActCompletionPanel(boolean isVisible) {
        super(isVisible);
        this.getHiderLabelPanel().getTitleLabel().setText("<html>Act Completion");
        this.getHiderLabelPanel().getDescriptionLabel().setText("<html>Information relating to the completion of this Act.");
    }

    public void setComponent(DataComponent dataComponent) {
        super.setComponent(dataComponent);
        Act act = (Act)dataComponent;
        this.getCompletionFeedbackPanel().setItemModelType(act.getFeedbackDescriptionItemModelType());
        DataElement whenRolePartCompleted = act.getWhenRolePartCompletedDataElement();
        DataElement timeLimit = act.getTimeLimitDataElement();
        DataElement conditionTrue = act.getWhenConditionTrueDataElement();
        DataElement propertyValue = act.getWhenPropertyValueSetDataElement();
        if (timeLimit.getElement() != null) {
            this.selectRadioButton(1);
            this.getTimeLimitField().setElement(timeLimit);
            this.getRolePartListPanel().clear();
        } else if (whenRolePartCompleted.getElement() != null) {
            this.selectRadioButton(2);
            this.getTimeLimitField().clear();
            this.getRolePartListPanel().setAct(act);
        } else if (conditionTrue.getElement() != null) {
            this.selectRadioButton(3);
            this.getTimeLimitField().clear();
            this.getRolePartListPanel().clear();
        } else if (propertyValue.getElement() != null) {
            this.selectRadioButton(4);
            this.getTimeLimitField().clear();
            this.getRolePartListPanel().clear();
        } else {
            this.selectRadioButton(0);
            this.getTimeLimitField().clear();
            this.getRolePartListPanel().clear();
        }
    }

    protected void radioButtonPressed(int button) {
        Act act = (Act)this.getComponent();
        DataElement completeAct = act.getCompleteActDataElement();
        completeAct.deleteElement();
        switch (button) {
            case 0: {
                this.getTimeLimitField().clear();
                this.getRolePartListPanel().clear();
                break;
            }
            case 1: {
                DataElement timeLimit = act.getTimeLimitDataElement();
                this.getTimeLimitField().setElement(timeLimit);
                this.getRolePartListPanel().clear();
                break;
            }
            case 2: {
                this.getTimeLimitField().clear();
                this.getRolePartListPanel().setAct(act);
                break;
            }
            case 3: {
                DataElement conditionTrue = act.getWhenConditionTrueDataElement();
                this.getTimeLimitField().clear();
                this.getRolePartListPanel().clear();
                break;
            }
            case 4: {
                DataElement propertyValue = act.getWhenPropertyValueSetDataElement();
                this.getTimeLimitField().clear();
                this.getRolePartListPanel().clear();
            }
        }
    }

    protected void setupView(boolean isHidden) {
        super.setupView(isHidden);
        this.getRadioButtons()[3].setEnabled(false);
        JButton button1 = new JButton("Define");
        button1.setEnabled(false);
        this.getRadioButtons()[4].setEnabled(false);
        JButton button2 = new JButton("Define");
        button2.setEnabled(false);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.setBackground(new Color(250, 250, 254));
        buttonPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.gray), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.getCenterPanel().add((Component)buttonPanel, "Center");
        GridBagConstraints gc = new GridBagConstraints();
        gc.weightx = 1.0;
        gc.anchor = 17;
        gc.fill = 2;
        buttonPanel.add((Component)this.getRadioButtons()[0], gc);
        gc.gridy = 1;
        buttonPanel.add((Component)this.getRadioButtons()[1], gc);
        gc.gridx = 1;
        gc.weightx = 2.0;
        buttonPanel.add((Component)this.getTimeLimitField(), gc);
        gc.gridx = 0;
        gc.gridy = 2;
        gc.weightx = 1.0;
        gc.anchor = 18;
        buttonPanel.add((Component)this.getRadioButtons()[2], gc);
        gc.gridx = 1;
        gc.insets.top = 5;
        gc.anchor = 17;
        buttonPanel.add((Component)((Object)this.getRolePartListPanel()), gc);
        gc.gridx = 0;
        gc.gridy = 3;
        buttonPanel.add((Component)this.getRadioButtons()[3], gc);
        gc.gridx = 1;
        gc.fill = 0;
        buttonPanel.add((Component)button1, gc);
        gc.gridx = 0;
        gc.gridy = 4;
        buttonPanel.add((Component)this.getRadioButtons()[4], gc);
        gc.gridx = 1;
        buttonPanel.add((Component)button2, gc);
    }

    protected ActRolePartListPanel getRolePartListPanel() {
        if (this._listPanel == null) {
            this._listPanel = new ActRolePartListPanel();
        }
        return this._listPanel;
    }

    protected int getNumberRadioButtons() {
        return radioText.length;
    }

    protected String getRadioButtonText(int button) {
        return radioText[button];
    }

    public void cleanup() {
        if (this._listPanel != null) {
            this._listPanel.cleanup();
        }
        super.cleanup();
    }
}

