/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.method;

import javax.swing.JOptionPane;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Component;
import uk.ac.reload.editor.learningdesign.datamodel.method.Method;
import uk.ac.reload.editor.learningdesign.datamodel.method.Play;
import uk.ac.reload.editor.learningdesign.editor.method.MethodPlaySelectorDialog;
import uk.ac.reload.editor.learningdesign.editor.shared.ComponentListPanel;

public class MethodPlayListPanel
extends ComponentListPanel {
    private Method _method;
    private MethodPlaySelectorDialog _dialog;

    public MethodPlayListPanel() {
        super("Plays", DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/play.gif"), 100);
    }

    public void setMethod(Method method) {
        this.setEnabled(true);
        this._method = method;
        if (this.getDataModel() == null) {
            this.setDataModel(method.getDataModel());
        }
        this.updateListModel();
        this.updateMenus();
    }

    public void clear() {
        this._method = null;
        this.updateListModel();
        this.setEnabled(false);
    }

    protected void deleteListItems() {
        Object[] components = this.getList().getSelectedValues();
        if (components.length == 0) {
            return;
        }
        int result = JOptionPane.showConfirmDialog(this.getParent(), "Are you sure you want to delete the reference(s)?", "Confirm Delete", 0);
        if (result != 0) {
            return;
        }
        int pos = this.getList().getSelectedIndex() - 1;
        for (int i = 0; i < components.length; ++i) {
            this._method.removePlayCompleted((Play)components[i]);
        }
        if (pos == -1 && this.getList().getModel().getSize() > 0) {
            pos = 0;
        }
        this.getList().setSelectedIndex(pos);
    }

    protected void moveListItemUp() {
        Object component = this.getList().getSelectedValue();
        if (component != null) {
            this._method.movePlayCompletedUp((Play)component);
            this.getList().setSelectedValue(component, true);
        }
    }

    protected void moveListItemDown() {
        Object component = this.getList().getSelectedValue();
        if (component != null) {
            this._method.movePlayCompletedDown((Play)component);
            this.getList().setSelectedValue(component, true);
        }
    }

    protected void updateListModel() {
        if (this._method != null) {
            LD_Component[] components = this._method.getPlaysCompleted();
            this.getList().setModel(new ComponentListPanel.ComponentListModel(this, components));
        } else {
            this.getList().setListData(new String[]{""});
        }
    }

    protected void showSelectorDialog() {
        if (this._dialog == null) {
            this._dialog = new MethodPlaySelectorDialog();
        }
        this._dialog.setMethod(this._method);
        this._dialog.show();
    }

    public void cleanup() {
        super.cleanup();
        if (this._dialog != null) {
            this._dialog.cleanup();
        }
    }

    public void componentAdded(DataComponent component) {
    }

    public void componentRemoved(DataComponent component) {
    }

    public void componentMoved(DataComponent component) {
    }

    public void componentChanged(DataComponent component) {
        if (component == this._method) {
            this.updateListModel();
        }
    }
}

