/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.resources;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdom.Namespace;
import uk.ac.reload.dweezil.gui.GradientPanel;
import uk.ac.reload.dweezil.gui.LabelComponentPanel;
import uk.ac.reload.dweezil.gui.layout.SGLayout;
import uk.ac.reload.editor.IIcons;
import uk.ac.reload.editor.datamodel.DataElement;
import uk.ac.reload.editor.gui.IdentifierLabelTextField;
import uk.ac.reload.editor.gui.widgets.DataElementTextField;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Component;
import uk.ac.reload.editor.learningdesign.datamodel.resources.LD_Dependency;
import uk.ac.reload.editor.learningdesign.datamodel.resources.LD_File;
import uk.ac.reload.editor.learningdesign.datamodel.resources.LD_Resource;
import uk.ac.reload.editor.learningdesign.datamodel.resources.LD_Resources;
import uk.ac.reload.editor.learningdesign.editor.shared.LD_ResourceSelector;
import uk.ac.reload.editor.learningdesign.editor.shared.MetadataPanel;

public class LD_ResourceEditor
extends JPanel
implements IIcons {
    static final String DESCRIPTION = "Add Resources that you wish to include and reference in the Learning Design. You can add Resources directly for on-line web pages, or drag and drop files from the File Viewer.";
    static final boolean SHOW_IDENTIFIER = false;
    private ResourcesPanel _resourcesPanel;
    private ResourcePanel _resourcePanel;
    private FilePanel _filePanel;
    private DependencyPanel _dependencyPanel;

    public LD_ResourceEditor() {
        this.setLayout(new CardLayout());
        this.setBorder(BorderFactory.createLineBorder(Color.lightGray));
    }

    public void setComponent(LD_Component ldComponent) {
        if (ldComponent instanceof LD_Resources) {
            this.getResourcesPanel().setComponent(ldComponent);
            ((CardLayout)this.getLayout()).show(this, "#RESOURCES");
        } else if (ldComponent instanceof LD_Resource) {
            this.getResourcePanel().setComponent(ldComponent);
            ((CardLayout)this.getLayout()).show(this, "#RESOURCE");
        } else if (ldComponent instanceof LD_File) {
            this.getFilePanel().setComponent(ldComponent);
            ((CardLayout)this.getLayout()).show(this, "#FILE");
        } else if (ldComponent instanceof LD_Dependency) {
            this.getDependencyPanel().setComponent(ldComponent);
            ((CardLayout)this.getLayout()).show(this, "#DEPENDENCY");
        }
    }

    public void cleanup() {
    }

    private ResourcesPanel getResourcesPanel() {
        if (this._resourcesPanel == null) {
            this._resourcesPanel = new ResourcesPanel();
            this.add((Component)((Object)this._resourcesPanel), "#RESOURCES");
        }
        return this._resourcesPanel;
    }

    private ResourcePanel getResourcePanel() {
        if (this._resourcePanel == null) {
            this._resourcePanel = new ResourcePanel();
            this.add((Component)((Object)this._resourcePanel), "#RESOURCE");
        }
        return this._resourcePanel;
    }

    private FilePanel getFilePanel() {
        if (this._filePanel == null) {
            this._filePanel = new FilePanel();
            this.add((Component)((Object)this._filePanel), "#FILE");
        }
        return this._filePanel;
    }

    private DependencyPanel getDependencyPanel() {
        if (this._dependencyPanel == null) {
            this._dependencyPanel = new DependencyPanel();
            this.add((Component)((Object)this._dependencyPanel), "#DEPENDENCY");
        }
        return this._dependencyPanel;
    }

    class DependencyPanel
    extends GradientPanel {
        private LD_ResourceSelector _selector;

        DependencyPanel() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this._selector = new LD_ResourceSelector();
            LabelComponentPanel panelIDREF = new LabelComponentPanel("Dependency:", (JComponent)this._selector, 0.3, 0.0);
            this.add((Component)panelIDREF, "North");
        }

        public void setComponent(LD_Component ldComponent) {
            DataElement dependencyElement = ldComponent.getDataElement();
            this._selector.setElement(dependencyElement);
        }
    }

    class FilePanel
    extends GradientPanel {
        private DataElementTextField _tfHREF;
        private MetadataPanel _metadataPanel;

        FilePanel() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this._tfHREF = new DataElementTextField();
            LabelComponentPanel panelHREF = new LabelComponentPanel("Location:", (JComponent)this._tfHREF, 0.3, 0.0);
            this.add((Component)panelHREF, "North");
            this._metadataPanel = new MetadataPanel();
            this._metadataPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            this.add(this._metadataPanel, "South");
        }

        public void setComponent(LD_Component ldComponent) {
            DataElement fileElement = ldComponent.getDataElement();
            this._tfHREF.setAttribute(fileElement, "href", null);
            this._metadataPanel.setMetadataType(((LD_File)ldComponent).getMetadataType());
        }
    }

    class ResourcePanel
    extends GradientPanel {
        private IdentifierLabelTextField _tfIdentifier;
        private DataElementTextField _tfType;
        private DataElementTextField _tfBase;
        private DataElementTextField _tfHREF;
        private MetadataPanel _metadataPanel;

        ResourcePanel() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            SGLayout fieldPanelLayout = new SGLayout(3, 1, 0, 5);
            JPanel fieldPanel = new JPanel((LayoutManager)fieldPanelLayout);
            fieldPanel.setOpaque(false);
            this.add(fieldPanel, "North");
            this._tfHREF = new DataElementTextField();
            LabelComponentPanel panelHREF = new LabelComponentPanel("Location:", (JComponent)this._tfHREF, 0.3, 0.0);
            fieldPanel.add((Component)panelHREF);
            this._tfType = new DataElementTextField();
            LabelComponentPanel panelType = new LabelComponentPanel("Type:", (JComponent)this._tfType, 0.3, 0.0);
            fieldPanel.add((Component)panelType);
            this._tfBase = new DataElementTextField();
            LabelComponentPanel panelBase = new LabelComponentPanel("Base path:", (JComponent)this._tfBase, 0.3, 0.0);
            fieldPanel.add((Component)panelBase);
            this._metadataPanel = new MetadataPanel();
            this._metadataPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            this.add(this._metadataPanel, "South");
        }

        public void setComponent(LD_Component ldComponent) {
            DataElement resourceElement = ldComponent.getDataElement();
            this._tfType.setAttribute(resourceElement, "type", null);
            this._tfBase.setAttribute(resourceElement, "base", Namespace.XML_NAMESPACE);
            this._tfHREF.setAttribute(resourceElement, "href", null);
            this._metadataPanel.setMetadataType(((LD_Resource)ldComponent).getMetadataType());
        }
    }

    class ResourcesPanel
    extends GradientPanel {
        private DataElementTextField _tfBase;

        ResourcesPanel() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JLabel label = new JLabel("<html>Add Resources that you wish to include and reference in the Learning Design. You can add Resources directly for on-line web pages, or drag and drop files from the File Viewer.");
            this.add(label, "North");
            this._tfBase = new DataElementTextField();
            LabelComponentPanel panelBase = new LabelComponentPanel("Base path:", (JComponent)this._tfBase, 0.3, 0.0);
            this.add((Component)panelBase, "South");
        }

        public void setComponent(LD_Component ldComponent) {
            DataElement resourcesElement = ldComponent.getDataElement();
            this._tfBase.setAttribute(resourcesElement, "base", Namespace.XML_NAMESPACE);
        }
    }
}

