/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.resources;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uk.ac.reload.dweezil.gui.GradientPanel;
import uk.ac.reload.dweezil.gui.UIFactory;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.IIcons;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.editor.resources.LD_ResourceEditor;
import uk.ac.reload.editor.learningdesign.editor.resources.LD_ResourcesTreePanel;

public class LD_ResourcesEditorPanel
extends GradientPanel
implements IIcons {
    private LD_DataModel _ldDataModel;
    private LD_ResourcesTreePanel _resourcesTreePanel;
    private LD_ResourceEditor _resourceEditorPanel;

    protected void setupView() {
        super.setupView();
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setOpaque(false);
        this.add(topPanel, "North");
        JLabel labelTitle = new JLabel("<html>Resources to include in the Learning Design");
        labelTitle.setIcon(DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/resources.gif"));
        labelTitle.setFont(labelTitle.getFont().deriveFont(1, 16.0f));
        topPanel.add((Component)labelTitle, "North");
        topPanel.add((Component)UIFactory.createGradientUnderLineBar(), "Center");
        topPanel.add(Box.createVerticalStrut(10), "South");
        this.add((Component)((Object)this.getResourcesTreePanel()), "Center");
        this.add(this.getResourceEditor(), "South");
    }

    public void setDataModel(LD_DataModel ldDataModel) {
        this._ldDataModel = ldDataModel;
        this.getResourcesTreePanel().setDataModel(ldDataModel);
    }

    public LD_ResourcesTreePanel getResourcesTreePanel() {
        if (this._resourcesTreePanel == null) {
            this._resourcesTreePanel = new LD_ResourcesTreePanel();
        }
        return this._resourcesTreePanel;
    }

    public LD_ResourceEditor getResourceEditor() {
        if (this._resourceEditorPanel == null) {
            this._resourceEditorPanel = new LD_ResourceEditor();
        }
        return this._resourceEditorPanel;
    }

    public void cleanup() {
        if (this._resourcesTreePanel != null) {
            this._resourcesTreePanel.cleanup();
        }
        if (this._resourceEditorPanel != null) {
            this._resourceEditorPanel.cleanup();
        }
        this._ldDataModel = null;
    }
}

