/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.shared;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import uk.ac.reload.dweezil.gui.ComponentHiderLabelPanel;
import uk.ac.reload.dweezil.gui.LabelComponentPanel;
import uk.ac.reload.editor.gui.widgets.DataElementTextField;
import uk.ac.reload.editor.learningdesign.datamodel.ItemModelType;
import uk.ac.reload.editor.learningdesign.editor.shared.ItemTypePanel;
import uk.ac.reload.editor.learningdesign.editor.shared.MetadataPanel;

public class ItemModelTypePanel
extends JPanel {
    private ItemModelType _itemModelType;
    private ComponentHiderLabelPanel _hiderPanel;
    private DataElementTextField _tfTitle;
    private ItemTypePanel _itemTypePanel;
    private MetadataPanel _metadataPanel;

    public ItemModelTypePanel(boolean isVisible) {
        this.setupView(isVisible);
    }

    protected void setupView(boolean isVisible) {
        this.setOpaque(false);
        this.setLayout(new BorderLayout(10, 10));
        JPanel subPanel = new JPanel(new BorderLayout(10, 10));
        subPanel.setBackground(new Color(240, 240, 254));
        subPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.gray), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.add((Component)subPanel, "Center");
        this._hiderPanel = new ComponentHiderLabelPanel("", "");
        this._hiderPanel.getComponentHiderButton().setComponent((JComponent)subPanel);
        this._hiderPanel.getComponentHiderButton().showComponent(isVisible);
        this.add((Component)this._hiderPanel, "North");
        this._tfTitle = new DataElementTextField();
        LabelComponentPanel panelTitle = new LabelComponentPanel("Title:", (JComponent)this._tfTitle, 0.3, 0.0);
        subPanel.add((Component)panelTitle, "North");
        this._itemTypePanel = new ItemTypePanel();
        subPanel.add((Component)this._itemTypePanel, "Center");
        this._metadataPanel = new MetadataPanel();
        subPanel.add((Component)this._metadataPanel, "South");
    }

    public void setItemModelType(ItemModelType itemModelType) {
        String description;
        this._itemModelType = itemModelType;
        String title = itemModelType.getTitle();
        if (title != null) {
            this._hiderPanel.getTitleLabel().setText("<html>" + title);
        }
        if ((description = itemModelType.getDescription()) != null) {
            this._hiderPanel.getDescriptionLabel().setText("<html>" + description);
        }
        this._tfTitle.setElement(itemModelType.getTitleElement());
        this._itemTypePanel.setItemType(itemModelType.getItemType());
        this._metadataPanel.setMetadataType(itemModelType.getMetadataType());
    }

    public void cleanup() {
        if (this._itemTypePanel != null) {
            this._itemTypePanel.cleanup();
        }
        if (this._metadataPanel != null) {
            this._metadataPanel.cleanup();
        }
    }
}

