/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.shared;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import uk.ac.reload.dweezil.gui.LabelComponentPanel;
import uk.ac.reload.dweezil.gui.layout.SGLayout;
import uk.ac.reload.editor.datamodel.DataElement;
import uk.ac.reload.editor.learningdesign.datamodel.ItemType;
import uk.ac.reload.editor.learningdesign.editor.shared.IsVisibleParametersPanel;
import uk.ac.reload.editor.learningdesign.editor.shared.LD_ResourceSelector;
import uk.ac.reload.editor.learningdesign.editor.shared.MetadataPanel;
import uk.ac.reload.editor.learningdesign.xml.LearningDesign;

public class ItemTypePanel
extends JPanel {
    static boolean SHOW_ADVANCED = true;
    private LearningDesign _learningDesign;
    private ItemType _itemType;
    private LD_ResourceSelector _resourceSelector;
    private IsVisibleParametersPanel _isVisibleParametersPanel;
    private MetadataPanel _metadataPanel;

    public ItemTypePanel() {
        this.setLayout(new BorderLayout());
        this.setBackground(new Color(250, 250, 254));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.gray), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        SGLayout fieldPanelLayout = new SGLayout(SHOW_ADVANCED ? 2 : 1, 1, 0, 5);
        JPanel fieldPanel = new JPanel((LayoutManager)fieldPanelLayout);
        fieldPanel.setOpaque(false);
        this.add((Component)fieldPanel, "Center");
        this._resourceSelector = new LD_ResourceSelector();
        LabelComponentPanel panelItem = new LabelComponentPanel("Resource:", (JComponent)this._resourceSelector, 0.3, 0.0);
        fieldPanel.add((Component)panelItem);
        if (SHOW_ADVANCED) {
            this._isVisibleParametersPanel = new IsVisibleParametersPanel();
            fieldPanel.add(this._isVisibleParametersPanel);
        }
        this._metadataPanel = new MetadataPanel();
        this._metadataPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.add((Component)this._metadataPanel, "South");
    }

    public void setItemType(ItemType itemType) {
        this._itemType = itemType;
        DataElement itemElement = itemType.getItemElement();
        this._resourceSelector.setElement(itemElement);
        if (SHOW_ADVANCED) {
            this._isVisibleParametersPanel.getIsVisibleCheckBox().setAttribute(itemElement, "isvisible", true);
            this._isVisibleParametersPanel.getParametersField().setAttribute(itemElement, "parameters", null);
        }
        this._metadataPanel.setMetadataType(itemType.getMetadataType());
    }

    public void cleanup() {
        if (this._resourceSelector != null) {
            this._resourceSelector.cleanup();
        }
        if (this._metadataPanel != null) {
            this._metadataPanel.cleanup();
        }
        this._learningDesign = null;
        this._itemType = null;
    }
}

