/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.metadata.editor2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import uk.ac.reload.dweezil.gui.DweezilComboBox;
import uk.ac.reload.dweezil.gui.ErrorDialogBox;
import uk.ac.reload.dweezil.menu.MenuAction;
import uk.ac.reload.dweezil.menu.UndoMenuManager;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.menu.Menu_Edit;
import uk.ac.reload.editor.metadata.datamodel.IMD_DataModelHandler;
import uk.ac.reload.editor.metadata.datamodel.MD_DataModel;
import uk.ac.reload.editor.metadata.editor.tableview.MD_TablePanel;
import uk.ac.reload.editor.metadata.editor2.AnnotationPanel;
import uk.ac.reload.editor.metadata.editor2.ClassificationPanel;
import uk.ac.reload.editor.metadata.editor2.EducationalPanel;
import uk.ac.reload.editor.metadata.editor2.GeneralPanel;
import uk.ac.reload.editor.metadata.editor2.LifeCyclePanel;
import uk.ac.reload.editor.metadata.editor2.MetaMetadataPanel;
import uk.ac.reload.editor.metadata.editor2.RelationPanel;
import uk.ac.reload.editor.metadata.editor2.RightsPanel;
import uk.ac.reload.editor.metadata.editor2.TechnicalPanel;
import uk.ac.reload.editor.metadata.xml.Metadata;
import uk.ac.reload.editor.properties.EditorProperties;
import uk.ac.reload.moonunit.ProfiledSchemaController;

public class MD_EditorPanel
extends JPanel {
    private MD_DataModel _mdDataModel;
    private MetadataPrefsPanel _prefsPanel;
    private JTabbedPane _tabPane;
    private IMD_DataModelHandler[] _panels;
    private GeneralPanel _generalPanel;
    private LifeCyclePanel _lifecyclePanel;
    private MetaMetadataPanel _metametadataPanel;
    private TechnicalPanel _technicalPanel;
    private EducationalPanel _educationalPanel;
    private RightsPanel _rightsPanel;
    private RelationPanel _relationPanel;
    private AnnotationPanel _annotationPanel;
    private ClassificationPanel _classificationPanel;
    private MD_TablePanel _tablePanel;
    private Menu_Edit _editMenu;
    private UndoMenuManager _undoMenuManager;

    public MD_EditorPanel(Menu_Edit editMenu) {
        this._editMenu = editMenu;
        this.setLayout(new BorderLayout());
        this._prefsPanel = new MetadataPrefsPanel();
        this.add((Component)this._prefsPanel, "North");
        this._tabPane = new JTabbedPane(3);
        this.add((Component)this._tabPane, "Center");
        IMD_DataModelHandler[] iMD_DataModelHandlerArray = new IMD_DataModelHandler[9];
        this._generalPanel = new GeneralPanel();
        iMD_DataModelHandlerArray[0] = this._generalPanel;
        this._lifecyclePanel = new LifeCyclePanel();
        iMD_DataModelHandlerArray[1] = this._lifecyclePanel;
        this._metametadataPanel = new MetaMetadataPanel();
        iMD_DataModelHandlerArray[2] = this._metametadataPanel;
        this._technicalPanel = new TechnicalPanel();
        iMD_DataModelHandlerArray[3] = this._technicalPanel;
        this._educationalPanel = new EducationalPanel();
        iMD_DataModelHandlerArray[4] = this._educationalPanel;
        this._rightsPanel = new RightsPanel();
        iMD_DataModelHandlerArray[5] = this._rightsPanel;
        this._relationPanel = new RelationPanel();
        iMD_DataModelHandlerArray[6] = this._relationPanel;
        this._annotationPanel = new AnnotationPanel();
        iMD_DataModelHandlerArray[7] = this._annotationPanel;
        this._classificationPanel = new ClassificationPanel();
        iMD_DataModelHandlerArray[8] = this._classificationPanel;
        this._panels = iMD_DataModelHandlerArray;
        this._tablePanel = new MD_TablePanel(editMenu);
        this._tabPane.addTab("General", (Component)((Object)this._generalPanel));
        this._tabPane.addTab("Life Cycle", (Component)((Object)this._lifecyclePanel));
        this._tabPane.addTab("Metametadata", (Component)((Object)this._metametadataPanel));
        this._tabPane.addTab("Technical", (Component)((Object)this._technicalPanel));
        this._tabPane.addTab("Educational", (Component)((Object)this._educationalPanel));
        this._tabPane.addTab("Rights", (Component)((Object)this._rightsPanel));
        this._tabPane.addTab("Relation", (Component)((Object)this._relationPanel));
        this._tabPane.addTab("Annotation", (Component)((Object)this._annotationPanel));
        this._tabPane.addTab("Classification", (Component)((Object)this._classificationPanel));
        this._tabPane.addTab("Tree View", this._tablePanel);
    }

    public MD_DataModel getDataModel() {
        return this._mdDataModel;
    }

    public void setDataModel(MD_DataModel mdDataModel) {
        this._mdDataModel = mdDataModel;
        Metadata md = this._mdDataModel.getMetadata();
        for (int i = 0; i < this._panels.length; ++i) {
            this._panels[i].setDataModel(mdDataModel);
        }
        this._prefsPanel.setDocument(md);
        this._tablePanel.setDocument(md);
        if (this._undoMenuManager != null) {
            this._undoMenuManager.cleanup();
        }
        this._undoMenuManager = new UndoMenuManager((MenuAction)this._editMenu.actionUndo, (MenuAction)this._editMenu.actionRedo);
        md.setUndoHandler(this._undoMenuManager.getUndoHandler());
    }

    public void initView() {
        this._tablePanel.initView();
    }

    public UndoMenuManager getUndoManager() {
        return this._undoMenuManager;
    }

    public MetadataPrefsPanel getPrefsPanel() {
        return this._prefsPanel;
    }

    public void cleanup() {
        try {
            if (this._undoMenuManager != null) {
                this._undoMenuManager.cleanup();
            }
            for (int i = 0; i < this._panels.length; ++i) {
                this._panels[i].cleanup();
            }
            if (this._tablePanel != null) {
                this._tablePanel.cleanup();
            }
            if (this._mdDataModel.getMetadata() != null) {
                this._mdDataModel.getMetadata().destroy();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public MD_TablePanel getMD_TablePanel() {
        return this._tablePanel;
    }

    static /* synthetic */ MD_TablePanel access$300(MD_EditorPanel x0) {
        return x0._tablePanel;
    }

    class MetadataPrefsPanel
    extends JPanel {
        DweezilComboBox profileCombobox;
        ComboBoxListener listener;

        MetadataPrefsPanel() {
            this.setLayout(new FlowLayout(0));
            this.add(new JLabel(Messages.getString("uk.ac.reload.editor.metadata.MD_EditorPanel.2") + ": "));
            this.profileCombobox = new DweezilComboBox(false);
            this.add((Component)this.profileCombobox);
            this.listener = new ComboBoxListener();
        }

        public void setDocument(Metadata metadata) {
            this.profileCombobox.removeActionListener((ActionListener)this.listener);
            Object[] profiles = ((ProfiledSchemaController)metadata.getSchemaController()).getHelperProfileNames();
            this.profileCombobox.setItems(profiles);
            String profile = ((ProfiledSchemaController)metadata.getSchemaController()).getHelperProfile().getProfileName();
            this.profileCombobox.setSelectedItem((Object)profile);
            this.profileCombobox.addActionListener((ActionListener)this.listener);
        }

        class ComboBoxListener
        extends AbstractAction {
            ComboBoxListener() {
            }

            public void actionPerformed(ActionEvent e) {
                String profileName = (String)MetadataPrefsPanel.this.profileCombobox.getSelectedItem();
                try {
                    ((ProfiledSchemaController)MD_EditorPanel.this._mdDataModel.getMetadata().getSchemaController()).loadHelperProfile(profileName);
                }
                catch (Exception ex) {
                    if (EditorProperties.getString("DEBUG").equals("true")) {
                        ex.printStackTrace();
                    }
                    ErrorDialogBox.showWarning((String)Messages.getString("uk.ac.reload.editor.metadata.MD_EditorPanel.2"), (String)(Messages.getString("uk.ac.reload.editor.metadata.MD_EditorPanel.3") + ": " + profileName), (Exception)ex);
                }
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ ComboBoxListener this$2;
                    {
                        this.this$2 = this$2;
                    }

                    public void run() {
                        MD_EditorPanel.access$300(MetadataPrefsPanel.access$000(ComboBoxListener.access$200(this.this$2))).refresh();
                    }
                });
            }

            static /* synthetic */ MetadataPrefsPanel access$200(ComboBoxListener x0) {
                return x0.MetadataPrefsPanel.this;
            }
        }
    }
}

