/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.chat.JabberHTTPBind;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.chat.JabberHTTPBind.Janitor;
import org.lamsfoundation.lams.tool.chat.JabberHTTPBind.Response;
import org.lamsfoundation.lams.tool.chat.JabberHTTPBind.Session;
import org.lamsfoundation.lams.tool.chat.service.ChatServiceProxy;
import org.lamsfoundation.lams.tool.chat.service.IChatService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class JHBServlet
extends HttpServlet {
    static Logger log = Logger.getLogger((String)JHBServlet.class.getName());
    static IChatService chatService;
    public static final String APP_VERSION = "0.3";
    public static final String APP_NAME = "Jabber HTTP Binding Servlet";
    public static final boolean DEBUG = true;
    public static final int DEBUG_LEVEL = 2;
    private DocumentBuilder db;
    private Janitor janitor;

    public void init() throws ServletException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            this.db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            this.log("failed to create DocumentBuilderFactory", e);
        }
        this.janitor = new Janitor();
        new Thread(this.janitor).start();
        if (chatService == null) {
            chatService = ChatServiceProxy.getChatService(this.getServletContext());
        }
    }

    public void destroy() {
        Session.stopSessions();
        this.janitor.stop();
    }

    public static String hex(byte[] array) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).toLowerCase().substring(1, 3));
        }
        return sb.toString();
    }

    public static String sha1(String message) {
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            return JHBServlet.hex(sha.digest(message.getBytes()));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public static void dbg(String msg) {
        JHBServlet.dbg(msg, 0);
    }

    public static void dbg(String msg, int lvl) {
        if (lvl > 2) {
            return;
        }
        log.debug((Object)("[" + lvl + "] " + msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block61: {
            log.debug((Object)"starting doPost");
            int rid = 0;
            try {
                Document doc;
                String contents = "";
                String line = "";
                BufferedReader bfr = request.getReader();
                while ((line = bfr.readLine()) != null) {
                    contents = contents + line + "\n";
                }
                contents.trim();
                String cEnc = request.getCharacterEncoding();
                if (cEnc == null) {
                    cEnc = "UTF-8";
                }
                ByteArrayInputStream bis = new ByteArrayInputStream(contents.getBytes(cEnc));
                DocumentBuilder documentBuilder = this.db;
                synchronized (documentBuilder) {
                    doc = this.db.parse(bis);
                }
                Element rootNode = doc.getDocumentElement();
                if (rootNode == null || !rootNode.getNodeName().equals("body")) {
                    response.sendError(400);
                    break block61;
                }
                NamedNodeMap attribs = rootNode.getAttributes();
                if (attribs.getNamedItem("sid") != null) {
                    Session sess = Session.getSession(attribs.getNamedItem("sid").getNodeValue());
                    if (sess != null) {
                        JHBServlet.dbg("incoming request for " + sess.getSID(), 3);
                        if (attribs.getNamedItem("rid") == null) {
                            JHBServlet.dbg("rid missing", 1);
                            response.sendError(401);
                            sess.terminate();
                        } else {
                            try {
                                rid = Integer.parseInt(attribs.getNamedItem("rid").getNodeValue());
                            }
                            catch (NumberFormatException e) {
                                JHBServlet.dbg("rid not a number", 1);
                                response.sendError(400);
                                return;
                            }
                            Response r = sess.getResponse(rid);
                            if (r != null) {
                                JHBServlet.dbg("resend rid " + rid, 2);
                                r.send();
                                return;
                            }
                            if (!sess.checkValidRID(rid)) {
                                JHBServlet.dbg("invalid rid " + rid, 1);
                                response.sendError(404);
                                sess.terminate();
                                return;
                            }
                        }
                        JHBServlet.dbg("found valid rid " + rid, 3);
                        if (sess.numPendingRequests() >= 2) {
                            JHBServlet.dbg("too many simultaneous requests: " + sess.numPendingRequests(), 1);
                            response.sendError(403);
                            sess.terminate();
                            return;
                        }
                        Response jresp = new Response(response, this.db.newDocument());
                        jresp.setRID(rid);
                        jresp.setContentType(sess.getContent());
                        sess.addResponse(jresp);
                        Socket socket = sess.sock;
                        synchronized (socket) {
                            String rType;
                            int i;
                            int lastrid = sess.getLastDoneRID();
                            while (rid != lastrid + 1) {
                                if (sess.isStatus("term")) {
                                    JHBServlet.dbg("session terminated for " + rid, 1);
                                    response.sendError(401);
                                    sess.sock.notifyAll();
                                    return;
                                }
                                try {
                                    JHBServlet.dbg(rid + " waiting for " + (lastrid + 1), 2);
                                    sess.sock.wait();
                                    JHBServlet.dbg("bell for " + rid, 2);
                                    lastrid = sess.getLastDoneRID();
                                }
                                catch (InterruptedException e) {}
                            }
                            JHBServlet.dbg("handling response " + rid, 3);
                            String key = sess.getKey();
                            if (key != null) {
                                JHBServlet.dbg("checking keys for " + rid, 3);
                                if (attribs.getNamedItem("key") == null || !JHBServlet.sha1(attribs.getNamedItem("key").getNodeValue()).equals(key)) {
                                    JHBServlet.dbg("Key sequence error", 1);
                                    response.sendError(404);
                                    sess.terminate();
                                    return;
                                }
                                if (attribs.getNamedItem("newkey") != null) {
                                    sess.setKey(attribs.getNamedItem("newkey").getNodeValue());
                                } else {
                                    sess.setKey(attribs.getNamedItem("key").getNodeValue());
                                }
                                JHBServlet.dbg("key valid for " + rid, 3);
                            }
                            if (rootNode.hasChildNodes()) {
                                sess.sendNodes(rootNode.getChildNodes());
                                chatService.processIncomingMessages(doc.getElementsByTagName("message"));
                                NodeList presenceList = doc.getElementsByTagName("presence");
                                for (i = 0; i < presenceList.getLength(); ++i) {
                                    Node presence = presenceList.item(i);
                                    List<Node> messages = chatService.processIncomingPresence(presence);
                                    if (messages == null) continue;
                                    for (Node message : messages) {
                                        jresp.addNode(message);
                                    }
                                }
                            } else {
                                long now = System.currentTimeMillis();
                                if (sess.getHold() == 0 && now - sess.getLastPoll() < 2000L) {
                                    JHBServlet.dbg("polling too frequently! [now:" + now + ", last:" + sess.getLastPoll() + "(" + (now - sess.getLastPoll()) + ")]", 1);
                                    response.sendError(403);
                                    sess.terminate();
                                    return;
                                }
                                sess.setLastPoll();
                            }
                            if (attribs.getNamedItem("type") != null && (rType = attribs.getNamedItem("type").getNodeValue()).equals("terminate")) {
                                sess.terminate();
                                jresp.send();
                                return;
                            }
                            NodeList nl = sess.checkInQ(rid);
                            if (nl != null) {
                                for (i = 0; i < nl.getLength(); ++i) {
                                    Node node = nl.item(i);
                                    if (node.getNodeType() == 1 && node.getNodeName() == "message") {
                                        chatService.filterMessage(node);
                                        log.debug((Object)"filtering message");
                                    }
                                    jresp.addNode(nl.item(i));
                                }
                            }
                            if (!sess.authidSent && sess.getAuthid() != null) {
                                sess.authidSent = true;
                                jresp.setAttribute("authid", sess.getAuthid());
                            }
                            jresp.send();
                            sess.setLastDoneRID(jresp.getRID());
                            sess.sock.notifyAll();
                            break block61;
                        }
                    }
                    response.sendError(401);
                    break block61;
                }
                if (attribs.getNamedItem("rid") == null) {
                    response.sendError(400);
                    return;
                }
                try {
                    rid = Integer.parseInt(attribs.getNamedItem("rid").getNodeValue());
                }
                catch (NumberFormatException e) {
                    response.sendError(400);
                    return;
                }
                Response jresp = new Response(response, this.db.newDocument());
                jresp.setRID(rid);
                if (attribs.getNamedItem("to") == null || attribs.getNamedItem("to").getNodeValue() == "") {
                    if (attribs.getNamedItem("content") != null) {
                        jresp.setContentType(attribs.getNamedItem("content").getNodeValue());
                    } else {
                        jresp.setContentType("text/xml; charset=utf-8");
                    }
                    jresp.setAttribute("type", "terminate");
                    jresp.setAttribute("condition", "improper-addressing");
                    jresp.send();
                    return;
                }
                try {
                    Session sess = new Session(attribs.getNamedItem("to").getNodeValue());
                    if (attribs.getNamedItem("content") != null) {
                        sess.setContent(attribs.getNamedItem("content").getNodeValue());
                    }
                    if (attribs.getNamedItem("wait") != null) {
                        sess.setWait(Integer.parseInt(attribs.getNamedItem("wait").getNodeValue()));
                    }
                    if (attribs.getNamedItem("hold") != null) {
                        sess.setHold(Integer.parseInt(attribs.getNamedItem("hold").getNodeValue()));
                    }
                    if (attribs.getNamedItem("xml:lang") != null) {
                        sess.setXMLLang(attribs.getNamedItem("xml:lang").getNodeValue());
                    }
                    if (attribs.getNamedItem("newkey") != null) {
                        sess.setKey(attribs.getNamedItem("newkey").getNodeValue());
                    }
                    sess.addResponse(jresp);
                    jresp.setContentType(sess.getContent());
                    jresp.setAttribute("sid", sess.getSID());
                    jresp.setAttribute("wait", String.valueOf(sess.getWait()));
                    jresp.setAttribute("inactivity", String.valueOf(60));
                    jresp.setAttribute("polling", String.valueOf(2));
                    jresp.setAttribute("requests", String.valueOf(2));
                    if (sess.getAuthid() != null) {
                        sess.authidSent = true;
                        jresp.setAttribute("authid", sess.getAuthid());
                    }
                    jresp.send();
                    sess.setLastDoneRID(jresp.getRID());
                }
                catch (UnknownHostException uhe) {
                    if (attribs.getNamedItem("content") != null) {
                        jresp.setContentType(attribs.getNamedItem("content").getNodeValue());
                    } else {
                        jresp.setContentType("text/xml; charset=utf-8");
                    }
                    jresp.setAttribute("type", "terminate");
                    jresp.setAttribute("condition", "host-unknown");
                    jresp.send();
                }
                catch (IOException ioe) {
                    if (attribs.getNamedItem("content") != null) {
                        jresp.setContentType(attribs.getNamedItem("content").getNodeValue());
                    } else {
                        jresp.setContentType("text/xml; charset=utf-8");
                    }
                    jresp.setAttribute("type", "terminate");
                    jresp.setAttribute("condition", "remote-connection-failed");
                    jresp.send();
                }
                catch (NumberFormatException nfe) {
                    response.sendError(400);
                    return;
                }
            }
            catch (SAXException se) {
                System.err.println(se.toString());
                response.sendError(400);
            }
            catch (Exception e) {
                System.err.println(e.toString());
                e.printStackTrace();
                try {
                    Response jresp = new Response(response, this.db.newDocument());
                    jresp.setAttribute("type", "terminate");
                    jresp.setAttribute("condition", "internal-server-error");
                    jresp.send();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    response.sendError(400);
                }
            }
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug((Object)"starting doGet");
        response.setContentType("text/html");
        PrintWriter writer = response.getWriter();
        String title = "Jabber HTTP Binding Servlet v0.3";
        writer.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        writer.println("<html>\n<head>\n<title>" + title + "</title>\n</head>\n<body>\n");
        writer.println("<h1>" + title + "</h1>");
        writer.println("This is an implementation of JEP-0124 (HTTP-Binding). Please see <a href=\"http://www.jabber.org/jeps/jep-0124.html\">http://www.jabber.org/jeps/jep-0124.html</a> for details.");
        writer.println("\n</body>\n</html>");
    }
}

