/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.chat.JabberHTTPBind;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.lamsfoundation.lams.tool.chat.JabberHTTPBind.JHBServlet;
import org.lamsfoundation.lams.tool.chat.JabberHTTPBind.Response;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Session {
    public static final String DEFAULT_CONTENT = "text/xml; charset=utf-8";
    public static final int MAX_INACTIVITY = 60;
    public static final int MAX_REQUESTS = 2;
    public static final int MAX_WAIT = 300;
    public static final int MIN_POLLING = 2;
    private static final int READ_TIMEOUT = 1;
    protected static final String SESS_START = "starting";
    protected static final String SESS_ACTIVE = "active";
    protected static final String SESS_TERM = "term";
    private static Hashtable sessions = new Hashtable();
    private static TransformerFactory tff = TransformerFactory.newInstance();
    private String authid;
    public boolean authidSent = false;
    private String content = "text/xml; charset=utf-8";
    private DocumentBuilder db;
    private int hold = 1;
    private String inQueue = "";
    private InputStreamReader isr;
    private String key;
    private long lastActive;
    private long lastPoll = 0L;
    private int lastSentRid = 0;
    private OutputStreamWriter osw;
    private TreeMap outQueue;
    private TreeMap responses;
    private String status = "starting";
    private String sid;
    public Socket sock;
    private String to;
    private int wait = 300;
    private String xmllang = "en";
    private int lastDoneRID;

    private static String createSessionID(int len) {
        String charlist = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_";
        Random rand = new Random();
        String str = new String();
        for (int i = 0; i < len; ++i) {
            str = str + charlist.charAt(rand.nextInt(charlist.length()));
        }
        return str;
    }

    public static Session getSession(String sid) {
        return (Session)sessions.get(sid);
    }

    public static Enumeration getSessions() {
        return sessions.elements();
    }

    public static void stopSessions() {
        Enumeration e = sessions.elements();
        while (e.hasMoreElements()) {
            ((Session)e.nextElement()).terminate();
        }
    }

    public Session(String to) throws UnknownHostException, IOException {
        this.to = to;
        this.setLastActive();
        try {
            this.db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.sock = new Socket(to, 5222);
            if (this.sock.isConnected()) {
                System.err.println("Succesfully connected to " + to);
            }
            this.osw = new OutputStreamWriter(this.sock.getOutputStream(), "UTF-8");
            this.osw.write("<stream:stream to='" + this.to + "' xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams'>");
            this.osw.flush();
            while (sessions.get(this.sid = Session.createSessionID(24)) != null) {
            }
            System.err.println("creating session with id " + this.sid);
            sessions.put(this.sid, this);
            this.responses = new TreeMap();
            this.outQueue = new TreeMap();
            this.isr = new InputStreamReader(this.sock.getInputStream(), "UTF-8");
            String stream = this.readFromSocket(0);
            Pattern p = Pattern.compile(".*\\<stream\\:stream.*id=['\"]([^'\"]+)['\"].*\\>.*");
            Matcher m = p.matcher(stream);
            if (m.matches()) {
                this.authid = m.group(1);
            } else {
                JHBServlet.dbg("failed to get authid", 2);
            }
            this.setStatus(SESS_ACTIVE);
        }
        catch (UnknownHostException uhe) {
            throw uhe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    public synchronized Response addResponse(Response r) {
        while (this.responses.size() > 0 && this.responses.size() >= 2) {
            this.responses.remove(this.responses.firstKey());
        }
        return this.responses.put(new Integer(r.getRID()), r);
    }

    public NodeList checkInQ(int rid) {
        NodeList nl = null;
        this.inQueue = this.inQueue + this.readFromSocket(rid);
        if (this.authid == null) {
            Pattern p = Pattern.compile(".*\\<stream\\:stream.*id=['\"]([^'\"]+)['\"].*\\>(.*)");
            Matcher m = p.matcher(this.inQueue);
            if (m.matches()) {
                this.authid = m.group(1);
                this.inQueue = m.group(2);
            } else {
                JHBServlet.dbg("failed to get authid", 2);
            }
        }
        if (!this.inQueue.equals("")) {
            try {
                Document doc = this.db.parse(new InputSource(new StringReader("<doc xmlns='jabber:client'>" + this.inQueue + "</doc>")));
                nl = doc.getFirstChild().getChildNodes();
                this.inQueue = "";
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setLastActive();
        return nl;
    }

    public synchronized boolean checkValidRID(int rid) {
        try {
            if (rid <= (Integer)this.responses.lastKey() + 2 && rid >= (Integer)this.responses.firstKey()) {
                return true;
            }
            JHBServlet.dbg("invalid request id: " + rid + " (last: " + (Integer)this.responses.lastKey() + ")", 1);
            return false;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public String getAuthid() {
        return this.authid;
    }

    public String getContent() {
        return this.content;
    }

    public int getHold() {
        return this.hold;
    }

    public synchronized String getKey() {
        return this.key;
    }

    public synchronized long getLastActive() {
        return this.lastActive;
    }

    public synchronized long getLastPoll() {
        return this.lastPoll;
    }

    public synchronized Response getResponse(int rid) {
        return (Response)this.responses.get(new Integer(rid));
    }

    public String getSID() {
        return this.sid;
    }

    public String getTo() {
        return this.to;
    }

    public int getWait() {
        return this.wait;
    }

    public String getXMLLang() {
        return this.xmllang;
    }

    public synchronized int numPendingRequests() {
        int num_pending = 0;
        for (Response r : this.responses.values()) {
            if (r.getStatus().equals("done")) continue;
            ++num_pending;
        }
        return num_pending;
    }

    public synchronized int getLastDoneRID() {
        return this.lastDoneRID;
    }

    private String readFromSocket(int rid) {
        String retval = "";
        char[] buf = new char[16];
        int c = 0;
        Response r = this.getResponse(rid);
        while (!this.sock.isClosed() && !this.isStatus(SESS_TERM)) {
            this.setLastActive();
            try {
                if (this.isr.ready()) {
                    while (this.isr.ready() && (c = this.isr.read(buf, 0, buf.length)) >= 0) {
                        retval = retval + new String(buf, 0, c);
                    }
                    break;
                }
                if (this.hold == 0 && System.currentTimeMillis() - this.getLastActive() > 200L || this.hold > 0 && (r != null && System.currentTimeMillis() - r.getCDate() >= (long)(this.getWait() * 1000) || this.numPendingRequests() > this.getHold() || !retval.equals(""))) {
                    JHBServlet.dbg("readFromSocket done for " + rid, 3);
                    break;
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ie) {
                    System.err.println(ie.toString());
                }
            }
            catch (IOException e) {
                System.err.println("Can't read from socket");
                this.terminate();
            }
        }
        return retval;
    }

    public Session sendNodes(NodeList nl) {
        String out = "";
        StreamResult strResult = new StreamResult();
        try {
            Transformer tf = tff.newTransformer();
            tf.setOutputProperty("omit-xml-declaration", "yes");
            for (int i = 0; i < nl.getLength(); ++i) {
                strResult.setWriter(new StringWriter());
                tf.transform(new DOMSource(nl.item(i)), strResult);
                String tStr = strResult.getWriter().toString();
                out = out + tStr;
            }
        }
        catch (Exception e) {
            System.err.println("XML.toString(Document): " + e);
        }
        try {
            this.osw.write(out);
            this.osw.flush();
        }
        catch (IOException ioe) {
            System.err.println(this.sid + " failed to write to stream");
        }
        return this;
    }

    public Session setContent(String content) {
        this.content = content;
        return this;
    }

    public Session setHold(int hold) {
        if (hold < 2 && hold >= 0) {
            this.hold = hold;
        }
        return this;
    }

    public synchronized void setKey(String key) {
        this.key = key;
    }

    public synchronized void setLastActive() {
        this.lastActive = System.currentTimeMillis();
    }

    public synchronized void setLastDoneRID(int rid) {
        this.lastDoneRID = rid;
    }

    public synchronized void setLastPoll() {
        this.lastPoll = System.currentTimeMillis();
    }

    public int setWait(int wait) {
        if (wait < 0) {
            wait = 0;
        }
        if (wait > 300) {
            wait = 300;
        }
        this.wait = wait;
        return wait;
    }

    public Session setXMLLang(String xmllang) {
        this.xmllang = xmllang;
        return this;
    }

    public synchronized void setStatus(String status) {
        this.status = status;
    }

    public synchronized boolean isStatus(String status) {
        return this.status == status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        JHBServlet.dbg("terminating session " + this.getSID(), 2);
        this.setStatus(SESS_TERM);
        Socket socket = this.sock;
        synchronized (socket) {
            if (!this.sock.isClosed()) {
                try {
                    this.osw.write("</stream:stream>");
                    this.osw.flush();
                    this.sock.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.sock.notifyAll();
        }
        sessions.remove(this.sid);
    }
}

