/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.ld.security.valve;

import java.io.IOException;
import java.net.URLDecoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.ValveContext;
import org.apache.catalina.authenticator.SavedRequest;
import org.apache.catalina.valves.ValveBase;
import org.lamsfoundation.ld.util.MethodDispatcher;

public class LoginRequestValve
extends ValveBase {
    public static final String PARAM_USERID = "uid";
    public static final String PARAM_URL = "url";
    public static final String URLDECODER_CODING = "US-ASCII";
    public static final String LOGIN_REQUEST = "LoginRequest";

    public void invoke(Request request, Response response, ValveContext context) throws IOException, ServletException {
        if (!(request instanceof HttpRequest) || !(response instanceof HttpResponse)) {
            context.invokeNext(request, response);
            return;
        }
        HttpRequest hrequest = (HttpRequest)request;
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpResponse hresponse = (HttpResponse)response;
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        boolean isLoginRequest = hreq.getRequestURI().endsWith(LOGIN_REQUEST);
        context.invokeNext(request, response);
        if (isLoginRequest) {
            boolean isLoginSuccessful = false;
            String[] rhnames = hresponse.getHeaderNames();
            for (int i = 0; i < rhnames.length; ++i) {
                String[] rhvalues = hresponse.getHeaderValues(rhnames[i]);
                if (!rhnames[i].toLowerCase().equals("location") || !rhvalues[0].matches(".*/j_security_check.*")) continue;
                this.log("header=" + rhnames[i] + "=" + rhvalues[0]);
                isLoginSuccessful = true;
            }
            if (!isLoginSuccessful) {
                this.log("LOGIN REQUEST DETECTED - BUT NO LOGIN IS CARRIED OUT");
                return;
            }
            HttpSession hses = hreq.getSession(false);
            String userid = hreq.getParameter(PARAM_USERID);
            String method = hreq.getParameter("method");
            String redirect = MethodDispatcher.getMethodURL((HttpServletRequest)hreq);
            if (userid != null && redirect != null && hses != null) {
                this.log("LOGIN REQUEST DETECTED - LOGIN SUCCESSFUL");
                redirect = URLDecoder.decode(redirect, URLDECODER_CODING);
                Session session = hrequest.getContext().getManager().findSession(hses.getId());
                SavedRequest saved = new SavedRequest();
                saved.setRequestURI(redirect);
                session.setNote("org.apache.catalina.authenticator.REQUEST", (Object)saved);
            } else {
                this.log("LOGIN REQUEST DETECTED - BUT MISSING REQUIRED PARAM");
            }
        }
    }

    protected void log(String message) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log("LoginRequestValve: " + message);
        } else {
            System.out.println(((Object)((Object)this)).toString() + ": " + message);
        }
    }
}

