/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.activities.authoring;

import com.webmcq.ld.activities.AbstractTaskVO;
import com.webmcq.ld.activities.ActivityDefnVO;
import com.webmcq.ld.activities.GroupDefnVO;
import com.webmcq.ld.activities.GroupingTaskVO;
import com.webmcq.ld.activities.LearningDesignDefnVO;
import com.webmcq.ld.activities.LibraryDefnVO;
import com.webmcq.ld.activities.MultiTaskVO;
import com.webmcq.ld.activities.OptionalActivityDefnVO;
import com.webmcq.ld.activities.OptionalActivityDummyTaskVO;
import com.webmcq.ld.activities.SimpleTaskVO;
import com.webmcq.ld.activities.TransitionDefnVO;
import com.webmcq.ld.activities.authoring.ContentConverter;
import com.webmcq.ld.activities.authoring.ContentDelegate;
import com.webmcq.ld.activities.authoring.LDWDDXValueObjectFactory;
import com.webmcq.ld.activities.dao.LearningDesignDefnDAO;
import com.webmcq.ld.activities.dao.LibraryDefnDAO;
import com.webmcq.ld.content.Content;
import com.webmcq.ld.util.ClientStatusMessage;
import com.webmcq.ld.util.WDDXProcessor;
import com.webmcq.ld.util.persistence.PersistenceSession;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.ejb.EJBException;
import javax.naming.NamingException;
import net.sf.hibernate.HibernateException;
import org.apache.log4j.Logger;

public class LDWDDXValueObjectStorer {
    private static Logger logger = Logger.getLogger((String)(class$com$webmcq$ld$activities$authoring$LDWDDXValueObjectStorer == null ? (class$com$webmcq$ld$activities$authoring$LDWDDXValueObjectStorer = LDWDDXValueObjectStorer.class$("com.webmcq.ld.activities.authoring.LDWDDXValueObjectStorer")) : class$com$webmcq$ld$activities$authoring$LDWDDXValueObjectStorer).getName());
    private LearningDesignDefnVO ldInProgress = null;
    private Map m_groupingsToDo = null;
    private ContentDelegate m_contentUtil = null;
    private Map m_allItems = null;
    static /* synthetic */ Class class$com$webmcq$ld$activities$authoring$LDWDDXValueObjectStorer;

    private void storeInSession(PersistenceSession session, Object obj) throws SQLException, HibernateException {
        session.persistece().save(obj);
    }

    private void deleteFromSession(PersistenceSession session, Object obj) throws SQLException, HibernateException {
        session.persistece().delete(obj);
    }

    protected static boolean isTask(String objectType) {
        return objectType != null && (objectType.equalsIgnoreCase("task") || objectType.equalsIgnoreCase("Multitask"));
    }

    protected static boolean isSimpleTask(String objectType, String toolType) {
        return objectType != null && toolType != null && objectType.equalsIgnoreCase("task") && !toolType.equalsIgnoreCase("group");
    }

    protected static boolean isMultiTask(String objectType, String toolType) {
        return objectType == null ? false : objectType.equalsIgnoreCase("Multitask");
    }

    protected static boolean isGroupingToolTask(String objectType, String toolType) {
        return objectType != null && toolType != null && objectType.equalsIgnoreCase("task") && toolType.equalsIgnoreCase("group");
    }

    protected static boolean isTransition(String objectType) {
        return objectType == null ? false : objectType.equalsIgnoreCase("transition");
    }

    protected static boolean isActivity(String objectType) {
        return objectType == null ? false : objectType.equalsIgnoreCase("Activity");
    }

    protected static boolean isOptionalActivity(String objectType) {
        return objectType == null ? false : objectType.equalsIgnoreCase("optionalactivity");
    }

    protected static boolean isContent(String objectType) {
        return objectType == null ? false : objectType.equalsIgnoreCase("content");
    }

    protected static boolean isLibrary(String objectType) {
        return objectType == null ? false : objectType.trim().equalsIgnoreCase("Library");
    }

    protected static boolean isLearningDesign(String objectType) {
        return objectType == null ? false : objectType.trim().equalsIgnoreCase("LearningDesign");
    }

    protected static boolean isLibraryPackage(String objectType) {
        return objectType == null ? false : objectType.equalsIgnoreCase("LibraryPackage");
    }

    protected static String getExpectedLibraryLearningDesign() {
        return "Wrong format for data - object type expected isLibrary or LearningDesign";
    }

    protected static String getExpectedActivityTransition() {
        return "Wrong format for data - object type expected isActivity or optionalactivity or transition";
    }

    protected static String getExpectedActivity() {
        return "Wrong format for data - object type expected isActivity";
    }

    protected static String getExpectedOptionalActivity() {
        return "Wrong format for data - object type expected isoptionalactivity";
    }

    protected static String getExpectedContent() {
        return "Wrong format for data - object type expected iscontent";
    }

    protected static String getExpectedTaskTransition() {
        return "Wrong format for data - object type expected istask or Multitask or transition";
    }

    protected static String getExpectedTask() {
        return "Wrong format for data - object type expected istask or Multitask";
    }

    protected static String getExpectedLibraryPackage() {
        return "Wrong format for data - object type expected isLibraryPackage";
    }

    private String getValue(String possValue) {
        return possValue == null ? "" : possValue;
    }

    protected ClientStatusMessage processLearningDesign(Hashtable ldHashTable, Long userId) throws NamingException, SQLException {
        ClientStatusMessage result = null;
        Long ldId = null;
        Long newId = null;
        PersistenceSession session = new PersistenceSession();
        boolean okayToSave = true;
        try {
            try {
                ldId = WDDXProcessor.convertToLong("LD ID", ldHashTable.get("LDId"));
                logger.debug((Object)("~~~~~~>Original LD ID: " + ldId));
            }
            catch (Exception e) {
                // empty catch block
            }
            newId = this.storeLearningDesign(session, ldHashTable, ldId, userId);
            result = new ClientStatusMessage("Received", " stored okay", newId != null ? newId.toString() : "");
        }
        catch (Exception e) {
            result = new ClientStatusMessage("Error", "Error occured while storing activity sequence." + e.getMessage(), newId != null ? newId.toString() : "");
            logger.error((Object)("Error occured while storing activity sequence. Unable to store sequence. Trying to store" + ldHashTable.toString()), (Throwable)e);
            okayToSave = false;
        }
        try {
            if (okayToSave) {
                session.flush();
                session.close();
                session = null;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error occured while saving / closing the database connection. Data may not be saved.", (Throwable)e);
            result = new ClientStatusMessage("Error", "Error occured while saving / closing the database connection. Data may not be saved. " + e.getMessage(), newId != null ? newId.toString() : "");
            okayToSave = false;
        }
        if (okayToSave) {
            try {
                String messages = this.validateLearningDesign(newId);
                if (messages != null && messages.length() > 0) {
                    logger.error((Object)("Learning design is not valid. Design is saved. Errors are" + messages));
                    result = new ClientStatusMessage("Error", "Learning design is saved but it is not valid so cannot be run. Please fix errors: " + messages, newId != null ? newId.toString() : "");
                }
            }
            catch (Exception e) {
                logger.error((Object)"Error occured while validating learning design. Design is saved.", (Throwable)e);
                result = new ClientStatusMessage("Error", "Error occured while validating learning design. Design is saved. " + e.getMessage(), newId != null ? newId.toString() : "");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String validateLearningDesign(Long ldId) throws HibernateException, SQLException, Exception {
        PersistenceSession session = new PersistenceSession();
        String messages = new String();
        try {
            LearningDesignDefnVO design = this.findLearningDesignVO(session, ldId);
            messages = design.validate();
            session.flush();
        }
        finally {
            session.close();
            session = null;
        }
        return messages;
    }

    protected LearningDesignDefnVO findLearningDesignVO(PersistenceSession session, Long sid) throws Exception {
        logger.debug((Object)("Looking for learning design " + sid));
        LearningDesignDefnVO ld = null;
        if (sid != null) {
            LearningDesignDefnDAO ldDAO = new LearningDesignDefnDAO(session);
            ld = ldDAO.find(sid);
            logger.debug((Object)("Found learning design " + sid));
        }
        if (ld == null) {
            ld = new LearningDesignDefnVO("LearningDesign");
            this.storeInSession(session, ld);
            session.flush();
            logger.debug((Object)("Created new learning design " + ld.getSid()));
        }
        return ld;
    }

    private Long storeLearningDesign(PersistenceSession session, Hashtable newLdHashTable, Long sid, Long userId) throws RuntimeException, EJBException, Exception {
        LearningDesignDefnVO design = this.findLearningDesignVO(session, sid);
        if (design.isReadOnly()) {
            throw new Exception("\nThis sequence is locked, as it has been used. Please click on File | Save as... and change its name to save it.");
        }
        if (!design.hasWriteAccess(userId)) {
            throw new Exception("Unable to update existing sequence - you do not have write access to this design");
        }
        Long oldSid = sid;
        try {
            this.updateLearningDesign(session, newLdHashTable, design.getSid(), design, userId);
            this.storeInSession(session, design);
            session.flush();
        }
        catch (Exception e) {
            if (!design.getSid().equals(oldSid)) {
                logger.warn((Object)"Deleting corrupt new design - an error occured during saving.");
                this.deleteFromSession(session, design);
                session.flush();
            }
            throw e;
        }
        return design.getSid();
    }

    protected void updateLearningDesign(PersistenceSession session, Hashtable newLdHashTable, Long sid, LearningDesignDefnVO design, Long userId) throws Exception {
        Set activities;
        Vector newContent;
        Integer access;
        logger.debug((Object)("~~~~~~>new assigned LD sid: " + sid));
        this.ldInProgress = design;
        this.m_allItems = new HashMap();
        this.m_groupingsToDo = new HashMap();
        design.setDescription((String)newLdHashTable.get("description"));
        design.setMaxId(WDDXProcessor.convertToInt("Max ID", newLdHashTable.get("maxId")));
        design.setTitle((String)newLdHashTable.get("title"));
        logger.debug((Object)("help text is " + newLdHashTable.get("helpText")));
        design.setHelpText((String)newLdHashTable.get("helpText"));
        if (design.getOwner() == null) {
            design.setOwner(userId);
        }
        design.setReadAccess((access = WDDXProcessor.convertToInteger("Read Access", newLdHashTable.get("readAccess"))) != null ? (long)access.intValue() : -1L);
        access = WDDXProcessor.convertToInteger("Write Access", newLdHashTable.get("writeAccess"));
        design.setWriteAccess(access != null ? (long)access.intValue() : -1L);
        if (this.ldInProgress.getContentSids() == null) {
            this.ldInProgress.setContentSids(new HashSet());
        }
        this.m_contentUtil = new ContentDelegate(this.ldInProgress.getContentSids());
        HashSet content = design.getContentSids();
        if (content == null) {
            content = new HashSet();
            design.setContentSids(content);
        }
        if ((newContent = (Vector)newLdHashTable.get("content")) != null) {
            this.processContent(session, newContent);
        }
        if ((activities = design.getActivities()) == null) {
            activities = new HashSet();
            design.setActivities(activities);
            activities = design.getActivities();
        }
        logger.debug((Object)("~~~~~~~>The number of activities: " + activities.size()));
        Iterator iter = activities.iterator();
        while (iter.hasNext()) {
            ActivityDefnVO act = (ActivityDefnVO)iter.next();
            logger.debug((Object)("~~~~~~~>Activity SID:" + act.getSid() + " ID:" + act.getId()));
        }
        Set transitions = design.getTransitions();
        if (transitions == null) {
            transitions = new HashSet();
            design.setTransitions(transitions);
            transitions = design.getTransitions();
        }
        logger.debug((Object)("~~~~~~>The number of transitions: " + transitions.size()));
        iter = transitions.iterator();
        while (iter.hasNext()) {
            TransitionDefnVO trans = (TransitionDefnVO)iter.next();
            logger.debug((Object)("~~~~~~~>Transition SID:" + trans.getSid() + " ID:" + trans.getId()));
        }
        Vector newActivitiesTransitions = (Vector)newLdHashTable.get("activitiesTransitions");
        Set optionalActivitiesToProcess = null;
        if (newActivitiesTransitions == null) {
            logger.warn((Object)("No activities or transitions were found for  #" + sid));
        } else {
            optionalActivitiesToProcess = this.processActivitiesTransitions(session, newActivitiesTransitions);
        }
        this.processOptionalActivities(session, optionalActivitiesToProcess);
        Integer firstActivity = design.calculateFirstActivity();
        design.setFirstActivityId(firstActivity);
        this.setGroupToTaskLinks();
        this.setOutputTasksAsReplaceWithDynamic();
        this.generateTransitionTitles();
    }

    protected void setOutputTasksAsReplaceWithDynamic() throws Exception {
        Hashtable tasksMap = this.ldInProgress.allTasksWithContent(true);
        Collection simpleTasks = tasksMap.values();
        if (simpleTasks != null) {
            Iterator iter = simpleTasks.iterator();
            Map contentMap = this.m_contentUtil.getCurrentContentsAsMapBySid();
            while (iter.hasNext()) {
                SimpleTaskVO task = (SimpleTaskVO)iter.next();
                Long outputContentSid = task.getOutputContentSid();
                if (outputContentSid == null) continue;
                Content content = (Content)contentMap.get(outputContentSid);
                content.setReplaceWithDynamic(true);
                this.m_contentUtil.updateContent(content);
            }
        }
    }

    public void generateTransitionTitles() {
        this.generateTransitionTitles(this.ldInProgress.getTransitions());
        Set activities = this.ldInProgress.getActivities();
        if (activities != null) {
            Iterator iter = activities.iterator();
            while (iter.hasNext()) {
                ActivityDefnVO activity = (ActivityDefnVO)iter.next();
                this.generateTransitionTitles(activity.getTransitions());
            }
        }
    }

    private void generateTransitionTitles(Collection transitions) {
        if (transitions != null) {
            Iterator iter = transitions.iterator();
            while (iter.hasNext()) {
                TransitionDefnVO element = (TransitionDefnVO)iter.next();
                if (element.getTitle() != null && element.getTitle().length() != 0) continue;
                String title = null;
                int nextId = element.getToTaskActivityId();
                Object nextItem = this.m_allItems.get(new Integer(nextId));
                if (nextItem == null) {
                    logger.warn((Object)("generateTransitionTitles: Unable to find item id=" + nextId + " in item map"));
                } else {
                    try {
                        Object[] parameterTypes = new Class[]{};
                        Method titleMethod = nextItem.getClass().getMethod("getTitle", (Class<?>[])parameterTypes);
                        title = (String)titleMethod.invoke(nextItem, parameterTypes);
                    }
                    catch (InvocationTargetException e) {
                    }
                    catch (NoSuchMethodException e) {
                    }
                    catch (IllegalAccessException e) {
                        // empty catch block
                    }
                }
                element.setTitle(title == null ? "To unnamed task" : "To " + title);
            }
        }
    }

    protected Set processActivitiesTransitions(PersistenceSession session, List newActivitiesTransitions) throws Exception {
        Set currentActivities = this.ldInProgress.getActivities();
        Set currentTransitions = this.ldInProgress.getTransitions();
        HashSet<Hashtable> newOptionalActivities = new HashSet<Hashtable>();
        HashSet<Integer> idsUpdated = new HashSet<Integer>();
        logger.debug((Object)("~~~~~The number of newActivitiesTransitions:" + newActivitiesTransitions.size()));
        Iterator tempIterator = newActivitiesTransitions.iterator();
        while (tempIterator.hasNext()) {
            Hashtable clientObj = (Hashtable)tempIterator.next();
            String objectType = (String)clientObj.get("objectType");
            if (!(LDWDDXValueObjectStorer.isActivity(objectType) || LDWDDXValueObjectStorer.isTransition(objectType) || LDWDDXValueObjectStorer.isOptionalActivity(objectType))) {
                throw new Exception(LDWDDXValueObjectStorer.getExpectedActivityTransition() + " received " + objectType + ". Unable to store .");
            }
            Integer objId = WDDXProcessor.convertToInteger("Activity/Transition ID", clientObj.get("id"));
            if (LDWDDXValueObjectFactory.NUMERIC_NULL_VALUE_INTEGER.equals(objId)) {
                throw new Exception("Id for activity is the internal null value. Activity is" + clientObj.toString());
            }
            if (LDWDDXValueObjectStorer.isActivity(objectType)) {
                ActivityDefnVO activity = this.ldInProgress.selectActivity(objId);
                if (activity == null) {
                    activity = new ActivityDefnVO();
                    this.storeInSession(session, activity);
                    currentActivities.add(activity);
                }
                this.updateActivity(session, clientObj, objId, activity);
                this.m_allItems.put(objId, activity);
            } else if (LDWDDXValueObjectStorer.isOptionalActivity(objectType)) {
                newOptionalActivities.add(clientObj);
            } else {
                TransitionDefnVO transition = this.ldInProgress.selectTransition(objId);
                if (transition == null) {
                    transition = new TransitionDefnVO();
                    this.storeInSession(session, transition);
                    currentTransitions.add(transition);
                }
                this.updateTransition(clientObj, objId, transition);
                this.m_allItems.put(objId, transition);
            }
            idsUpdated.add(objId);
        }
        tempIterator = currentActivities.iterator();
        while (tempIterator.hasNext()) {
            ActivityDefnVO activity = (ActivityDefnVO)tempIterator.next();
            Integer activityId = new Integer(activity.getId());
            if (idsUpdated.contains(activityId)) continue;
            logger.debug((Object)("Removing activity as no longer needed in design #" + this.ldInProgress.getSid() + " activity: " + activity.toString()));
            tempIterator.remove();
            this.deleteActivity(session, activity);
        }
        tempIterator = currentTransitions.iterator();
        while (tempIterator.hasNext()) {
            TransitionDefnVO transition = (TransitionDefnVO)tempIterator.next();
            Integer transitionId = new Integer(transition.getId());
            if (idsUpdated.contains(transitionId)) continue;
            logger.debug((Object)("Removing transition as no longer needed in design #" + this.ldInProgress.getSid() + " transition: " + transition.toString()));
            tempIterator.remove();
            this.deleteTransition(session, transition);
        }
        return newOptionalActivities;
    }

    protected void updateTask(PersistenceSession session, Hashtable clientObj, AbstractTaskVO task, Integer objId) throws Exception {
        task.setCompletion((String)clientObj.get("completion"));
        task.setDescription((String)clientObj.get("description"));
        task.setId(objId);
        task.setTitle((String)clientObj.get("title"));
        task.setNextTaskId(0L);
        this.updateGroupingValue(clientObj.get("grouping"), task, objId);
        switch (task.theTaskType()) {
            case 1: {
                this.updateSimpleTask(clientObj, (SimpleTaskVO)task);
                break;
            }
            case 2: {
                this.updateMultiTask(session, clientObj, (MultiTaskVO)task, objId);
                break;
            }
            case 4: {
                this.updateGroupingTask(session, clientObj, (GroupingTaskVO)task, objId);
            }
        }
    }

    protected void updateGroupingValue(Object groupingId, AbstractTaskVO task, Integer objId) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("updateGroupingValue: groupingId" + (groupingId != null ? groupingId.toString() : "null") + " task " + task.toString() + " objId " + objId));
        }
        Integer grouping = null;
        if (groupingId != null) {
            try {
                grouping = WDDXProcessor.convertToInteger("Grouping ID", groupingId);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (grouping != null) {
            this.m_groupingsToDo.put(objId, grouping);
            logger.debug((Object)("Is grouped activity, id=" + grouping));
        } else {
            this.clearGroupingDefnLink(task);
            logger.debug((Object)"Is class activity");
        }
    }

    private void clearGroupingDefnLink(AbstractTaskVO task) {
        if (task.getGroupsForTask() != null) {
            task.getGroupsForTask().clear();
        } else {
            task.setGroupsForTask(new HashSet());
        }
    }

    private Long getContentSid(Long creationToolKey) throws Exception {
        if (creationToolKey == null || creationToolKey.equals(LDWDDXValueObjectFactory.NUMERIC_NULL_VALUE_LONG)) {
            return null;
        }
        Map currentContents = this.m_contentUtil.getCurrentContentsAsMapByCreationToolKey();
        Content content = (Content)currentContents.get(creationToolKey.toString());
        if (content == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Content missing - looking for creationToolKey " + creationToolKey));
            }
            throw new Exception("There is something wrong in the learning design you are trying to save. If you are importing it, it may contain Share Resources that has a  reference to an uploaded file. Currently LAMS does not support export/import designs with a file resource. Content missing " + creationToolKey + ")");
        }
        return content.getSid();
    }

    protected void updateSimpleTask(Hashtable clientObj, SimpleTaskVO simpleTask) throws Exception {
        Long icId = WDDXProcessor.convertToLong("Input Content Id", clientObj.get("inputContent"));
        simpleTask.setInputContentSid(this.getContentSid(icId));
        Long ocId = WDDXProcessor.convertToLong("Output Content Id", clientObj.get("outputContent"));
        simpleTask.setOutputContentSid(this.getContentSid(ocId));
        simpleTask.setToolType(this.getValue((String)clientObj.get("toolType")));
    }

    protected void updateGroupingTask(PersistenceSession session, Hashtable clientObj, GroupingTaskVO groupTask, Integer objId) throws Exception {
        this.updateSimpleTask(clientObj, groupTask);
        GroupDefnVO groupDefn = groupTask.getGroupDefn();
        if (groupDefn == null) {
            groupDefn = new GroupDefnVO();
            this.storeInSession(session, groupDefn);
            groupTask.setGroupDefn(groupDefn);
        }
        groupTask.getGroupDefn().setId(objId);
        Integer contentId = WDDXProcessor.convertToInteger("Group Defn Content Id", clientObj.get("inputContent"));
        if (contentId != null) {
            Map contentMap = this.m_contentUtil.getCurrentContentsAsMapByCreationToolKey();
            Content content = (Content)contentMap.get(contentId.toString());
            groupDefn.setDefnContentSid(content.getSid());
        }
    }

    protected void processContent(PersistenceSession session, List newContent) throws Exception {
        ContentConverter converter = new ContentConverter();
        Map contentMap = this.m_contentUtil.getCurrentContentsAsMapByCreationToolKey();
        Map contentMapInit = this.m_contentUtil.getCurrentContentsAsMapBySid();
        HashSet<Long> idsUpdated = new HashSet<Long>();
        Iterator iterator = newContent.iterator();
        while (iterator.hasNext()) {
            String objectType;
            Hashtable clientObj = (Hashtable)iterator.next();
            if (clientObj == null) {
                logger.error((Object)"Packet contains invalid content - one of the content objects is null!");
                logger.error((Object)("Content list is" + newContent.toString()));
            }
            if (!LDWDDXValueObjectStorer.isContent(objectType = (String)clientObj.get("objectType"))) {
                throw new Exception(LDWDDXValueObjectStorer.getExpectedContent() + " received " + objectType + ". Unable to store .");
            }
            Integer objId = WDDXProcessor.convertToInteger("Content ID", clientObj.get("id"));
            if (LDWDDXValueObjectFactory.NUMERIC_NULL_VALUE_INTEGER.equals(objId)) {
                throw new Exception("Id value for content is internal null value. Content is " + clientObj.toString());
            }
            logger.debug((Object)("Looking for content with internal id " + objId.toString()));
            Content aContent = (Content)contentMap.get(objId.toString());
            logger.debug((Object)("Got " + (aContent != null ? aContent.toString() : " null")));
            if (aContent == null) {
                String contentType = (String)clientObj.get("contentType");
                aContent = converter.createNewContentObject(contentType != null ? contentType.trim() : contentType);
                aContent = this.m_contentUtil.insertContent(aContent);
            }
            converter.convertToDBData(clientObj, aContent, objId);
            this.m_contentUtil.updateContent(aContent);
            this.ldInProgress.getContentSids().add(aContent.getSid());
            idsUpdated.add(aContent.getSid());
        }
        this.m_contentUtil.refreshCurrentContents(this.ldInProgress.getContentSids());
        logger.debug((Object)("refreshed current content is" + this.m_contentUtil.getCurrentContentsAsMapBySid()));
        Set currentContentIds = contentMapInit.keySet();
        iterator = currentContentIds.iterator();
        while (iterator.hasNext()) {
            Long id = (Long)iterator.next();
            if (idsUpdated.contains(id)) continue;
            logger.debug((Object)("Removing content as no longer needed in design #" + this.ldInProgress.getSid() + " content: " + contentMapInit.get(id)));
            this.deleteContent(session, (Content)contentMapInit.get(id));
            this.ldInProgress.getContentSids().remove(id);
            iterator.remove();
        }
    }

    protected void processOptionalActivities(PersistenceSession session, Set newOptionalActivities) throws Exception {
        if (this.ldInProgress.getOptionalActivities() == null) {
            this.ldInProgress.setOptionalActivities(new HashSet());
        }
        if (newOptionalActivities == null) {
            return;
        }
        HashSet<Integer> idsUpdated = new HashSet<Integer>();
        Iterator tempIterator = newOptionalActivities.iterator();
        while (tempIterator.hasNext()) {
            Hashtable clientObj = (Hashtable)tempIterator.next();
            String objectType = (String)clientObj.get("objectType");
            if (!LDWDDXValueObjectStorer.isOptionalActivity(objectType)) {
                throw new Exception(LDWDDXValueObjectStorer.getExpectedOptionalActivity() + " received " + objectType + ". Unable to store .");
            }
            Integer objId = WDDXProcessor.convertToInteger("Optional Activity ID", clientObj.get("id"));
            if (LDWDDXValueObjectFactory.NUMERIC_NULL_VALUE_INTEGER.equals(objId)) {
                throw new Exception("Id for optional activity is the internal null value. Optional activity is" + clientObj.toString());
            }
            OptionalActivityDefnVO optAct = this.ldInProgress.selectOptionalActivity(objId);
            if (optAct == null) {
                optAct = new OptionalActivityDefnVO();
                this.storeInSession(session, optAct);
                this.ldInProgress.getOptionalActivities().add(optAct);
            }
            this.updateOptionalActivity(session, clientObj, objId, optAct);
            this.m_allItems.put(objId, optAct);
            idsUpdated.add(objId);
        }
        tempIterator = this.ldInProgress.getOptionalActivities().iterator();
        while (tempIterator.hasNext()) {
            OptionalActivityDefnVO activity = (OptionalActivityDefnVO)tempIterator.next();
            Integer activityId = new Integer(activity.getId());
            if (idsUpdated.contains(activityId)) continue;
            logger.debug((Object)("Removing optional activity as no longer needed in design #" + this.ldInProgress.getSid() + " activity: " + activity.toString()));
            tempIterator.remove();
            this.deleteOptionalActivity(session, activity);
        }
    }

    protected void updateMultiTask(PersistenceSession session, Hashtable clientObj, MultiTaskVO multiTask, Integer objId) throws Exception {
        List subTasksWDDX;
        Integer taskId = WDDXProcessor.convertToInteger("InputContentTask", clientObj.get("inputContentTask"));
        if (!LDWDDXValueObjectFactory.NUMERIC_NULL_VALUE_INTEGER.equals(objId)) {
            multiTask.setInputContentTask(taskId);
        } else {
            multiTask.setInputContentTask(null);
        }
        taskId = WDDXProcessor.convertToInteger("OutputContentTask", clientObj.get("outputContentTask"));
        if (!LDWDDXValueObjectFactory.NUMERIC_NULL_VALUE_INTEGER.equals(objId)) {
            multiTask.setOutputContentTask(taskId);
        } else {
            multiTask.setOutputContentTask(null);
        }
        multiTask.setTaskOrderOnScreen((String)clientObj.get("taskOrder"));
        Set<AbstractTaskVO> subTasks = multiTask.getSubTasks();
        if (subTasks == null) {
            subTasks = new HashSet();
            multiTask.setSubTasks(subTasks);
            subTasks = multiTask.getSubTasks();
        }
        if ((subTasksWDDX = (List)clientObj.get("subTasks")) != null) {
            Iterator iter = subTasksWDDX.iterator();
            while (iter.hasNext()) {
                Hashtable subTaskWDDX = (Hashtable)iter.next();
                String objectType = (String)subTaskWDDX.get("objectType");
                if (!LDWDDXValueObjectStorer.isTask(objectType)) {
                    throw new Exception(LDWDDXValueObjectStorer.getExpectedTask() + "received " + objectType);
                }
                taskId = WDDXProcessor.convertToInteger("Task ID", subTaskWDDX.get("id"));
                AbstractTaskVO subTask = multiTask.selectTaskById(taskId);
                if (subTask == null) {
                    subTask = this.createNewTask(subTaskWDDX);
                    this.storeInSession(session, subTask);
                    subTasks.add(subTask);
                }
                this.updateTask(session, subTaskWDDX, subTask, taskId);
            }
        }
    }

    protected AbstractTaskVO createNewTask(Hashtable clientObj) throws Exception {
        String toolType;
        String objectType = (String)clientObj.get("objectType");
        if (LDWDDXValueObjectStorer.isMultiTask(objectType, toolType = (String)clientObj.get("toolType"))) {
            return new MultiTaskVO();
        }
        if (LDWDDXValueObjectStorer.isGroupingToolTask(objectType, toolType)) {
            return new GroupingTaskVO();
        }
        return new SimpleTaskVO();
    }

    protected void setGroupToTaskLinks() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setGroupToTaskLinks: m_groupingsToDo=" + (this.m_groupingsToDo != null ? this.m_groupingsToDo.toString() : "null")));
        }
        if (this.m_groupingsToDo == null || this.m_groupingsToDo.isEmpty()) {
            return;
        }
        Hashtable allTasksById = this.ldInProgress.allTasks(false);
        Set keys = this.m_groupingsToDo.keySet();
        Iterator linksToProcess = keys.iterator();
        while (linksToProcess.hasNext()) {
            Integer taskId = (Integer)linksToProcess.next();
            AbstractTaskVO task = (AbstractTaskVO)allTasksById.get(taskId);
            if (task == null) {
                String message = "Assigning grouping definition to a task. Internal error task not found. Task sid = " + taskId;
                logger.error((Object)message);
                throw new Exception(message);
            }
            Integer groupingTaskId = (Integer)this.m_groupingsToDo.get(taskId);
            logger.debug((Object)("Processing group link, task id=" + taskId + " groupingTaskId " + groupingTaskId));
            Object obj = null;
            GroupingTaskVO groupingtask = null;
            try {
                obj = allTasksById.get(groupingTaskId);
                groupingtask = (GroupingTaskVO)obj;
            }
            catch (ClassCastException cce) {
                String message = "Assigning grouping definition to a task. Grouping task not correct type. Task id = " + groupingTaskId + " expected to be grouping task, got " + obj.toString() + " Was trying to find grouping task for task " + task.toString();
                logger.error((Object)message);
                throw new Exception(message);
            }
            if (groupingtask == null) {
                String message = "Assigning grouping definition to a task. Matching grouping task not found. Looking for grouping task " + groupingTaskId + " for task " + task.toString();
                logger.error((Object)message);
                throw new Exception(message);
            }
            GroupDefnVO groupDefn = groupingtask.getGroupDefn();
            if (groupDefn == null) {
                String message = "Assigning grouping definition to a task. Matching grouping task missing grouping defn. Grouping task " + groupingtask.toString() + " for task " + task.toString();
                logger.error((Object)message);
                throw new Exception(message);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding group definition to groupsForTask. GroupDefn=" + groupDefn));
            }
            if (task.getGroupsForTask() == null) {
                task.setGroupsForTask(new HashSet());
            }
            task.getGroupsForTask().add(groupDefn);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("GroupsForTask is now =" + task.getGroupsForTask()));
        }
    }

    protected void updateActivity(PersistenceSession session, Hashtable clientObj, Integer objId, ActivityDefnVO activity) throws Exception {
        List taskTransitions;
        Set transitions;
        activity.setId(objId);
        activity.setDescription((String)clientObj.get("description"));
        activity.setTitle((String)clientObj.get("title"));
        activity.setLibraryActivityId((String)clientObj.get("libId"));
        activity.setXcoord(WDDXProcessor.convertToInteger("X co-ord", clientObj.get("x")));
        activity.setYcoord(WDDXProcessor.convertToInteger("Y co-ord", clientObj.get("y")));
        Set tasks = activity.getTasks();
        if (tasks == null) {
            activity.setTasks(new HashSet());
            tasks = activity.getTasks();
        }
        if ((transitions = activity.getTransitions()) == null) {
            activity.setTransitions(new HashSet());
            tasks = activity.getTransitions();
        }
        if ((taskTransitions = (List)clientObj.get("tasksTransitions")) != null) {
            this.processTaskTransitions(session, taskTransitions, activity);
        }
        activity.setFirstTaskId(activity.calculateFirstTask());
    }

    protected void updateTransition(Hashtable clientObj, Integer objId, TransitionDefnVO transition) throws Exception {
        transition.setCompletion((String)clientObj.get("completionType"));
        transition.setId(objId);
        Integer toTask = WDDXProcessor.convertToInteger("ToTaskActivities", clientObj.get("toTasks"));
        if (LDWDDXValueObjectFactory.NUMERIC_NULL_VALUE_INTEGER.equals(toTask)) {
            throw new Exception("Transition missing to task. Transition id " + objId);
        }
        transition.setToTaskActivityId(toTask);
        Integer fromTask = WDDXProcessor.convertToInteger("FromTaskActivities", clientObj.get("fromTasks"));
        if (LDWDDXValueObjectFactory.NUMERIC_NULL_VALUE_INTEGER.equals(fromTask)) {
            throw new Exception("Transition missing from task. Transition id " + objId);
        }
        transition.setFromTaskActivityId(fromTask);
    }

    protected void processTaskTransitions(PersistenceSession session, List newTT, ActivityDefnVO activity) throws Exception {
        Set currentTasks = activity.getTasks();
        Set currentTransitions = activity.getTransitions();
        Iterator iterator = newTT.iterator();
        while (iterator.hasNext()) {
            Hashtable clientObj = (Hashtable)iterator.next();
            String objectType = (String)clientObj.get("objectType");
            if (!LDWDDXValueObjectStorer.isTask(objectType) && !LDWDDXValueObjectStorer.isTransition(objectType)) {
                throw new Exception(LDWDDXValueObjectStorer.getExpectedTaskTransition() + " received " + objectType);
            }
            Integer objId = WDDXProcessor.convertToInteger("Task/Transition ID", clientObj.get("id"));
            if (LDWDDXValueObjectFactory.NUMERIC_NULL_VALUE_INTEGER.equals(objId)) {
                throw new Exception("Id value for task/transition is internal null value. Task/transition is " + clientObj.toString());
            }
            if (LDWDDXValueObjectStorer.isTask(objectType)) {
                AbstractTaskVO task = activity.selectTaskById(objId);
                if (task == null) {
                    task = this.createNewTask(clientObj);
                    this.storeInSession(session, task);
                    currentTasks.add(task);
                }
                this.updateTask(session, clientObj, task, objId);
                this.m_allItems.put(objId, task);
                continue;
            }
            TransitionDefnVO transition = activity.selectTransitionbyId(objId);
            if (transition == null) {
                transition = new TransitionDefnVO();
                this.storeInSession(session, transition);
                currentTransitions.add(transition);
            }
            this.updateTransition(clientObj, objId, transition);
            this.m_allItems.put(objId, transition);
        }
    }

    protected void updateOptionalActivity(PersistenceSession session, Hashtable clientObj, Integer objId, OptionalActivityDefnVO optAct) throws Exception {
        optAct.setId(objId);
        optAct.setDescription((String)clientObj.get("description"));
        optAct.setTitle((String)clientObj.get("title"));
        Integer toTask = WDDXProcessor.convertToInteger("Minimum number activities to complete", clientObj.get("minNumberComplete"));
        optAct.setMinNumberComplete(toTask);
        optAct.setXcoordStart(WDDXProcessor.convertToInteger("X co-ord start", clientObj.get("x")));
        optAct.setYcoordStart(WDDXProcessor.convertToInteger("Y co-ord start", clientObj.get("y")));
        optAct.setXcoordEnd(WDDXProcessor.convertToInteger("X co-ord start", clientObj.get("xEnd")));
        optAct.setYcoordEnd(WDDXProcessor.convertToInteger("Y co-ord start", clientObj.get("yEnd")));
        Set activities = optAct.getActivities();
        if (activities == null) {
            optAct.setActivities(new HashSet());
        }
        logger.debug((Object)("~~~~~~~~>Optional Activity ID:" + optAct.getId()));
        Vector activityIds = (Vector)clientObj.get("activities");
        if (activityIds != null) {
            Iterator iter = activityIds.iterator();
            logger.debug((Object)("~~~~~~~~>The number of the acitivities in the optional activity: " + activityIds.size()));
            while (iter.hasNext()) {
                Integer id = WDDXProcessor.convertToInteger("Activity ID in Optional Activity", iter.next());
                logger.debug((Object)("~~~~~~~>Activity ID in Optional Activity:" + id));
                ActivityDefnVO act = this.ldInProgress.selectActivity(id);
                if (act == null) {
                    logger.error((Object)("Unable to find activity object to match optional activity definition. Optional activity is " + optAct.toString() + " looking for activity id " + id));
                    throw new Exception("Unable to find activity object to match optional activity definition.  Optional activity id is " + optAct.getId() + " looking for activity id " + id);
                }
                optAct.getActivities().add(act);
            }
        }
        this.updateDummyTask(session, optAct);
    }

    protected ClientStatusMessage processLibraryActivity(Hashtable libHashTable, Long userId) throws NamingException, SQLException {
        LibraryDefnVO lib = null;
        ClientStatusMessage result = null;
        Long libId = null;
        PersistenceSession session = new PersistenceSession();
        boolean okayToSave = true;
        try {
            try {
                libId = WDDXProcessor.convertToLong("Library Id", libHashTable.get("sid"));
            }
            catch (Exception e) {
                // empty catch block
            }
            lib = LDWDDXValueObjectFactory.findCreateLibrary(session, libId, userId);
            this.storeLibraryActivity(session, libHashTable, lib, userId);
            result = new ClientStatusMessage("Received", " stored okay", lib.getSid().toString());
        }
        catch (Exception e) {
            result = new ClientStatusMessage("Error", "Error occured while storing activity sequence. Unable to store sequence. " + e.getMessage(), lib != null ? lib.getSid().toString() : "");
            logger.error((Object)("Error occured while storing activity sequence. Unable to store sequence. Trying to store" + (lib != null ? lib.getSid().toString() : "")), (Throwable)e);
            okayToSave = false;
        }
        try {
            if (okayToSave) {
                session.flush();
                session.close();
                session = null;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error occured while saving / closing the database connection. Data may not be saved.", (Throwable)e);
            result = new ClientStatusMessage("Error", "Error occured while saving / closing the database connection. Data may not be saved. " + e.getMessage(), lib != null ? lib.getSid().toString() : "");
        }
        return result;
    }

    private void storeLibraryActivity(PersistenceSession session, Hashtable newLibHashTable, LibraryDefnVO lib, Long userId) throws RuntimeException, EJBException, Exception {
        Vector newPackages;
        Set<LearningDesignDefnVO> packages = lib.getLibraryPackages();
        if (packages == null) {
            packages = new HashSet();
            lib.setLibraryPackages(packages);
            packages = lib.getLibraryPackages();
        }
        if ((newPackages = (Vector)newLibHashTable.get("packages")) == null) {
            logger.warn((Object)("No packages were found for  #" + lib.getSid()));
        } else {
            String value = (String)newLibHashTable.get("description");
            if (value != null && value.length() > 0) {
                lib.setDescription(value);
            }
            if ((value = (String)newLibHashTable.get("title")) != null && value.length() > 0) {
                lib.setTitle(value);
            }
            Iterator tempIterator = newPackages.iterator();
            while (tempIterator.hasNext()) {
                Hashtable clientObj = (Hashtable)tempIterator.next();
                String objectType = (String)clientObj.get("objectType");
                if (!LDWDDXValueObjectStorer.isLibraryPackage(objectType)) {
                    throw new Exception(LDWDDXValueObjectStorer.getExpectedLibraryPackage() + " received " + objectType + ". Unable to store .");
                }
                Long sid = null;
                try {
                    sid = WDDXProcessor.convertToLong("Package Sid", clientObj.get("sid"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                LearningDesignDefnVO packageToUpdate = null;
                packageToUpdate = lib.selectPackage(sid);
                if (packageToUpdate == null) {
                    packageToUpdate = new LearningDesignDefnVO("LibraryPackage");
                    this.storeInSession(session, packageToUpdate);
                    packages.add(packageToUpdate);
                }
                Long id = null;
                try {
                    id = WDDXProcessor.convertToLong("Package ID", clientObj.get("id"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (id == null) {
                    id = new Long(0L);
                }
                this.updateLearningDesign(session, clientObj, id, packageToUpdate, userId);
            }
        }
    }

    protected void deleteLibraryPackage(Long libSid, Long packageSid, Long userId) throws RuntimeException, EJBException, Exception {
        if (packageSid == null) {
            throw new Exception("Unable to delete library activity in library - activity id was null");
        }
        PersistenceSession session = new PersistenceSession();
        LibraryDefnVO lib = LDWDDXValueObjectFactory.findCreateLibrary(session, libSid, userId);
        LearningDesignDefnVO packageToDelete = lib.selectPackage(packageSid);
        if (packageToDelete != null) {
            if (!packageToDelete.hasWriteAccess(userId)) {
                throw new Exception("Unable to delete library activity " + packageSid + " in library" + libSid + ". User does not have write access");
            }
        } else {
            throw new Exception("Unable to delete library activity " + packageSid + " in library" + libSid + ". Package not found");
        }
        logger.warn((Object)("Removing library package " + packageSid + " " + packageToDelete.toString() + " from library. " + lib.getSid() + " " + lib.getTitle()));
        this.deleteLearningDesignLibraryPackage(session, packageToDelete);
        session.flush();
        session.close();
        session = null;
    }

    private void deleteActivity(PersistenceSession session, ActivityDefnVO activity) throws Exception {
        if (activity != null) {
            Iterator iter;
            Set contained = activity.getTasks();
            if (contained != null) {
                iter = contained.iterator();
                while (iter.hasNext()) {
                    AbstractTaskVO task = (AbstractTaskVO)iter.next();
                    this.deleteTask(session, task);
                }
            }
            if ((contained = activity.getTransitions()) != null) {
                iter = contained.iterator();
                while (iter.hasNext()) {
                    TransitionDefnVO transition = (TransitionDefnVO)iter.next();
                    this.deleteFromSession(session, transition);
                }
            }
            this.deleteFromSession(session, activity);
        }
    }

    private void deleteOptionalActivity(PersistenceSession session, OptionalActivityDefnVO activity) throws Exception {
        if (activity != null) {
            this.deleteFromSession(session, activity);
        }
    }

    private void deleteTransition(PersistenceSession session, TransitionDefnVO transition) throws Exception {
        if (transition != null) {
            this.deleteFromSession(session, transition);
        }
    }

    private void deleteTask(PersistenceSession session, AbstractTaskVO task) throws Exception {
        if (task != null) {
            MultiTaskVO multiTask;
            Set contained;
            if (task.theTaskType() == 2 && (contained = (multiTask = (MultiTaskVO)task).getSubTasks()) != null) {
                Iterator iter = contained.iterator();
                while (iter.hasNext()) {
                    this.deleteTask(session, (AbstractTaskVO)iter.next());
                }
            }
            this.deleteFromSession(session, task);
        }
    }

    private void deleteContent(PersistenceSession session, Content content) throws Exception {
        if (content != null) {
            this.deleteFromSession(session, content);
            logger.error((Object)("Unable to delete content from database as content repository does not have a delete mechanism. Content " + content.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLearningDesign(int ldSid, Long userId) throws RuntimeException, EJBException, Exception {
        LearningDesignDefnVO ld = null;
        PersistenceSession session = new PersistenceSession();
        String error = null;
        try {
            LearningDesignDefnDAO ldDAO = new LearningDesignDefnDAO(session);
            ld = ldDAO.find(ldSid);
            if (ld != null) {
                if (ld.hasWriteAccess(userId)) {
                    this.deleteLearningDesignLibraryPackage(session, ld);
                    session.flush();
                } else {
                    error = "Unable to delete learning design " + ldSid + ". User does not have write access.";
                }
            } else {
                error = "Unable to delete learning design " + ldSid + ". Learning design not found.";
            }
        }
        finally {
            session.close();
            session = null;
        }
        if (error != null) {
            throw new Exception(error);
        }
    }

    protected void deleteLearningDesignLibraryPackage(PersistenceSession session, LearningDesignDefnVO ld) throws Exception, SQLException, HibernateException {
        Iterator iter;
        logger.warn((Object)("Deleting learning design/library package " + ld.getSid() + " and associated objects" + ld.toString()));
        ContentDelegate contentUtil = new ContentDelegate(ld.getContentSids());
        Map contentMapInit = contentUtil.getCurrentContentsAsMapBySid();
        Set currentContentIds = contentMapInit.keySet();
        Iterator iterator = currentContentIds.iterator();
        while (iterator.hasNext()) {
            Long id = (Long)iterator.next();
            this.deleteContent(session, (Content)contentMapInit.get(id));
            ld.getContentSids().remove(id);
            iterator.remove();
        }
        Set contained = ld.getActivities();
        if (contained != null) {
            iter = contained.iterator();
            while (iter.hasNext()) {
                ActivityDefnVO activity = (ActivityDefnVO)iter.next();
                this.deleteActivity(session, activity);
            }
        }
        if ((contained = ld.getOptionalActivities()) != null) {
            iter = contained.iterator();
            while (iter.hasNext()) {
                OptionalActivityDefnVO optionalActivity = (OptionalActivityDefnVO)iter.next();
                this.deleteOptionalActivity(session, optionalActivity);
            }
        }
        if ((contained = ld.getTransitions()) != null) {
            iter = contained.iterator();
            while (iter.hasNext()) {
                TransitionDefnVO transition = (TransitionDefnVO)iter.next();
                this.deleteFromSession(session, transition);
            }
        }
        this.deleteFromSession(session, ld);
    }

    public void deleteLibrary(Long libSid) throws Exception {
        if (libSid == null) {
            throw new Exception("Unable to delete library activity as library id was null.");
        }
        PersistenceSession session = new PersistenceSession();
        LibraryDefnDAO libDAO = new LibraryDefnDAO(session);
        LibraryDefnVO lib = libDAO.find(libSid);
        if (lib != null) {
            logger.warn((Object)("Removing library " + lib.getSid() + " " + lib.getTitle()));
            Set contained = lib.getLibraryPackages();
            if (contained != null) {
                Iterator iter = contained.iterator();
                while (iter.hasNext()) {
                    LearningDesignDefnVO packageToDelete = (LearningDesignDefnVO)iter.next();
                    this.deleteLearningDesignLibraryPackage(session, packageToDelete);
                }
            }
        } else {
            throw new Exception("Unable to delete library " + libSid + ". Library not found");
        }
        this.deleteFromSession(session, lib);
        session.flush();
        session.close();
        session = null;
    }

    public void updateDummyTask(PersistenceSession session, OptionalActivityDefnVO optAct) throws Exception {
        OptionalActivityDummyTaskVO result = optAct.getDummyTask();
        if (result == null) {
            result = new OptionalActivityDummyTaskVO();
        }
        result.setCompletion("");
        result.setDescription(optAct.getDescription());
        if (result.getGroupsForTask() == null) {
            result.setGroupsForTask(new HashSet());
        }
        result.setId(optAct.getId());
        result.setTitle(optAct.getTitle());
        if (result.getSubFirstTasks() == null) {
            result.setSubFirstTasks(new HashSet());
        }
        result.getSubFirstTasks().clear();
        if (optAct.getActivities() != null) {
            Iterator iter = optAct.getActivities().iterator();
            while (iter.hasNext()) {
                ActivityDefnVO activity = (ActivityDefnVO)iter.next();
                AbstractTaskVO task = activity.getFirstTask();
                if (task == null) continue;
                result.getSubFirstTasks().add(task);
            }
        }
        result.setOptionalActivity(optAct);
        this.storeInSession(session, result);
        optAct.setDummyTask(result);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

